/*
 * Decompiled with CFR 0.152.
 */
package com.jniwrapper.win32.hook;

import com.jniwrapper.Callback;
import com.jniwrapper.Function;
import com.jniwrapper.Int;
import com.jniwrapper.Parameter;
import com.jniwrapper.UInt32;
import com.jniwrapper.win32.FunctionName;
import com.jniwrapper.win32.Handle;
import com.jniwrapper.win32.MessageLoopThread;
import com.jniwrapper.win32.hook.Hook;
import com.jniwrapper.win32.system.Module;
import com.jniwrapper.win32.ui.User32;

abstract class LowLevelHook
extends Hook {
    private final Handle _hookHandle = new Handle();
    private MessageLoopThread _dispatchThread = new MessageLoopThread("HookDispatchThread");
    private HookProc _callback;

    LowLevelHook(Hook.Descriptor descriptor) {
        super(descriptor);
    }

    public boolean isInstalled() {
        return this._dispatchThread.isStarted();
    }

    public void install() {
        this._dispatchThread.doStart();
        this._callback = new HookProc(this);
        try {
            this._dispatchThread.doInvokeAndWait(new Runnable(){

                public void run() {
                    User32 user32 = User32.getInstance();
                    Function setWindowsHook = user32.getFunction(new FunctionName("SetWindowsHookEx").toString());
                    UInt32 threadID = new UInt32();
                    Module currentModule = Module.getCurrent();
                    setWindowsHook.invoke((Parameter)LowLevelHook.this._hookHandle, new Parameter[]{new Int((long)LowLevelHook.this.getDescriptor().getValue()), LowLevelHook.this._callback, currentModule, threadID});
                }
            });
        }
        catch (Exception e) {
            throw new RuntimeException("Failed to install low level hook", e);
        }
    }

    public void uninstall() {
        try {
            this._dispatchThread.doInvokeAndWait(new Runnable(){

                public void run() {
                    User32 user32 = User32.getInstance();
                    Function unhook = user32.getFunction("UnhookWindowsHookEx");
                    unhook.invoke(null, (Parameter)LowLevelHook.this._hookHandle);
                }
            });
        }
        catch (Exception e) {
            throw new RuntimeException("Failed to uninstall low level hook", e);
        }
        finally {
            this._dispatchThread.doStop();
            this._callback.dispose();
        }
    }

    protected abstract long processEvent(long var1, long var3);

    public void setSynchronous(boolean synchronous) {
    }

    public boolean isSynchronous() {
        return true;
    }

    private static class HookProc
    extends Callback {
        private Int code = new Int();
        private UInt32 wParam = new UInt32();
        private UInt32 lParam = new UInt32();
        private UInt32 lResult = new UInt32();
        private LowLevelHook hook;
        private static Function CallNextHookEx = User32.getInstance().getFunction("CallNextHookEx");

        public HookProc(LowLevelHook hook) {
            if (hook == null) {
                throw new NullPointerException();
            }
            this.hook = hook;
            this.init(new Parameter[]{this.code, this.wParam, this.lParam}, (Parameter)this.lResult);
        }

        public void callback() {
            if (this.code.getValue() < 0L) {
                CallNextHookEx.invoke((Parameter)this.lResult, (Parameter)this.hook._hookHandle, (Parameter)this.code, (Parameter)this.wParam, (Parameter)this.lParam);
            } else {
                long nCode = this.hook.processEvent(this.wParam.getValue(), this.lParam.getValue());
                if (nCode >= 0L) {
                    CallNextHookEx.invoke((Parameter)this.lResult, (Parameter)this.hook._hookHandle, (Parameter)this.code, (Parameter)this.wParam, (Parameter)this.lParam);
                } else {
                    this.lResult.setValue(nCode);
                }
            }
        }
    }
}

