/*
 * Decompiled with CFR 0.152.
 */
package com.jniwrapper.win32.ui.dialogs;

import com.jniwrapper.Function;
import com.jniwrapper.Int;
import com.jniwrapper.LongInt;
import com.jniwrapper.Parameter;
import com.jniwrapper.Pointer;
import com.jniwrapper.Str;
import com.jniwrapper.win32.shell.Shell32;
import com.jniwrapper.win32.shell.ShellIcon;
import com.jniwrapper.win32.system.Kernel32;
import com.jniwrapper.win32.ui.Wnd;
import com.jniwrapper.win32.ui.dialogs.DialogHelper;
import java.awt.Window;
import java.io.File;

public class SelectIconDialog {
    private static final String FUNCTION_PICK_ICON_DIALOG = "PickIconDlg";
    private static final String DEFAULT_ICON_FILE_NAME = Kernel32.getSystemDirectory() + "shell32.dll";
    private File _iconFile = new File(DEFAULT_ICON_FILE_NAME);
    private int _iconIndex = 0;
    private Window _owner = null;

    public SelectIconDialog() {
    }

    public SelectIconDialog(File iconFile) {
        this.setIconFile(iconFile);
    }

    public SelectIconDialog(File iconFile, int iconIndex) {
        this.setIconFile(iconFile);
        this.setIconIndex(iconIndex);
    }

    public SelectIconDialog(Window owner) {
        this.setOwner(owner);
    }

    public SelectIconDialog(Window owner, File iconFile) {
        this.setOwner(owner);
        this.setIconFile(iconFile);
    }

    public SelectIconDialog(Window owner, File iconFile, int iconIndex) {
        this.setOwner(owner);
        this.setIconFile(iconFile);
        this.setIconIndex(iconIndex);
    }

    public void setIconFile(File value) {
        this._iconFile = value.isFile() ? value : new File(DEFAULT_ICON_FILE_NAME);
    }

    public File getIconFile() {
        return this._iconFile;
    }

    public void setIconIndex(int value) {
        this._iconIndex = value;
    }

    public int getIconIndex() {
        return this._iconIndex;
    }

    public ShellIcon getShellIcon() {
        if (this._iconFile.exists()) {
            return new ShellIcon(this._iconFile, this._iconIndex);
        }
        return null;
    }

    public void setOwner(Window value) {
        this._owner = value;
    }

    public Window getOwner() {
        return this._owner;
    }

    public boolean execute() {
        Wnd owner = this._owner != null ? new Wnd(this._owner) : new Wnd();
        Function pickIconDialog = Shell32.getInstance().getFunction(FUNCTION_PICK_ICON_DIALOG);
        Int result = new Int();
        Str sFileName = new Str();
        sFileName.setValue(this.getIconFile().getAbsolutePath());
        LongInt nBuf = new LongInt((long)sFileName.getMaxLength());
        LongInt nIconIndex = new LongInt((long)this.getIconIndex());
        if (this._owner != null) {
            DialogHelper.invokeDialog(this._owner, pickIconDialog, (Parameter)result, new Parameter[]{owner, new Pointer((Parameter)sFileName), nBuf, new Pointer((Parameter)nIconIndex)});
        } else {
            pickIconDialog.invoke((Parameter)result, (Parameter)owner, (Parameter)new Pointer((Parameter)sFileName), (Parameter)nBuf, (Parameter)new Pointer((Parameter)nIconIndex));
        }
        if (result.getValue() != 0L) {
            this.setIconFile(new File(sFileName.getValue()));
            this.setIconIndex((int)nIconIndex.getValue());
            return this.getIconFile().isFile();
        }
        return false;
    }
}

