/*
 * Decompiled with CFR 0.152.
 */
package com.eviware.soapui.actions;

import com.eviware.soapui.actions.Prefs;
import com.eviware.soapui.model.settings.Settings;
import com.eviware.soapui.settings.LoadUISettings;
import com.eviware.soapui.support.components.DirectoryFormComponent;
import com.eviware.soapui.support.components.SimpleForm;
import com.eviware.soapui.support.types.StringToStringMap;
import java.io.File;

public class LoadUIPrefs
implements Prefs {
    public static final String LOADUI_PATH = "loadUI.bat(.sh) folder";
    public static final String LOADUI_CAJO_PORT = "loadUI integration port";
    public static final String SOAPUI_CAJO_PORT = "soapUI integration port";
    private final String title;
    private SimpleForm editorForm;

    public LoadUIPrefs(String title) {
        this.title = title;
    }

    public SimpleForm getForm() {
        if (this.editorForm == null) {
            this.editorForm = new SimpleForm();
            this.editorForm.addSpace(5);
            DirectoryFormComponent directoryFormComponent = new DirectoryFormComponent("Folder containing loadUI.bat(.sh) ");
            directoryFormComponent.setInitialFolder(System.getProperty("soapui.home") + File.separator + ".." + File.separator + "..");
            this.editorForm.append(LOADUI_PATH, directoryFormComponent);
            this.editorForm.appendTextField(LOADUI_CAJO_PORT, "Client port for loadUI integration");
            this.editorForm.appendTextField(SOAPUI_CAJO_PORT, "Server port of soapUI integration (change requires restart of soapUI)");
        }
        return this.editorForm;
    }

    public void getFormValues(Settings settings) {
        StringToStringMap values = new StringToStringMap();
        this.editorForm.getValues(values);
        this.storeValues(values, settings);
    }

    public String getTitle() {
        return this.title;
    }

    public StringToStringMap getValues(Settings settings) {
        StringToStringMap values = new StringToStringMap();
        values.put(LOADUI_PATH, settings.getString(LoadUISettings.LOADUI_PATH, ""));
        values.put(LOADUI_CAJO_PORT, settings.getString(LoadUISettings.LOADUI_CAJO_PORT, "1199"));
        values.put(SOAPUI_CAJO_PORT, settings.getString(LoadUISettings.SOAPUI_CAJO_PORT, "1198"));
        return values;
    }

    public void setFormValues(Settings settings) {
        this.editorForm.setValues(this.getValues(settings));
    }

    public void storeValues(StringToStringMap values, Settings settings) {
        settings.setString(LoadUISettings.LOADUI_PATH, (String)values.get(LOADUI_PATH));
        settings.setString(LoadUISettings.LOADUI_CAJO_PORT, (String)values.get(LOADUI_CAJO_PORT));
        settings.setString(LoadUISettings.SOAPUI_CAJO_PORT, (String)values.get(SOAPUI_CAJO_PORT));
    }
}

