/*
 * Decompiled with CFR 0.152.
 */
package com.eviware.soapui.impl.rest.actions.project;

import com.eviware.soapui.SoapUI;
import com.eviware.soapui.impl.rest.RestService;
import com.eviware.soapui.impl.wsdl.WsdlProject;
import com.eviware.soapui.model.ModelItem;
import com.eviware.soapui.support.MessageSupport;
import com.eviware.soapui.support.UISupport;
import com.eviware.soapui.support.action.support.AbstractSoapUIAction;
import com.eviware.x.form.ValidationMessage;
import com.eviware.x.form.XFormDialog;
import com.eviware.x.form.XFormField;
import com.eviware.x.form.XFormFieldListener;
import com.eviware.x.form.XFormFieldValidator;
import com.eviware.x.form.support.ADialogBuilder;
import com.eviware.x.form.support.AField;
import com.eviware.x.form.support.AForm;
import com.eviware.x.form.validators.RequiredValidator;
import java.net.MalformedURLException;
import java.net.URL;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class NewRestServiceAction
extends AbstractSoapUIAction<WsdlProject> {
    public static final String SOAPUI_ACTION_ID = "NewRestServiceAction";
    public static final MessageSupport messages = MessageSupport.getMessages(NewRestServiceAction.class);
    private XFormDialog dialog;
    private WsdlProject currentProject;

    public NewRestServiceAction() {
        super(messages.get("title"), messages.get("description"));
    }

    @Override
    public void perform(WsdlProject project, Object param) {
        this.currentProject = project;
        if (this.dialog == null) {
            this.dialog = ADialogBuilder.buildDialog(Form.class);
            this.dialog.getFormField(Form.SERVICENAME).addFormFieldValidator(new RequiredValidator("Service Name is required"));
            this.dialog.getFormField(Form.SERVICENAME).addFormFieldValidator(new XFormFieldValidator(){

                public ValidationMessage[] validateField(XFormField formField) {
                    if (NewRestServiceAction.this.currentProject.getInterfaceByName(formField.getValue()) != null) {
                        return new ValidationMessage[]{new ValidationMessage("Service Name must be unique in project", formField)};
                    }
                    return null;
                }
            });
            this.dialog.getFormField(Form.SERVICEENDPOINT).addFormFieldListener(new XFormFieldListener(){

                public void valueChanged(XFormField sourceField, String newValue, String oldValue) {
                    boolean enable = false;
                    try {
                        URL url = new URL(newValue);
                        enable = url.getPath().length() > 0 && (url.getPath().length() != 1 || url.getPath().charAt(0) != '/');
                    }
                    catch (MalformedURLException e) {
                        // empty catch block
                    }
                    NewRestServiceAction.this.dialog.getFormField(Form.EXTRACTPARAMS).setEnabled(enable);
                }
            });
            this.dialog.getFormField(Form.EXTRACTPARAMS).setEnabled(false);
            this.dialog.getFormField(Form.EXTRACTPARAMS).addFormFieldListener(new XFormFieldListener(){

                public void valueChanged(XFormField sourceField, String newValue, String oldValue) {
                    NewRestServiceAction.this.dialog.getFormField(Form.CREATERESOURCE).setEnabled(!NewRestServiceAction.this.dialog.getBooleanValue(Form.EXTRACTPARAMS));
                }
            });
        } else {
            this.dialog.setValue(Form.SERVICEENDPOINT, "");
            this.dialog.setBooleanValue(Form.EXTRACTPARAMS, false);
        }
        if (param instanceof ModelItem) {
            this.dialog.setValue(Form.SERVICENAME, ((ModelItem)param).getName());
        } else if (param instanceof URL) {
            URL url = (URL)param;
            this.dialog.setValue(Form.SERVICENAME, url.getHost());
            this.dialog.setValue(Form.SERVICEENDPOINT, url.toString());
            this.dialog.setBooleanValue(Form.EXTRACTPARAMS, true);
            this.dialog.setBooleanValue(Form.CREATERESOURCE, false);
            this.dialog.getFormField(Form.EXTRACTPARAMS).setEnabled(true);
        }
        if (this.dialog.show()) {
            RestService restService = (RestService)project.addNewInterface(this.dialog.getValue(Form.SERVICENAME), "rest");
            UISupport.select(restService);
            URL url = null;
            try {
                url = new URL(this.dialog.getValue(Form.SERVICEENDPOINT));
                String endpoint = url.getProtocol() + "://" + url.getHost();
                if (url.getPort() > 0) {
                    endpoint = endpoint + ":" + url.getPort();
                }
                restService.addEndpoint(endpoint);
                restService.setBasePath(url.getPath());
            }
            catch (Exception e) {
                // empty catch block
            }
            if (this.dialog.getFormField(Form.EXTRACTPARAMS).isEnabled() && this.dialog.getBooleanValue(Form.EXTRACTPARAMS)) {
                restService.setBasePath("");
                SoapUI.getActionRegistry().getAction("NewRestResourceAction").perform(restService, url);
            }
            if (this.dialog.getFormField(Form.CREATERESOURCE).isEnabled() && this.dialog.getBooleanValue(Form.CREATERESOURCE)) {
                SoapUI.getActionRegistry().getAction("NewRestResourceAction").perform(restService, null);
            }
        }
    }

    @AForm(name="Form.Title", description="Form.Description", helpUrl="http://www.soapui.org/userguide/rest/index.html", icon="/applications-system.png")
    public static interface Form {
        @AField(description="Form.ServiceName.Description", type=AField.AFieldType.STRING)
        public static final String SERVICENAME = messages.get("Form.ServiceName.Label");
        @AField(description="Form.ServiceUrl.Description", type=AField.AFieldType.STRING)
        public static final String SERVICEENDPOINT = messages.get("Form.ServiceUrl.Label");
        @AField(description="Form.ExtractParams.Description", type=AField.AFieldType.BOOLEAN)
        public static final String EXTRACTPARAMS = messages.get("Form.ExtractParams.Label");
        @AField(description="Form.CreateResource.Description", type=AField.AFieldType.BOOLEAN)
        public static final String CREATERESOURCE = messages.get("Form.CreateResource.Label");
    }
}

