/*
 * Decompiled with CFR 0.152.
 */
package com.eviware.soapui.impl.rest.actions.support;

import com.eviware.soapui.SoapUI;
import com.eviware.soapui.config.RestParametersConfig;
import com.eviware.soapui.impl.rest.RestMethod;
import com.eviware.soapui.impl.rest.RestRequest;
import com.eviware.soapui.impl.rest.RestResource;
import com.eviware.soapui.impl.rest.panels.resource.RestParamsTable;
import com.eviware.soapui.impl.rest.panels.resource.RestParamsTableModel;
import com.eviware.soapui.impl.rest.support.RestParamProperty;
import com.eviware.soapui.impl.rest.support.RestParamsPropertyHolder;
import com.eviware.soapui.impl.rest.support.RestUtils;
import com.eviware.soapui.impl.rest.support.XmlBeansRestParamsTestPropertyHolder;
import com.eviware.soapui.model.ModelItem;
import com.eviware.soapui.support.MessageSupport;
import com.eviware.soapui.support.StringUtils;
import com.eviware.soapui.support.UISupport;
import com.eviware.soapui.support.action.support.AbstractSoapUIAction;
import com.eviware.x.form.XFormDialog;
import com.eviware.x.form.support.ADialogBuilder;
import com.eviware.x.form.support.AField;
import com.eviware.x.form.support.AForm;
import com.eviware.x.form.validators.RequiredValidator;
import java.awt.event.ActionEvent;
import java.net.MalformedURLException;
import java.net.URL;
import java.util.HashMap;
import java.util.Map;
import javax.swing.AbstractAction;
import javax.swing.DefaultCellEditor;
import javax.swing.JComboBox;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public abstract class NewRestResourceActionBase<T extends ModelItem>
extends AbstractSoapUIAction<T> {
    private XFormDialog dialog;
    private XmlBeansRestParamsTestPropertyHolder params;
    private InternalRestParamsTable paramsTable;
    public static final MessageSupport messages = MessageSupport.getMessages(NewRestResourceActionBase.class);

    public NewRestResourceActionBase(String title, String description) {
        super(title, description);
    }

    @Override
    public void perform(T service, Object param) {
        String path;
        if (this.dialog == null) {
            this.dialog = ADialogBuilder.buildDialog(Form.class);
            this.dialog.getFormField(Form.RESOURCENAME).addFormFieldValidator(new RequiredValidator());
            this.dialog.getFormField(Form.EXTRACTPARAMS).setProperty("action", new ExtractParamsAction());
        } else {
            this.dialog.setValue(Form.RESOURCENAME, "");
            this.dialog.setValue(Form.RESOURCEPATH, "");
        }
        this.params = new XmlBeansRestParamsTestPropertyHolder(null, RestParametersConfig.Factory.newInstance());
        if (param instanceof URL) {
            path = RestUtils.extractParams(param.toString(), this.params, false);
            this.dialog.setValue(Form.RESOURCEPATH, path);
            this.setNameFromPath(path);
            if (this.paramsTable != null) {
                this.paramsTable.refresh();
            }
        }
        this.paramsTable = new InternalRestParamsTable((RestParamsPropertyHolder)this.params, ParamLocation.RESOURCE);
        this.dialog.getFormField(Form.PARAMSTABLE).setProperty("component", this.paramsTable);
        if (this.dialog.show()) {
            path = this.dialog.getValue(Form.RESOURCEPATH);
            try {
                URL url = new URL(path);
                path = url.getPath();
            }
            catch (MalformedURLException e) {
                // empty catch block
            }
            RestResource resource = this.createRestResource(service, path, this.dialog);
            this.paramsTable.extractParams(resource.getParams(), ParamLocation.RESOURCE);
            XmlBeansRestParamsTestPropertyHolder methodParams = new XmlBeansRestParamsTestPropertyHolder(null, RestParametersConfig.Factory.newInstance());
            this.paramsTable.extractParams(methodParams, ParamLocation.METHOD);
            SoapUI.getActionRegistry().getAction("NewRestMethodAction").perform(resource, methodParams);
        }
        this.paramsTable.release();
        this.paramsTable = null;
        this.params = null;
        this.dialog.getFormField(Form.PARAMSTABLE).setProperty("component", this.paramsTable);
    }

    protected abstract RestResource createRestResource(T var1, String var2, XFormDialog var3);

    protected abstract RestMethod createRestMethod(RestResource var1, XFormDialog var2);

    private void setNameFromPath(String path) {
        String[] items = path.split("/");
        if (items.length > 0) {
            this.dialog.setValue(Form.RESOURCENAME, items[items.length - 1]);
        }
    }

    protected void createRequest(RestMethod method) {
        RestRequest request = method.addNewRequest("Request " + (method.getRequestCount() + 1));
        UISupport.showDesktopPanel(request);
    }

    @AForm(name="Form.Title", description="Form.Description", helpUrl="http://www.soapui.org/userguide/rest/index.html", icon="/applications-system.png")
    public static interface Form {
        @AField(description="Form.ServiceName.Description", type=AField.AFieldType.STRING)
        public static final String RESOURCENAME = messages.get("Form.ResourceName.Label");
        @AField(description="Form.ServiceUrl.Description", type=AField.AFieldType.STRING)
        public static final String RESOURCEPATH = messages.get("Form.ResourcePath.Label");
        @AField(description="Form.ExtractParams.Description", type=AField.AFieldType.ACTION)
        public static final String EXTRACTPARAMS = messages.get("Form.ExtractParams.Label");
        @AField(description="Form.ParamsTable.Description", type=AField.AFieldType.COMPONENT)
        public static final String PARAMSTABLE = messages.get("Form.ParamsTable.Label");
    }

    private class ExtractParamsAction
    extends AbstractAction {
        public ExtractParamsAction() {
            super("Extract Params");
        }

        public void actionPerformed(ActionEvent e) {
            try {
                String path = RestUtils.extractParams(NewRestResourceActionBase.this.dialog.getValue(Form.RESOURCEPATH), NewRestResourceActionBase.this.params, false);
                NewRestResourceActionBase.this.dialog.setValue(Form.RESOURCEPATH, path);
                if (StringUtils.isNullOrEmpty(NewRestResourceActionBase.this.dialog.getValue(Form.RESOURCENAME))) {
                    NewRestResourceActionBase.this.setNameFromPath(path);
                }
                NewRestResourceActionBase.this.paramsTable.refresh();
            }
            catch (Exception e1) {
                UISupport.showInfoMessage("No parameters to extract!");
            }
        }
    }

    public static class InternalRestParamsTable
    extends RestParamsTable {
        private ParamLocation defaultLocation;

        public InternalRestParamsTable(RestParamsPropertyHolder params, ParamLocation defaultLocation) {
            super(params, false);
            this.defaultLocation = defaultLocation;
        }

        public void extractParams(RestParamsPropertyHolder params, ParamLocation location) {
            for (int i = 0; i < this.paramsTable.getRowCount(); ++i) {
                RestParamProperty prop = this.paramsTableModel.getParameterAt(i);
                if (((InternalRestParamsTableModel)this.paramsTableModel).getParamLocationAt(i) != location) continue;
                params.addParameter(prop);
            }
        }

        protected RestParamsTableModel createTableModel(RestParamsPropertyHolder params) {
            return new InternalRestParamsTableModel(params);
        }

        protected void init(RestParamsPropertyHolder params, boolean showInspector) {
            super.init(params, showInspector);
            this.paramsTable.setDefaultEditor(ParamLocation.class, new DefaultCellEditor(new JComboBox<Object>(new Object[]{ParamLocation.RESOURCE, ParamLocation.METHOD})));
        }

        /*
         * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
         */
        public class InternalRestParamsTableModel
        extends RestParamsTableModel {
            private Map<RestParamProperty, ParamLocation> locations;
            private int columnCount;

            public InternalRestParamsTableModel(RestParamsPropertyHolder params) {
                super(params);
                this.locations = new HashMap<RestParamProperty, ParamLocation>();
                this.columnCount = super.getColumnCount();
            }

            @Override
            public int getColumnCount() {
                return this.columnCount + 1;
            }

            public ParamLocation getParamLocationAt(int rowIndex) {
                return (ParamLocation)((Object)this.getValueAt(rowIndex, this.columnCount));
            }

            @Override
            public Object getValueAt(int rowIndex, int columnIndex) {
                if (columnIndex != this.columnCount) {
                    return super.getValueAt(rowIndex, columnIndex);
                }
                RestParamProperty name = this.params.getPropertyAt(rowIndex);
                if (!this.locations.containsKey(name)) {
                    this.locations.put(name, InternalRestParamsTable.this.defaultLocation);
                }
                return this.locations.get(name);
            }

            @Override
            public String getColumnName(int column) {
                return column != this.columnCount ? super.getColumnName(column) : "Location";
            }

            @Override
            public Class<?> getColumnClass(int columnIndex) {
                return columnIndex != this.columnCount ? super.getColumnClass(columnIndex) : ParamLocation.class;
            }

            @Override
            public void setValueAt(Object value, int rowIndex, int columnIndex) {
                if (columnIndex != this.columnCount) {
                    super.setValueAt(value, rowIndex, columnIndex);
                } else {
                    RestParamProperty name = this.params.getPropertyAt(rowIndex);
                    this.locations.put(name, (ParamLocation)((Object)value));
                }
            }
        }
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    public static enum ParamLocation {
        RESOURCE,
        METHOD;

    }
}

