/*
 * Decompiled with CFR 0.152.
 */
package com.eviware.soapui.impl.rest.panels.method;

import com.eviware.soapui.impl.rest.RestMethod;
import com.eviware.soapui.impl.rest.RestRepresentation;
import com.eviware.soapui.impl.rest.RestRequestInterface;
import com.eviware.soapui.impl.rest.panels.method.RestRepresentationsTable;
import com.eviware.soapui.impl.rest.panels.resource.RestParamsTable;
import com.eviware.soapui.impl.support.actions.ShowOnlineHelpAction;
import com.eviware.soapui.model.ModelItem;
import com.eviware.soapui.support.UISupport;
import com.eviware.soapui.support.action.swing.SwingActionDelegate;
import com.eviware.soapui.support.components.JXToolBar;
import com.eviware.soapui.ui.support.ModelItemDesktopPanel;
import java.awt.Component;
import java.awt.event.ItemEvent;
import java.awt.event.ItemListener;
import java.beans.PropertyChangeEvent;
import javax.swing.JComboBox;
import javax.swing.JTabbedPane;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class RestMethodDesktopPanel
extends ModelItemDesktopPanel<RestMethod> {
    private RestParamsTable paramsTable;
    private boolean updatingRequest;
    private JComboBox methodCombo;
    private RestRepresentationsTable restRepresentationsTable;

    public RestMethodDesktopPanel(RestMethod modelItem) {
        super(modelItem);
        this.add(this.buildToolbar(), "North");
        this.add(this.buildContent(), "Center");
    }

    private Component buildContent() {
        JTabbedPane tabs = new JTabbedPane();
        this.paramsTable = new RestParamsTable(((RestMethod)this.getModelItem()).getParams(), true);
        tabs.addTab("Method Parameters", this.paramsTable);
        this.restRepresentationsTable = new RestRepresentationsTable((RestMethod)this.getModelItem(), new RestRepresentation.Type[]{RestRepresentation.Type.REQUEST, RestRepresentation.Type.RESPONSE, RestRepresentation.Type.FAULT}, false);
        tabs.addTab("Representations", this.restRepresentationsTable);
        return UISupport.createTabPanel(tabs, false);
    }

    @Override
    public String getTitle() {
        return this.getName((RestMethod)this.getModelItem());
    }

    public RestParamsTable getParamsTable() {
        return this.paramsTable;
    }

    @Override
    protected boolean release() {
        this.paramsTable.release();
        this.restRepresentationsTable.release();
        return super.release();
    }

    private String getName(RestMethod modelItem) {
        return modelItem.getName();
    }

    private Component buildToolbar() {
        JXToolBar toolbar = UISupport.createToolbar();
        this.methodCombo = new JComboBox<RestRequestInterface.RequestMethod>(RestRequestInterface.RequestMethod.getMethods());
        this.methodCombo.setSelectedItem((Object)((RestMethod)this.getModelItem()).getMethod());
        this.methodCombo.setToolTipText("Set desired HTTP method");
        this.methodCombo.addItemListener(new ItemListener(){

            public void itemStateChanged(ItemEvent e) {
                RestMethodDesktopPanel.this.updatingRequest = true;
                ((RestMethod)RestMethodDesktopPanel.this.getModelItem()).setMethod((RestRequestInterface.RequestMethod)((Object)RestMethodDesktopPanel.this.methodCombo.getSelectedItem()));
                RestMethodDesktopPanel.this.updatingRequest = false;
            }
        });
        toolbar.addLabeledFixed("HTTP method", this.methodCombo);
        toolbar.addSeparator();
        toolbar.addFixed(RestMethodDesktopPanel.createActionButton(SwingActionDelegate.createDelegate("NewRestRequestAction", this.getModelItem(), null, "/create_empty_request.gif"), true));
        toolbar.addSeparator();
        toolbar.addGlue();
        toolbar.add(UISupport.createToolbarButton(new ShowOnlineHelpAction("http://www.soapui.org/userguide/rest/methods.html")));
        return toolbar;
    }

    @Override
    public boolean dependsOn(ModelItem modelItem) {
        return ((RestMethod)this.getModelItem()).dependsOn(modelItem);
    }

    @Override
    public boolean onClose(boolean canCancel) {
        return this.release();
    }

    @Override
    public void propertyChange(PropertyChangeEvent evt) {
        super.propertyChange(evt);
        if (evt.getPropertyName().equals("method") && !this.updatingRequest) {
            this.methodCombo.setSelectedItem(evt.getNewValue());
        }
    }
}

