/*
 * Decompiled with CFR 0.152.
 */
package com.eviware.soapui.impl.rest.panels.request;

import com.eviware.soapui.config.CredentialsConfig;
import com.eviware.soapui.impl.EmptyPanelBuilder;
import com.eviware.soapui.impl.rest.RestRequest;
import com.eviware.soapui.impl.rest.panels.request.RestRequestDesktopPanel;
import com.eviware.soapui.support.components.JPropertiesTable;
import com.eviware.soapui.support.types.StringList;
import java.awt.Component;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class RestRequestPanelBuilder
extends EmptyPanelBuilder<RestRequest> {
    public RestRequestDesktopPanel buildDesktopPanel(RestRequest request) {
        return new RestRequestDesktopPanel(request);
    }

    @Override
    public boolean hasDesktopPanel() {
        return true;
    }

    @Override
    public Component buildOverviewPanel(RestRequest request) {
        JPropertiesTable<RestRequest> table = new JPropertiesTable<RestRequest>("Request Properties");
        table.addProperty("Name", "name");
        table.addProperty("Description", "description", true);
        table.addProperty("Encoding", "encoding", new String[]{null, "UTF-8", "iso-8859-1"});
        table.addProperty("Endpoint", "endpoint", request.getOperation().getInterface().getEndpoints());
        table.addProperty("Timeout", "timeout", true);
        table.addProperty("Bind Address", "bindAddress", true);
        table.addProperty("Follow Redirects", "followRedirects", JPropertiesTable.BOOLEAN_OPTIONS);
        table.addProperty("Username", "username", true);
        table.addPropertyShadow("Password", "password", true);
        table.addProperty("Domain", "domain", true);
        table.addProperty("Authentication Type", "authType", new String[]{CredentialsConfig.AuthType.GLOBAL_HTTP_SETTINGS.toString(), CredentialsConfig.AuthType.PREEMPTIVE.toString(), CredentialsConfig.AuthType.NTLM_KERBEROS.toString()});
        StringList keystores = new StringList(request.getOperation().getInterface().getProject().getWssContainer().getCryptoNames());
        keystores.add("");
        table.addProperty("SSL Keystore", "sslKeystore", keystores.toStringArray());
        table.addProperty("Strip whitespaces", "stripWhitespaces", JPropertiesTable.BOOLEAN_OPTIONS);
        table.addProperty("Remove Empty Content", "removeEmptyContent", JPropertiesTable.BOOLEAN_OPTIONS);
        table.addProperty("Entitize Properties", "entitizeProperties", JPropertiesTable.BOOLEAN_OPTIONS);
        table.addProperty("Multi-Value Delimiter", "multiValueDelimiter", true);
        table.addProperty("Pretty Print", "prettyPrint", JPropertiesTable.BOOLEAN_OPTIONS);
        table.addProperty("Dump File", "dumpFile").setDescription("Dumps response message to specified file");
        table.addProperty("Max Size", "maxSize", true).setDescription("The maximum number of bytes to receive");
        table.setPropertyObject(request);
        return table;
    }

    @Override
    public boolean hasOverviewPanel() {
        return true;
    }
}

