/*
 * Decompiled with CFR 0.152.
 */
package com.eviware.soapui.impl.rest.panels.request.views.json;

import com.eviware.soapui.impl.rest.support.handlers.JsonMediaTypeHandler;
import com.eviware.soapui.impl.support.AbstractHttpRequestInterface;
import com.eviware.soapui.impl.support.http.HttpRequestInterface;
import com.eviware.soapui.impl.support.panels.AbstractHttpXmlRequestDesktopPanel;
import com.eviware.soapui.impl.wsdl.submit.transports.http.HttpResponse;
import com.eviware.soapui.support.UISupport;
import com.eviware.soapui.support.components.JXToolBar;
import com.eviware.soapui.support.editor.views.AbstractXmlEditorView;
import com.eviware.soapui.support.xml.SyntaxEditorUtil;
import java.awt.BorderLayout;
import java.awt.Component;
import java.beans.PropertyChangeEvent;
import java.beans.PropertyChangeListener;
import javax.swing.JComponent;
import javax.swing.JPanel;
import net.sf.json.JSON;
import net.sf.json.JSONSerializer;
import org.fife.ui.rsyntaxtextarea.RSyntaxTextArea;
import org.fife.ui.rtextarea.RTextArea;
import org.fife.ui.rtextarea.RTextScrollPane;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class JsonResponseView
extends AbstractXmlEditorView<AbstractHttpXmlRequestDesktopPanel.HttpResponseDocument>
implements PropertyChangeListener {
    private final HttpRequestInterface<?> httpRequest;
    private JPanel contentPanel;
    private RSyntaxTextArea contentEditor;
    private boolean updatingRequest;
    private JPanel panel;

    public JsonResponseView(AbstractHttpXmlRequestDesktopPanel.HttpResponseMessageEditor httpRequestMessageEditor, HttpRequestInterface<?> httpRequest) {
        super("JSON", httpRequestMessageEditor, "JSON Response");
        this.httpRequest = httpRequest;
        httpRequest.addPropertyChangeListener(this);
    }

    @Override
    public JComponent getComponent() {
        if (this.panel == null) {
            this.panel = new JPanel(new BorderLayout());
            this.panel.add(this.buildToolbar(), "North");
            this.panel.add(this.buildContent(), "Center");
            this.panel.add(this.buildStatus(), "South");
        }
        return this.panel;
    }

    @Override
    public void release() {
        super.release();
        this.httpRequest.removePropertyChangeListener(this);
    }

    private Component buildStatus() {
        return new JPanel();
    }

    private Component buildContent() {
        this.contentPanel = new JPanel(new BorderLayout());
        this.contentEditor = SyntaxEditorUtil.createDefaultJavaScriptSyntaxTextArea();
        HttpResponse response = this.httpRequest.getResponse();
        if (response != null) {
            this.setEditorContent(response);
        }
        RTextScrollPane scrollPane = new RTextScrollPane((RTextArea)this.contentEditor);
        scrollPane.setFoldIndicatorEnabled(true);
        scrollPane.setLineNumbersEnabled(true);
        this.contentPanel.add((Component)scrollPane);
        this.contentEditor.setEditable(false);
        return this.contentPanel;
    }

    protected void setEditorContent(HttpResponse httpResponse) {
        if (httpResponse == null) {
            this.contentEditor.setText("");
        } else {
            String content = "<Not JSON content>";
            if (JsonMediaTypeHandler.couldBeJsonContent(httpResponse.getContentType())) {
                try {
                    JSON json = JSONSerializer.toJSON((Object)httpResponse.getContentAsString());
                    content = json.isEmpty() ? "<Empty JSON content>" : json.toString(3);
                }
                catch (Throwable e) {
                    if (!"Invalid JSON String".equals(e.getMessage())) {
                        e.printStackTrace();
                    }
                    content = httpResponse.getContentAsString();
                }
                this.contentEditor.setText(content);
            } else {
                this.contentEditor.setText("<Not JSON content>");
            }
        }
    }

    private Component buildToolbar() {
        JXToolBar toolbar = UISupport.createToolbar();
        return toolbar;
    }

    @Override
    public void propertyChange(PropertyChangeEvent evt) {
        if (evt.getPropertyName().equals(AbstractHttpRequestInterface.RESPONSE_PROPERTY) && !this.updatingRequest) {
            this.setEditorContent((HttpResponse)evt.getNewValue());
        }
    }

    @Override
    public void setXml(String xml) {
    }

    @Override
    public boolean saveDocument(boolean validate) {
        return false;
    }

    @Override
    public void setEditable(boolean enabled) {
    }
}

