/*
 * Decompiled with CFR 0.152.
 */
package com.eviware.soapui.impl.rest.panels.resource;

import com.eviware.soapui.impl.rest.panels.resource.RestParamsTable;
import com.eviware.soapui.impl.rest.panels.resource.RestParamsTableModel;
import com.eviware.soapui.impl.rest.support.RestParamProperty;
import com.eviware.soapui.impl.rest.support.RestParamsPropertyHolder;
import com.eviware.soapui.impl.support.actions.ShowOnlineHelpAction;
import com.eviware.soapui.support.UISupport;
import com.eviware.soapui.support.components.JXToolBar;
import java.awt.Component;
import javax.swing.JScrollPane;
import javax.swing.JTable;

public class InstanceRestParamsTable
extends RestParamsTable {
    private JTable paramsTable;

    public InstanceRestParamsTable(RestParamsPropertyHolder params) {
        super(params, false);
    }

    public JTable getParamsTable() {
        return this.paramsTable;
    }

    protected void init(RestParamsPropertyHolder params, boolean showInspector) {
        this.paramsTableModel = new InstanceRestParamsTableModel(params);
        this.paramsTable = new JTable(this.paramsTableModel);
        this.paramsTable.setRowHeight(19);
        this.paramsTable.setSelectionMode(0);
        this.add(this.buildToolbar(), "North");
        this.add((Component)new JScrollPane(this.paramsTable), "Center");
    }

    protected Component buildToolbar() {
        JXToolBar toolbar = UISupport.createToolbar();
        toolbar.add(UISupport.createToolbarButton(this.defaultParamsAction, this.paramsTable.getRowCount() > 0));
        toolbar.add(UISupport.createToolbarButton(this.clearParamsAction, this.paramsTable.getRowCount() > 0));
        toolbar.addSeparator();
        this.insertAdditionalButtons(toolbar);
        toolbar.addGlue();
        toolbar.add(UISupport.createToolbarButton(new ShowOnlineHelpAction("http://www.soapui.org/userguide/rest/params.html")));
        return toolbar;
    }

    private class InstanceRestParamsTableModel
    extends RestParamsTableModel {
        public InstanceRestParamsTableModel(RestParamsPropertyHolder params) {
            super(params);
        }

        public boolean isCellEditable(int rowIndex, int columnIndex) {
            return columnIndex == 1;
        }

        public int getColumnCount() {
            return 2;
        }

        public String getColumnName(int column) {
            switch (column) {
                case 0: {
                    return "Name";
                }
                case 1: {
                    return "Value";
                }
            }
            return null;
        }

        public Object getValueAt(int rowIndex, int columnIndex) {
            RestParamProperty prop = this.params.getPropertyAt(rowIndex);
            switch (columnIndex) {
                case 0: {
                    return prop.getName();
                }
                case 1: {
                    return prop.getValue();
                }
            }
            return null;
        }

        public void setValueAt(Object value, int rowIndex, int columnIndex) {
            RestParamProperty prop = this.params.getPropertyAt(rowIndex);
            switch (columnIndex) {
                case 0: {
                    this.params.renameProperty(prop.getName(), value.toString());
                    return;
                }
                case 1: {
                    prop.setValue(value.toString());
                    return;
                }
            }
        }
    }
}

