/*
 * Decompiled with CFR 0.152.
 */
package com.eviware.soapui.impl.support;

import com.eviware.soapui.SoapUI;
import com.eviware.soapui.config.EndpointsConfig;
import com.eviware.soapui.config.InterfaceConfig;
import com.eviware.soapui.impl.support.definition.support.AbstractDefinitionContext;
import com.eviware.soapui.impl.wsdl.AbstractWsdlModelItem;
import com.eviware.soapui.impl.wsdl.WsdlProject;
import com.eviware.soapui.model.ModelItem;
import com.eviware.soapui.model.iface.Interface;
import com.eviware.soapui.model.iface.InterfaceListener;
import com.eviware.soapui.model.iface.Operation;
import com.eviware.soapui.model.iface.Request;
import java.util.Arrays;
import java.util.HashSet;
import java.util.List;
import java.util.Set;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public abstract class AbstractInterface<T extends InterfaceConfig>
extends AbstractWsdlModelItem<T>
implements Interface {
    private Set<InterfaceListener> interfaceListeners = new HashSet<InterfaceListener>();

    protected AbstractInterface(T config, ModelItem parent, String icon) {
        super(config, parent, icon);
        if (config.getEndpoints() == null) {
            config.addNewEndpoints();
        }
        for (InterfaceListener listener : SoapUI.getListenerRegistry().getListeners(InterfaceListener.class)) {
            this.addInterfaceListener(listener);
        }
        if (!config.isSetDefinitionCache()) {
            config.addNewDefinitionCache();
        }
    }

    @Override
    public WsdlProject getProject() {
        return (WsdlProject)this.getParent();
    }

    @Override
    public T getConfig() {
        return (T)((InterfaceConfig)super.getConfig());
    }

    @Override
    public List<? extends ModelItem> getChildren() {
        return this.getOperationList();
    }

    @Override
    public String[] getEndpoints() {
        EndpointsConfig endpoints = this.getConfig().getEndpoints();
        List endpointArray = endpoints.getEndpointList();
        return endpointArray.toArray(new String[endpointArray.size()]);
    }

    @Override
    public void addEndpoint(String endpoint) {
        if (endpoint == null || endpoint.trim().length() == 0) {
            return;
        }
        endpoint = endpoint.trim();
        String[] endpoints = this.getEndpoints();
        if (Arrays.asList(endpoints).contains(endpoint)) {
            return;
        }
        this.getConfig().getEndpoints().addNewEndpoint().setStringValue(endpoint);
        this.notifyPropertyChanged(ENDPOINT_PROPERTY, null, endpoint);
    }

    @Override
    public void changeEndpoint(String oldEndpoint, String newEndpoint) {
        if (oldEndpoint == null || oldEndpoint.trim().length() == 0) {
            return;
        }
        if (newEndpoint == null || newEndpoint.trim().length() == 0) {
            return;
        }
        EndpointsConfig endpoints = this.getConfig().getEndpoints();
        for (int c = 0; c < endpoints.sizeOfEndpointArray(); ++c) {
            if (!endpoints.getEndpointArray(c).equals(oldEndpoint)) continue;
            endpoints.setEndpointArray(c, newEndpoint);
            this.notifyPropertyChanged(ENDPOINT_PROPERTY, oldEndpoint, newEndpoint);
            break;
        }
    }

    @Override
    public void removeEndpoint(String endpoint) {
        EndpointsConfig endpoints = this.getConfig().getEndpoints();
        for (int c = 0; c < endpoints.sizeOfEndpointArray(); ++c) {
            if (!endpoints.getEndpointArray(c).equals(endpoint)) continue;
            endpoints.removeEndpoint(c);
            this.notifyPropertyChanged(ENDPOINT_PROPERTY, endpoint, null);
            break;
        }
    }

    public void fireOperationAdded(Operation operation) {
        InterfaceListener[] a = this.interfaceListeners.toArray(new InterfaceListener[this.interfaceListeners.size()]);
        for (int c = 0; c < a.length; ++c) {
            a[c].operationAdded(operation);
        }
    }

    public void fireOperationUpdated(Operation operation) {
        InterfaceListener[] a = this.interfaceListeners.toArray(new InterfaceListener[this.interfaceListeners.size()]);
        for (int c = 0; c < a.length; ++c) {
            a[c].operationUpdated(operation);
        }
    }

    public void fireOperationRemoved(Operation operation) {
        InterfaceListener[] a = this.interfaceListeners.toArray(new InterfaceListener[this.interfaceListeners.size()]);
        for (int c = 0; c < a.length; ++c) {
            a[c].operationRemoved(operation);
        }
    }

    public void fireRequestAdded(Request request) {
        InterfaceListener[] a = this.interfaceListeners.toArray(new InterfaceListener[this.interfaceListeners.size()]);
        for (int c = 0; c < a.length; ++c) {
            a[c].requestAdded(request);
        }
    }

    public void fireRequestRemoved(Request request) {
        InterfaceListener[] a = this.interfaceListeners.toArray(new InterfaceListener[this.interfaceListeners.size()]);
        for (int c = 0; c < a.length; ++c) {
            a[c].requestRemoved(request);
        }
    }

    @Override
    public void addInterfaceListener(InterfaceListener listener) {
        this.interfaceListeners.add(listener);
    }

    @Override
    public void removeInterfaceListener(InterfaceListener listener) {
        this.interfaceListeners.remove(listener);
    }

    @Override
    public void release() {
        super.release();
        this.interfaceListeners.clear();
    }

    public abstract AbstractDefinitionContext getDefinitionContext();

    public abstract String getDefinition();

    public abstract String getType();

    public abstract boolean isDefinitionShareble();

    @Override
    public Operation[] getAllOperations() {
        return this.getOperationList().toArray(new Operation[this.getOperationCount()]);
    }
}

