/*
 * Decompiled with CFR 0.152.
 */
package com.eviware.soapui.impl.wsdl;

import com.eviware.soapui.SoapUI;
import com.eviware.soapui.config.ModelItemConfig;
import com.eviware.soapui.impl.settings.XmlBeansSettingsImpl;
import com.eviware.soapui.impl.wsdl.support.ExternalDependency;
import com.eviware.soapui.model.ModelItem;
import com.eviware.soapui.model.support.AbstractAnimatableModelItem;
import com.eviware.soapui.model.support.ModelSupport;
import com.eviware.soapui.support.StringUtils;
import com.eviware.soapui.support.UISupport;
import com.eviware.soapui.support.resolver.ResolveContext;
import java.util.ArrayList;
import java.util.Collection;
import java.util.List;
import javax.swing.ImageIcon;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public abstract class AbstractWsdlModelItem<T extends ModelItemConfig>
extends AbstractAnimatableModelItem<ModelItemConfig> {
    private XmlBeansSettingsImpl settings;
    private T config;
    private ImageIcon icon;
    private final ModelItem parent;

    protected AbstractWsdlModelItem(T config, ModelItem parent, String icon) {
        this.parent = parent;
        if (config != null) {
            this.setConfig(config);
        }
        if (icon != null) {
            this.icon = UISupport.createImageIcon(icon);
        }
    }

    public boolean dependsOn(ModelItem modelItem) {
        return ModelSupport.dependsOn(this, modelItem);
    }

    @Override
    public ModelItem getParent() {
        return this.parent;
    }

    @Override
    public ImageIcon getIcon() {
        return this.icon;
    }

    @Override
    public void setIcon(ImageIcon icon) {
        if (icon == this.icon) {
            return;
        }
        ImageIcon oldIcon = this.icon;
        this.icon = icon;
        this.notifyPropertyChanged(ICON_PROPERTY, oldIcon, icon);
    }

    @Override
    public String getDescription() {
        String description = this.config.getDescription();
        return StringUtils.hasContent(description) ? description : "";
    }

    public void setDescription(String description) {
        String old = this.getDescription();
        if (String.valueOf(old).equals(description)) {
            return;
        }
        this.config.setDescription(description);
        this.notifyPropertyChanged(DESCRIPTION_PROPERTY, old, description);
    }

    @Override
    public String getName() {
        return this.config.getName();
    }

    public void setName(String name) {
        String old = this.getName();
        name = name.trim();
        this.config.setName(name);
        this.notifyPropertyChanged(NAME_PROPERTY, old, name);
    }

    @Override
    public XmlBeansSettingsImpl getSettings() {
        return this.settings;
    }

    public T getConfig() {
        return this.config;
    }

    public void setConfig(T config) {
        this.config = config;
        if (config != null && config.isSetName()) {
            config.setName(config.getName().trim());
        }
        if (this.settings != null) {
            this.settings.release();
        }
        if (!config.isSetSettings()) {
            config.addNewSettings();
        }
        this.settings = new XmlBeansSettingsImpl(this, this.parent == null ? SoapUI.getSettings() : this.parent.getSettings(), this.config.getSettings());
    }

    @Override
    public String getId() {
        if (!this.config.isSetId()) {
            this.config.setId(ModelSupport.generateModelItemID());
        }
        return this.config.getId();
    }

    protected void setSettings(XmlBeansSettingsImpl settings) {
        if (this.settings != null) {
            this.settings.release();
        }
        this.settings = settings;
    }

    public AbstractWsdlModelItem<?> getWsdlModelItemByName(Collection<? extends AbstractWsdlModelItem<?>> items, String name) {
        for (AbstractWsdlModelItem<?> item : items) {
            if (item.getName() == null || !item.getName().equals(name)) continue;
            return item;
        }
        return null;
    }

    public void release() {
        if (this.settings != null) {
            this.settings.release();
        }
    }

    public void resolve(ResolveContext<?> context) {
        List<? extends ModelItem> children = this.getChildren();
        if (children == null) {
            return;
        }
        for (ModelItem modelItem : children) {
            if (!(modelItem instanceof AbstractWsdlModelItem)) continue;
            ((AbstractWsdlModelItem)modelItem).resolve(context);
        }
    }

    public List<ExternalDependency> getExternalDependencies() {
        ArrayList<ExternalDependency> result = new ArrayList<ExternalDependency>();
        this.addExternalDependencies(result);
        return result;
    }

    protected void addExternalDependencies(List<ExternalDependency> dependencies) {
        List<? extends ModelItem> children = this.getChildren();
        if (children == null) {
            return;
        }
        for (ModelItem modelItem : children) {
            if (!(modelItem instanceof AbstractWsdlModelItem)) continue;
            ((AbstractWsdlModelItem)modelItem).addExternalDependencies(dependencies);
        }
    }

    public void beforeSave() {
        List<? extends ModelItem> children = this.getChildren();
        if (children == null) {
            return;
        }
        for (ModelItem modelItem : children) {
            if (!(modelItem instanceof AbstractWsdlModelItem)) continue;
            ((AbstractWsdlModelItem)modelItem).beforeSave();
        }
    }

    public void afterLoad() {
        List<? extends ModelItem> children = this.getChildren();
        if (children == null) {
            return;
        }
        for (ModelItem modelItem : children) {
            if (!(modelItem instanceof AbstractWsdlModelItem)) continue;
            ((AbstractWsdlModelItem)modelItem).afterLoad();
        }
    }
}

