/*
 * Decompiled with CFR 0.152.
 */
package com.eviware.soapui.impl.wsdl.actions.iface;

import com.eviware.soapui.SoapUI;
import com.eviware.soapui.impl.settings.XmlBeansSettingsImpl;
import com.eviware.soapui.impl.support.definition.export.WsdlDefinitionExporter;
import com.eviware.soapui.impl.wsdl.WsdlInterface;
import com.eviware.soapui.support.Tools;
import com.eviware.soapui.support.UISupport;
import com.eviware.soapui.support.action.support.AbstractSoapUIAction;
import com.eviware.x.form.XFormDialog;
import com.eviware.x.form.support.ADialogBuilder;
import com.eviware.x.form.support.AField;
import com.eviware.x.form.support.AForm;
import java.io.File;
import java.io.FileReader;
import java.io.FileWriter;
import java.util.HashMap;
import java.util.Map;
import javax.xml.transform.Transformer;
import javax.xml.transform.TransformerFactory;
import javax.xml.transform.stream.StreamResult;
import javax.xml.transform.stream.StreamSource;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class CreateWsdlDocumentationAction
extends AbstractSoapUIAction<WsdlInterface> {
    public static final String SOAPUI_ACTION_ID = "CreateWsdlDocumentationAction";
    private static final String REPORT_DIRECTORY_SETTING = CreateWsdlDocumentationAction.class.getSimpleName() + "@report-directory";
    private XFormDialog dialog;
    private static Map<String, Transformer> transformers;

    public CreateWsdlDocumentationAction() {
        super(SOAPUI_ACTION_ID, "Generate Documentation", "Generate simple HTML Documentation for this WSDL");
    }

    @Override
    public void perform(WsdlInterface target, Object param) {
        try {
            if (this.dialog == null) {
                this.dialog = ADialogBuilder.buildDialog(Form.class);
            }
            XmlBeansSettingsImpl settings = target.getSettings();
            this.dialog.setValue("Output Folder", settings.getString(REPORT_DIRECTORY_SETTING, ""));
            if (!this.dialog.show()) {
                return;
            }
            settings.setString(REPORT_DIRECTORY_SETTING, this.dialog.getValue("Output Folder"));
            File reportDirectory = new File(settings.getString(REPORT_DIRECTORY_SETTING, ""));
            String reportDirAbsolutePath = reportDirectory.getAbsolutePath();
            String filename = reportDirAbsolutePath + File.separatorChar + "report.xml";
            String reportUrl = CreateWsdlDocumentationAction.transform(target, reportDirAbsolutePath, filename);
            Tools.openURL(reportUrl);
        }
        catch (Exception e) {
            UISupport.showErrorMessage(e);
        }
    }

    private static String transform(WsdlInterface target, String reportDirAbsolutePath, String filename) throws Exception {
        Transformer transformer;
        if (transformers == null) {
            CreateWsdlDocumentationAction.initTransformers();
        }
        if ((transformer = transformers.get("WSDL")) == null) {
            throw new Exception("Missing transformer for format [WSDL]");
        }
        transformer.setParameter("output.dir", reportDirAbsolutePath);
        String reportFile = reportDirAbsolutePath + File.separatorChar + "wsdl-report.html";
        StreamResult result = new StreamResult(new FileWriter(reportFile));
        WsdlDefinitionExporter exporter = new WsdlDefinitionExporter(target);
        String infile = exporter.export(reportDirAbsolutePath);
        transformer.transform(new StreamSource(new FileReader(infile)), result);
        String reportUrl = new File(reportFile).toURI().toURL().toString();
        return reportUrl;
    }

    protected static void initTransformers() throws Exception {
        transformers = new HashMap<String, Transformer>();
        TransformerFactory xformFactory = TransformerFactory.newInstance();
        Transformer transformer = xformFactory.newTransformer(new StreamSource(SoapUI.class.getResourceAsStream("/com/eviware/soapui/resources/doc/wsdl-viewer.xsl")));
        transformers.put("WSDL", transformer);
    }

    @AForm(description="Creates an HTML-Report for the interface WSDL", name="Create Documentation", helpUrl="http://www.soapui.org/userguide/rest/index.html", icon="/applications-system.png")
    public static interface Form {
        @AField(name="Output Folder", description="The folder where to create the report", type=AField.AFieldType.FOLDER)
        public static final String OUTPUT_FOLDER = "Output Folder";
    }
}

