/*
 * Decompiled with CFR 0.152.
 */
package com.eviware.soapui.impl.wsdl.actions.loadtest;

import com.eviware.soapui.impl.wsdl.actions.project.StartLoadUI;
import com.eviware.soapui.impl.wsdl.loadtest.WsdlLoadTest;
import com.eviware.soapui.integration.loadui.IntegrationUtils;
import com.eviware.soapui.support.StringUtils;
import com.eviware.soapui.support.UISupport;
import com.eviware.soapui.support.action.support.AbstractSoapUIAction;
import com.eviware.x.form.XFormDialog;
import com.eviware.x.form.XFormField;
import com.eviware.x.form.XFormFieldListener;
import com.eviware.x.form.support.ADialogBuilder;
import com.eviware.x.form.support.AField;
import com.eviware.x.form.support.AForm;
import java.io.IOException;
import java.util.HashMap;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class ConvertToLoadUIAction
extends AbstractSoapUIAction<WsdlLoadTest> {
    private XFormDialog dialog;
    public static final String SOAPUI_ACTION_ID = "ConvertToLoadUIAction";

    public ConvertToLoadUIAction() {
        super("Convert to loadUI TestCase", "Convert this LoadTest to a loadUI TestCase");
    }

    @Override
    public void perform(WsdlLoadTest loadTest, Object param) {
        if (IntegrationUtils.forceSaveProject(loadTest.getTestCase().getTestSuite().getProject())) {
            if (!StartLoadUI.testCajoConnection()) {
                if (UISupport.confirm("For this action you have to launch loadUI. Launch it now?", "Launch loadUI")) {
                    StartLoadUI.launchLoadUI();
                }
                return;
            }
            if (this.dialog == null) {
                this.dialog = ADialogBuilder.buildDialog(Form.class);
            }
            this.dialog.getFormField("Target Project").addFormFieldListener(new XFormFieldListener(){

                public void valueChanged(XFormField sourceField, String newValue, String oldValue) {
                    ConvertToLoadUIAction.this.dialog.setOptions("Target TestCase", IntegrationUtils.getAvailableTestCases(newValue));
                    if (ConvertToLoadUIAction.this.dialog.getValue("Target TestCase").equals("<Project Level>")) {
                        ConvertToLoadUIAction.this.dialog.setOptions("Target SoapUIRunner", IntegrationUtils.getAvailableRunners(newValue, "<Project Level>"));
                    }
                }
            });
            this.dialog.getFormField("Target TestCase").addFormFieldListener(new XFormFieldListener(){

                public void valueChanged(XFormField sourceField, String newValue, String oldValue) {
                    if (newValue.equals("<Create New>")) {
                        ConvertToLoadUIAction.this.dialog.setOptions("Target SoapUIRunner", new String[]{"<Create New>"});
                    } else {
                        ConvertToLoadUIAction.this.dialog.setOptions("Target SoapUIRunner", IntegrationUtils.getAvailableRunners(ConvertToLoadUIAction.this.dialog.getValue("Target Project"), newValue));
                    }
                }
            });
            this.dialog.setOptions("Target Project", IntegrationUtils.getAvailableProjects());
            if (!StringUtils.isNullOrEmpty(IntegrationUtils.getOpenedProjectName())) {
                this.dialog.setValue("Target Project", IntegrationUtils.getOpenedProjectName());
            } else {
                this.dialog.setValue("Target Project", "<Create New>");
            }
            this.dialog.setOptions("Target TestCase", IntegrationUtils.getAvailableTestCases(this.dialog.getValue("Target Project")));
            if (!this.dialog.getValue("Target Project").equals(IntegrationUtils.getOpenedProjectName())) {
                this.dialog.setValue("Target TestCase", "<Project Level>");
            }
            this.dialog.setOptions("Target SoapUIRunner", IntegrationUtils.getAvailableRunners(this.dialog.getValue("Target Project"), this.dialog.getValue("Target TestCase")));
            this.dialog.setValue("Target SoapUIRunner", "<Create New>");
            if (this.dialog.show()) {
                String targetProjectString = this.dialog.getValue("Target Project");
                String targetTestCaseName = !this.dialog.getValue("Target TestCase").equals("<Project Level>") ? this.dialog.getValue("Target TestCase") : null;
                String targetRunnerName = this.dialog.getValue("Target SoapUIRunner");
                String openedProjectName = IntegrationUtils.getOpenedProjectName();
                if (!StringUtils.isNullOrEmpty(openedProjectName) && !targetProjectString.equals(openedProjectName) && IntegrationUtils.checkOpenedLoadUIProjectForClose()) {
                    return;
                }
                this.exportToLoadUI(loadTest, targetProjectString, targetTestCaseName, targetRunnerName);
            }
        }
    }

    protected void exportToLoadUI(WsdlLoadTest loadTest, String targetProjectString, String targetTestCaseName, String targetRunnerName) {
        HashMap<String, Object> createdRunnerSettings = null;
        try {
            createdRunnerSettings = IntegrationUtils.exportLoadTestToLoadUI(loadTest, targetProjectString, targetTestCaseName, targetRunnerName);
        }
        catch (IOException e) {
            UISupport.showInfoMessage("Error while opening selected loadUI project");
            return;
        }
    }

    @AForm(description="Specify Items in loadUI for Converting LoadTest", name="Convert to loadUI", helpUrl="http://www.soapui.org/userguide/functional/testcases.html#Clone_TestCase", icon="/convertLoadTestToLoadUI.png")
    protected static interface Form {
        @AField(name="Target Project", description="The target Project in loadUI", type=AField.AFieldType.ENUMERATION)
        public static final String PROJECT = "Target Project";
        @AField(name="Target TestCase", description="The name of the target TestCase in loadUI", type=AField.AFieldType.ENUMERATION)
        public static final String TESTCASE = "Target TestCase";
        @AField(name="Target SoapUIRunner", description="The target SoapUIRunner in loadUI", type=AField.AFieldType.ENUMERATION)
        public static final String SOAPUIRUNNER = "Target SoapUIRunner";
    }
}

