/*
 * Decompiled with CFR 0.152.
 */
package com.eviware.soapui.impl.wsdl.actions.monitor;

import com.eviware.soapui.SoapUI;
import com.eviware.soapui.impl.settings.XmlBeansSettingsImpl;
import com.eviware.soapui.impl.wsdl.WsdlInterface;
import com.eviware.soapui.impl.wsdl.WsdlProject;
import com.eviware.soapui.impl.wsdl.panels.monitor.SoapMonitorDesktopPanel;
import com.eviware.soapui.model.iface.Interface;
import com.eviware.soapui.model.support.ModelSupport;
import com.eviware.soapui.support.StringUtils;
import com.eviware.soapui.support.UISupport;
import com.eviware.soapui.support.action.support.AbstractSoapUIAction;
import com.eviware.soapui.support.types.StringList;
import com.eviware.x.form.XForm;
import com.eviware.x.form.XFormDialog;
import com.eviware.x.form.XFormDialogBuilder;
import com.eviware.x.form.XFormFactory;
import com.eviware.x.form.XFormField;
import com.eviware.x.form.XFormFieldListener;
import com.eviware.x.form.support.ADialogBuilder;
import com.eviware.x.form.support.AField;
import com.eviware.x.form.support.AForm;
import com.eviware.x.form.support.APage;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class SoapMonitorAction
extends AbstractSoapUIAction<WsdlProject> {
    private static final String HTTPS_PROTOCOL = "https://";
    private static final String HTTP_TUNNEL = "HTTP Tunnel";
    private static final String HTTP_PROXY = "HTTP Proxy";
    private XFormDialog dialog;
    private XForm generalForm;
    private XForm securityForm;

    public SoapMonitorAction() {
        super("Launch HTTP Monitor", "Launches a HTTP traffic monitor for this project");
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    @Override
    public void perform(WsdlProject project, Object param) {
        if (this.dialog == null) {
            this.dialog = ADialogBuilder.buildTabbedDialog(WizardForm.class, null);
            this.dialog.setSize(650, 500);
        }
        XmlBeansSettingsImpl settings = project.getSettings();
        StringList endpoints = new StringList();
        endpoints.add(null);
        for (Interface interface_ : ModelSupport.getChildren(project, WsdlInterface.class)) {
            endpoints.addAll(interface_.getEndpoints());
        }
        XFormDialogBuilder builder = XFormFactory.createDialogBuilder("Launch LoadTestRunner");
        this.generalForm = builder.createForm("General");
        this.dialog.setIntValue("Port", (int)settings.getLong("Port", 8081L));
        this.dialog.setOptions("Incoming Request WSS", StringUtils.merge(project.getWssContainer().getIncomingWssNames(), "<none>"));
        this.dialog.setOptions("Incoming Response WSS", StringUtils.merge(project.getWssContainer().getIncomingWssNames(), "<none>"));
        this.dialog.setValue("Set endpoint for HTTP Tunnel:", settings.getString("Set endpoint for HTTP Tunnel:", "").length() > 0 ? settings.getString("Set endpoint for HTTP Tunnel:", "") : HTTPS_PROTOCOL);
        this.dialog.setOptions("Choose one:", new String[]{HTTP_TUNNEL, HTTP_PROXY});
        this.dialog.setValue("HTTP tunnel - KeyStore", settings.getString("HTTP tunnel - KeyStore", ""));
        this.dialog.setValue("HTTP tunnel - Password", settings.getString("HTTP tunnel - Password", ""));
        this.dialog.setValue("HTTP tunnel - KeyPassword", settings.getString("HTTP tunnel - KeyPassword", ""));
        this.dialog.setValue("HTTP tunnel - TrustStore", settings.getString("HTTP tunnel - TrustStore", ""));
        this.dialog.setValue("HTTP tunnel - TrustStore Password", settings.getString("HTTP tunnel - TrustStore Password", ""));
        this.dialog.setBooleanValue("Reuse request state", settings.getBoolean("Reuse request state"));
        this.dialog.setValue("Content types to monitor", settings.getString("Content types to monitor", SoapMonitorAction.defaultContentTypes()));
        this.dialog.setValue("HTTP tunnel - Set SSL Client Key Store path", settings.getString("HTTP tunnel - Set SSL Client Key Store path", ""));
        this.dialog.setValue("HTTP tunnel - Set SSL Client Key Store Password", settings.getString("HTTP tunnel - Set SSL Client Key Store Password", ""));
        XFormField xFormField = this.dialog.getFormField("Choose one:");
        xFormField.setValue(HTTP_PROXY);
        this.setDialogState(HTTP_PROXY);
        xFormField.addFormFieldListener(new XFormFieldListener(){

            public void valueChanged(XFormField sourceField, String newValue, String oldValue) {
                SoapMonitorAction.this.setDialogState(newValue);
            }
        });
        if (!this.dialog.show()) return;
        try {
            try {
                UISupport.setHourglassCursor();
                int listenPort = this.dialog.getIntValue("Port", 8080);
                settings.setLong("Port", listenPort);
                settings.setString("Set endpoint for HTTP Tunnel:", this.dialog.getValue("Set endpoint for HTTP Tunnel:"));
                settings.setString("HTTP tunnel - KeyStore", this.dialog.getValue("HTTP tunnel - KeyStore"));
                settings.setString("HTTP tunnel - Password", this.dialog.getValue("HTTP tunnel - Password"));
                settings.setString("HTTP tunnel - KeyPassword", this.dialog.getValue("HTTP tunnel - KeyPassword"));
                settings.setString("HTTP tunnel - TrustStore", this.dialog.getValue("HTTP tunnel - TrustStore"));
                settings.setString("HTTP tunnel - TrustStore Password", this.dialog.getValue("HTTP tunnel - TrustStore Password"));
                settings.setString("Reuse request state", this.dialog.getValue("Reuse request state"));
                settings.setString("HTTP tunnel - Set SSL Client Key Store path", this.dialog.getValue("HTTP tunnel - Set SSL Client Key Store path"));
                if (this.dialog.getValue("Content types to monitor") != null && this.dialog.getValue("Content types to monitor").trim().equals("")) {
                    settings.setString("Content types to monitor", SoapMonitorAction.defaultContentTypes());
                } else {
                    settings.setString("Content types to monitor", this.dialog.getValue("Content types to monitor"));
                }
                settings.setString("HTTP tunnel - Set SSL Client Key Store Password", this.dialog.getValue("HTTP tunnel - Set SSL Client Key Store Password"));
                for (Interface iface : project.getInterfaceList()) {
                    iface.getDefinitionContext().loadIfNecessary();
                }
                if (HTTP_PROXY.equals(this.dialog.getValue("Choose one:"))) {
                    this.openSoapMonitor(project, listenPort, this.dialog.getValue("Incoming Request WSS"), this.dialog.getValue("Incoming Response WSS"), this.dialog.getBooleanValue("Set as Proxy"), null);
                }
                this.openSoapMonitor(project, listenPort, this.dialog.getValue("Incoming Request WSS"), this.dialog.getValue("Incoming Response WSS"), this.dialog.getBooleanValue("Set as Proxy"), this.dialog.getValue("Set endpoint for HTTP Tunnel:"));
            }
            catch (Exception e) {
                SoapUI.logError(e);
                Object var11_13 = null;
                UISupport.resetCursor();
                return;
            }
            Object var11_12 = null;
        }
        catch (Throwable throwable) {
            Object var11_14 = null;
            UISupport.resetCursor();
            throw throwable;
        }
        UISupport.resetCursor();
    }

    public static String defaultContentTypes() {
        return "*/html, */xml, */soap+xml, */json, */x-json, */javascript, */x-amf";
    }

    protected void openSoapMonitor(WsdlProject target, int listenPort, String incomingRequestWss, String incomingResponseWss, boolean setAsProxy, String sslEndpoint) {
        if (sslEndpoint == null) {
            UISupport.showDesktopPanel(new SoapMonitorDesktopPanel(target, listenPort, incomingRequestWss, incomingResponseWss, setAsProxy, null));
        } else {
            String ssl = this.validate(sslEndpoint);
            if (ssl == null) {
                UISupport.showErrorMessage("SSL Monitor needs endpoint.");
            } else {
                UISupport.showDesktopPanel(new SoapMonitorDesktopPanel(target, listenPort, incomingRequestWss, incomingResponseWss, setAsProxy, ssl));
            }
        }
    }

    protected String validate(String sslEndpoint) {
        String res = sslEndpoint;
        if (res.trim().length() > 0) {
            return res.trim();
        }
        return null;
    }

    private void setDialogState(String newValue) {
        if (HTTP_PROXY.equals(newValue)) {
            this.dialog.getFormField("Set endpoint for HTTP Tunnel:").setEnabled(false);
            this.dialog.getFormField("HTTP tunnel - KeyStore").setEnabled(false);
            this.dialog.getFormField("HTTP tunnel - Password").setEnabled(false);
            this.dialog.getFormField("HTTP tunnel - KeyPassword").setEnabled(false);
            this.dialog.getFormField("HTTP tunnel - TrustStore").setEnabled(false);
            this.dialog.getFormField("HTTP tunnel - TrustStore Password").setEnabled(false);
            this.dialog.getFormField("Reuse request state").setEnabled(false);
            this.dialog.getFormField("HTTP tunnel - Set SSL Client Key Store path").setEnabled(false);
            this.dialog.getFormField("Content types to monitor").setEnabled(true);
            this.dialog.getFormField("HTTP tunnel - Set SSL Client Key Store Password").setEnabled(false);
            this.dialog.getFormField("Set as Proxy").setEnabled(true);
            this.dialog.getFormField("Incoming Request WSS").setEnabled(true);
            this.dialog.getFormField("Incoming Response WSS").setEnabled(true);
        } else {
            this.dialog.getFormField("Set endpoint for HTTP Tunnel:").setEnabled(true);
            this.dialog.getFormField("HTTP tunnel - KeyStore").setEnabled(true);
            this.dialog.getFormField("HTTP tunnel - Password").setEnabled(true);
            this.dialog.getFormField("HTTP tunnel - KeyPassword").setEnabled(true);
            this.dialog.getFormField("HTTP tunnel - TrustStore").setEnabled(true);
            this.dialog.getFormField("HTTP tunnel - TrustStore Password").setEnabled(true);
            this.dialog.getFormField("Reuse request state").setEnabled(true);
            this.dialog.getFormField("HTTP tunnel - Set SSL Client Key Store path").setEnabled(true);
            this.dialog.getFormField("Content types to monitor").setEnabled(true);
            this.dialog.getFormField("HTTP tunnel - Set SSL Client Key Store Password").setEnabled(true);
            this.dialog.getFormField("Set as Proxy").setEnabled(false);
            this.dialog.getFormField("Incoming Request WSS").setEnabled(false);
            this.dialog.getFormField("Incoming Response WSS").setEnabled(false);
        }
    }

    @AForm(description="Specify HTTP tunel security settings", name="HTTP tunel security", helpUrl="http://www.soapui.org/userguide/monitor/index.html")
    public static interface SecurityTabForm {
        @AField(description="Set SSL Tunnel KeyStore", name="HTTP tunnel - KeyStore", type=AField.AFieldType.FILE)
        public static final String SSLTUNNEL_KEYSTORE = "HTTP tunnel - KeyStore";
        @AField(description="Set SSL Tunnel Password", name="HTTP tunnel - Password", type=AField.AFieldType.PASSWORD)
        public static final String SSLTUNNEL_PASSWORD = "HTTP tunnel - Password";
        @AField(description="Set SSL Tunnel KeyPassword", name="HTTP tunnel - KeyPassword", type=AField.AFieldType.PASSWORD)
        public static final String SSLTUNNEL_KEYPASSWORD = "HTTP tunnel - KeyPassword";
        @AField(description="Set SSL Tunnel TrustStore", name="HTTP tunnel - TrustStore", type=AField.AFieldType.FILE)
        public static final String SSLTUNNEL_TRUSTSTORE = "HTTP tunnel - TrustStore";
        @AField(description="Set SSL Tunnel TrustStore Password", name="HTTP tunnel - TrustStore Password", type=AField.AFieldType.PASSWORD)
        public static final String SSLTUNNEL_TRUSTSTORE_PASSWORD = "HTTP tunnel - TrustStore Password";
        @AField(description="Set SSL Client Key Store", name="HTTP tunnel - Set SSL Client Key Store path", type=AField.AFieldType.FILE)
        public static final String SSLTUNNEL_KEYSTOREPATH = "HTTP tunnel - Set SSL Client Key Store path";
        @AField(description="Set SSL Client Key Store Password", name="HTTP tunnel - Set SSL Client Key Store Password", type=AField.AFieldType.PASSWORD)
        public static final String SSLTUNNEL_KEYSTOREPASSWORD = "HTTP tunnel - Set SSL Client Key Store Password";
    }

    @AForm(description="Specify HTTP Monitor settings", name="Launch HTTP Monitor", helpUrl="http://www.soapui.org/userguide/monitor/index.html")
    public static interface LaunchForm {
        @AField(description="SSL tunnel or HTTP proxy", name="Choose one:", type=AField.AFieldType.RADIOGROUP)
        public static final String SSLORHTTP = "Choose one:";
        @AField(description="The local port to listen on", name="Port", type=AField.AFieldType.INT)
        public static final String PORT = "Port";
        @AField(description="The Incoming WSS configuration to use for processing requests", name="Incoming Request WSS", type=AField.AFieldType.ENUMERATION)
        public static final String REQUEST_WSS = "Incoming Request WSS";
        @AField(description="The Outgoing WSS configuration to use for processing responses", name="Incoming Response WSS", type=AField.AFieldType.ENUMERATION)
        public static final String RESPONSE_WSS = "Incoming Response WSS";
        @AField(description="Set as Global Proxy", name="Set as Proxy", type=AField.AFieldType.BOOLEAN)
        public static final String SETASPROXY = "Set as Proxy";
        @AField(description="Set endpoint", name="Set endpoint for HTTP Tunnel:", type=AField.AFieldType.STRING)
        public static final String SETSSLMON = "Set endpoint for HTTP Tunnel:";
        @AField(description="Keep request state", name="Reuse request state", type=AField.AFieldType.BOOLEAN)
        public static final String SSLTUNNEL_REUSESTATE = "Reuse request state";
        @AField(description="Content types to monitor, if blank default types will be set!", name="Content types to monitor", type=AField.AFieldType.STRINGAREA)
        public static final String SET_CONTENT_TYPES = "Content types to monitor";
    }

    @AForm(description="Specify HTTP Monitor settings", name="General Options", helpUrl="http://www.soapui.org/userguide/monitor/index.html", icon="/applications-system.png")
    private static interface WizardForm {
        @APage(name="General")
        public static final LaunchForm general = null;
        @APage(name="Security")
        public static final SecurityTabForm security = null;
    }
}

