/*
 * Decompiled with CFR 0.152.
 */
package com.eviware.soapui.impl.wsdl.loadtest;

import com.eviware.soapui.SoapUI;
import com.eviware.soapui.config.LoadTestConfig;
import com.eviware.soapui.config.LoadTestLimitTypesConfig;
import com.eviware.soapui.config.SecurityTestConfig;
import com.eviware.soapui.config.TestCaseConfig;
import com.eviware.soapui.impl.settings.XmlBeansSettingsImpl;
import com.eviware.soapui.impl.wsdl.loadtest.WsdlLoadTest;
import com.eviware.soapui.impl.wsdl.loadtest.WsdlLoadTestContext;
import com.eviware.soapui.impl.wsdl.loadtest.log.LoadTestLogMessageEntry;
import com.eviware.soapui.impl.wsdl.testcase.WsdlTestCase;
import com.eviware.soapui.impl.wsdl.testcase.WsdlTestCaseRunner;
import com.eviware.soapui.impl.wsdl.testcase.WsdlTestRunContext;
import com.eviware.soapui.model.support.TestRunListenerAdapter;
import com.eviware.soapui.model.testsuite.LoadTestRunListener;
import com.eviware.soapui.model.testsuite.LoadTestRunner;
import com.eviware.soapui.model.testsuite.TestCaseRunContext;
import com.eviware.soapui.model.testsuite.TestCaseRunner;
import com.eviware.soapui.model.testsuite.TestRunContext;
import com.eviware.soapui.model.testsuite.TestRunnable;
import com.eviware.soapui.model.testsuite.TestRunner;
import com.eviware.soapui.model.testsuite.TestStep;
import com.eviware.soapui.model.testsuite.TestStepResult;
import com.eviware.soapui.settings.HttpSettings;
import com.eviware.soapui.settings.WsdlSettings;
import com.eviware.soapui.support.UISupport;
import com.eviware.soapui.support.types.StringToObjectMap;
import com.eviware.x.dialogs.Worker;
import com.eviware.x.dialogs.XProgressDialog;
import com.eviware.x.dialogs.XProgressMonitor;
import java.beans.PropertyChangeEvent;
import java.beans.PropertyChangeListener;
import java.util.ArrayList;
import java.util.Date;
import java.util.HashSet;
import java.util.Iterator;
import java.util.List;
import java.util.Set;
import org.apache.xmlbeans.XmlException;

public class WsdlLoadTestRunner
implements LoadTestRunner {
    private final WsdlLoadTest loadTest;
    private Set<InternalTestCaseRunner> runners = new HashSet<InternalTestCaseRunner>();
    private long startTime = 0L;
    private InternalPropertyChangeListener internalPropertyChangeListener = new InternalPropertyChangeListener();
    private InternalTestRunListener testRunListener = new InternalTestRunListener();
    private long runCount;
    private TestRunner.Status status;
    private WsdlLoadTestContext context;
    private String reason;
    private int threadCount;
    private int threadsWaitingToStart;
    private int startedCount;
    private boolean hasTearedDown;
    private TestCaseStarter testCaseStarter;
    private boolean stopped;
    private TestCaseConfig blueprintConfig;

    public WsdlLoadTestRunner(WsdlLoadTest test) {
        this.loadTest = test;
        this.status = TestRunner.Status.INITIALIZED;
    }

    public TestRunner.Status getStatus() {
        return this.status;
    }

    void start() {
        this.loadTest.getTestCase().beforeSave();
        this.runners.clear();
        this.runCount = 0L;
        this.threadCount = 0;
        this.threadsWaitingToStart = 0;
        this.startedCount = 0;
        this.context = new WsdlLoadTestContext(this);
        try {
            this.loadTest.runSetupScript(this.context, this);
        }
        catch (Exception e1) {
            SoapUI.logError(e1);
        }
        for (LoadTestRunListener listener : this.loadTest.getLoadTestRunListeners()) {
            try {
                listener.beforeLoadTest(this, this.context);
            }
            catch (Throwable e) {
                SoapUI.logError(e);
            }
        }
        this.status = TestRunner.Status.RUNNING;
        this.loadTest.addPropertyChangeListener(WsdlLoadTest.THREADCOUNT_PROPERTY, this.internalPropertyChangeListener);
        XProgressDialog progressDialog = UISupport.getDialogs().createProgressDialog("Starting threads", (int)this.loadTest.getThreadCount(), "", true);
        try {
            this.testCaseStarter = new TestCaseStarter();
            progressDialog.run(this.testCaseStarter);
        }
        catch (Exception e) {
            SoapUI.logError(e);
        }
        if (this.status == TestRunner.Status.RUNNING) {
            for (LoadTestRunListener listener : this.loadTest.getLoadTestRunListeners()) {
                listener.loadTestStarted(this, this.context);
            }
            this.startStrategyThread();
        } else {
            this.stop();
        }
    }

    private void startStrategyThread() {
        new Thread(new Runnable(){

            public void run() {
                while (WsdlLoadTestRunner.this.getStatus() == TestRunner.Status.RUNNING) {
                    try {
                        WsdlLoadTestRunner.this.loadTest.getLoadStrategy().recalculate(WsdlLoadTestRunner.this, WsdlLoadTestRunner.this.context);
                        long strategyInterval = WsdlLoadTestRunner.this.loadTest.getStrategyInterval();
                        if (strategyInterval < 1L) {
                            strategyInterval = 500L;
                        }
                        Thread.sleep(strategyInterval);
                    }
                    catch (InterruptedException e) {
                        e.printStackTrace();
                    }
                }
            }
        }).start();
    }

    private InternalTestCaseRunner startTestCase(WsdlTestCase testCase) {
        InternalTestCaseRunner testCaseRunner = new InternalTestCaseRunner(testCase, this.threadCount++);
        SoapUI.getThreadPool().submit(testCaseRunner);
        this.runners.add(testCaseRunner);
        return testCaseRunner;
    }

    public synchronized void cancel(String reason) {
        InternalTestCaseRunner[] r;
        if (this.status != TestRunner.Status.RUNNING) {
            return;
        }
        this.reason = reason;
        this.status = TestRunner.Status.CANCELED;
        if (this.testCaseStarter != null) {
            this.testCaseStarter.stop();
        }
        for (InternalTestCaseRunner runner : r = this.runners.toArray(new InternalTestCaseRunner[this.runners.size()])) {
            runner.cancel(reason, true);
        }
        String msg = "LoadTest [" + this.loadTest.getName() + "] canceled";
        if (reason != null) {
            msg = msg + "; " + reason;
        }
        this.loadTest.getLoadTestLog().addEntry(new LoadTestLogMessageEntry(msg));
        for (LoadTestRunListener listener : this.loadTest.getLoadTestRunListeners()) {
            listener.loadTestStopped(this, this.context);
        }
        if (r.length == 0) {
            this.stop();
        }
    }

    public synchronized void fail(String reason) {
        InternalTestCaseRunner[] r;
        boolean wasRunning = this.status == TestRunner.Status.RUNNING;
        this.reason = reason;
        this.status = TestRunner.Status.FAILED;
        if (!wasRunning) {
            return;
        }
        if (this.testCaseStarter != null) {
            this.testCaseStarter.stop();
        }
        String msg = "LoadTest [" + this.loadTest.getName() + "] failed";
        if (reason != null) {
            msg = msg + "; " + reason;
        }
        this.loadTest.getLoadTestLog().addEntry(new LoadTestLogMessageEntry(msg));
        for (LoadTestRunListener listener : this.loadTest.getLoadTestRunListeners()) {
            try {
                listener.loadTestStopped(this, this.context);
            }
            catch (Throwable e) {
                SoapUI.logError(e);
            }
        }
        for (InternalTestCaseRunner runner : r = this.runners.toArray(new InternalTestCaseRunner[this.runners.size()])) {
            runner.cancel(reason, true);
        }
        if (r.length == 0) {
            this.stop();
        }
    }

    private synchronized void tearDown() {
        if (this.hasTearedDown) {
            return;
        }
        try {
            this.loadTest.runTearDownScript(this.context, this);
        }
        catch (Exception e1) {
            SoapUI.logError(e1);
        }
        this.hasTearedDown = true;
    }

    public TestRunner.Status waitUntilFinished() {
        while (this.runners.size() > 0 || this.threadsWaitingToStart > 0 || !this.hasStopped()) {
            try {
                Thread.sleep(200L);
            }
            catch (InterruptedException e) {
                SoapUI.logError(e);
            }
        }
        return this.getStatus();
    }

    public void finishTestCase(String reason, WsdlTestCase testCase) {
        for (InternalTestCaseRunner runner : this.runners) {
            if (runner.getTestCase() != testCase) continue;
            runner.cancel(reason, false);
            break;
        }
    }

    public synchronized void finishRunner(InternalTestCaseRunner runner) {
        if (!this.runners.contains(runner)) {
            throw new RuntimeException("Trying to finish unknown runner.. ");
        }
        this.runners.remove(runner);
        if (this.getProgress() >= 1.0f || this.status != TestRunner.Status.RUNNING) {
            this.stop();
        }
    }

    private synchronized void stop() {
        if (this.stopped) {
            return;
        }
        this.loadTest.removePropertyChangeListener(WsdlLoadTest.THREADCOUNT_PROPERTY, this.internalPropertyChangeListener);
        if (this.testCaseStarter != null) {
            this.testCaseStarter.stop();
        }
        if (this.status == TestRunner.Status.RUNNING) {
            this.status = TestRunner.Status.FINISHED;
        }
        this.loadTest.getLoadTestLog().addEntry(new LoadTestLogMessageEntry("LoadTest ended at " + new Date(System.currentTimeMillis())));
        try {
            this.tearDown();
        }
        catch (Throwable e) {
            SoapUI.logError(e);
        }
        for (LoadTestRunListener listener : this.loadTest.getLoadTestRunListeners()) {
            try {
                listener.afterLoadTest(this, this.context);
            }
            catch (Throwable e) {
                SoapUI.logError(e);
            }
        }
        this.context.clear();
        this.stopped = true;
        this.blueprintConfig = null;
    }

    public boolean hasStopped() {
        return this.stopped;
    }

    public int getRunningThreadCount() {
        return this.runners.size();
    }

    public float getProgress() {
        long testLimit = this.loadTest.getTestLimit();
        if (testLimit == 0L) {
            return -1.0f;
        }
        if (this.loadTest.getLimitType() == LoadTestLimitTypesConfig.COUNT) {
            return (float)this.runCount / (float)testLimit;
        }
        if (this.loadTest.getLimitType() == LoadTestLimitTypesConfig.COUNT_PER_THREAD) {
            return (float)this.runCount / (float)(testLimit * this.loadTest.getThreadCount());
        }
        if (this.loadTest.getLimitType() == LoadTestLimitTypesConfig.TIME) {
            return this.startTime == 0L ? 0.0f : (float)this.getTimeTaken() / (float)(testLimit * 1000L);
        }
        return -1.0f;
    }

    private synchronized boolean afterRun(InternalTestCaseRunner runner) {
        if (this.status != TestRunner.Status.RUNNING) {
            return false;
        }
        ++this.runCount;
        if (this.loadTest.getTestLimit() < 1L) {
            return true;
        }
        if (this.loadTest.getLimitType() == LoadTestLimitTypesConfig.COUNT_PER_THREAD) {
            return runner.getRunCount() < this.loadTest.getTestLimit();
        }
        if (this.loadTest.getLimitType() == LoadTestLimitTypesConfig.COUNT) {
            return this.runCount + (long)this.runners.size() + (long)this.threadsWaitingToStart <= this.loadTest.getTestLimit();
        }
        if (this.loadTest.getLimitType() == LoadTestLimitTypesConfig.TIME) {
            return this.getTimeTaken() < this.loadTest.getTestLimit() * 1000L;
        }
        return true;
    }

    public WsdlLoadTest getLoadTest() {
        return this.loadTest;
    }

    public synchronized void updateThreadCount() {
        block10: {
            long diff;
            block9: {
                if (this.status != TestRunner.Status.RUNNING) {
                    return;
                }
                long newCount = this.loadTest.getThreadCount();
                Iterator<InternalTestCaseRunner> iterator = this.runners.iterator();
                ArrayList<InternalTestCaseRunner> activeRunners = new ArrayList<InternalTestCaseRunner>();
                while (iterator.hasNext()) {
                    InternalTestCaseRunner runner = iterator.next();
                    if (runner.isCanceled()) continue;
                    activeRunners.add(runner);
                }
                diff = newCount - (long)activeRunners.size();
                if (diff == 0L) {
                    return;
                }
                if (diff >= 0L || !this.loadTest.getCancelExcessiveThreads()) break block9;
                diff = Math.abs(diff);
                for (int c = 0; (long)c < diff && c < activeRunners.size(); ++c) {
                    ((InternalTestCaseRunner)activeRunners.get(c)).cancel("excessive thread", false);
                }
                break block10;
            }
            if (diff <= 0L) break block10;
            int c = 0;
            while ((long)c < diff) {
                int startDelay = this.loadTest.getStartDelay();
                if (startDelay > 0) {
                    try {
                        Thread.sleep(startDelay);
                    }
                    catch (InterruptedException e) {
                        SoapUI.logError(e);
                    }
                }
                if (this.status == TestRunner.Status.RUNNING) {
                    this.startTestCase(this.createTestCase());
                }
                ++c;
            }
        }
    }

    private synchronized WsdlTestCase createTestCase() {
        WsdlTestCase testCase = this.loadTest.getTestCase();
        TestCaseConfig config = null;
        if (this.blueprintConfig == null) {
            try {
                this.blueprintConfig = TestCaseConfig.Factory.parse((String)((TestCaseConfig)testCase.getConfig()).xmlText());
                this.blueprintConfig.setLoadTestArray(new LoadTestConfig[0]);
                this.blueprintConfig.setSecurityTestArray(new SecurityTestConfig[0]);
            }
            catch (XmlException e) {
                e.printStackTrace();
            }
        }
        config = (TestCaseConfig)this.blueprintConfig.copy();
        WsdlTestCase tc = testCase.getTestSuite().buildTestCase(config, true);
        tc.afterLoad();
        tc.addTestRunListener(this.testRunListener);
        XmlBeansSettingsImpl settings = tc.getSettings();
        settings.setBoolean(HttpSettings.INCLUDE_REQUEST_IN_TIME_TAKEN, this.loadTest.getSettings().getBoolean(HttpSettings.INCLUDE_REQUEST_IN_TIME_TAKEN));
        settings.setBoolean(HttpSettings.INCLUDE_RESPONSE_IN_TIME_TAKEN, this.loadTest.getSettings().getBoolean(HttpSettings.INCLUDE_RESPONSE_IN_TIME_TAKEN));
        settings.setBoolean(HttpSettings.CLOSE_CONNECTIONS, this.loadTest.getSettings().getBoolean(HttpSettings.CLOSE_CONNECTIONS));
        settings.setBoolean(WsdlSettings.PRETTY_PRINT_RESPONSE_MESSAGES, false);
        tc.setDiscardOkResults(false);
        tc.setMaxResults(0);
        return tc;
    }

    public String getReason() {
        return this.reason;
    }

    public long getTimeTaken() {
        return System.currentTimeMillis() - this.startTime;
    }

    public boolean isRunning() {
        return this.status == TestRunner.Status.RUNNING;
    }

    public TestRunContext getRunContext() {
        return this.context;
    }

    public long getStartTime() {
        return this.startTime;
    }

    public void start(boolean async) {
        this.start();
    }

    public TestRunnable getTestRunnable() {
        return this.loadTest;
    }

    public void release() {
        this.loadTest.removePropertyChangeListener(WsdlLoadTest.THREADCOUNT_PROPERTY, this.internalPropertyChangeListener);
    }

    private class InternalTestRunListener
    extends TestRunListenerAdapter {
        private InternalTestRunListener() {
        }

        public void beforeRun(TestCaseRunner testRunner, TestCaseRunContext runContext) {
            if (WsdlLoadTestRunner.this.getProgress() > 1.0f && WsdlLoadTestRunner.this.loadTest.getCancelOnReachedLimit()) {
                testRunner.cancel("LoadTest Limit reached");
            } else {
                for (LoadTestRunListener listener : WsdlLoadTestRunner.this.loadTest.getLoadTestRunListeners()) {
                    listener.beforeTestCase(WsdlLoadTestRunner.this, WsdlLoadTestRunner.this.context, testRunner, runContext);
                }
            }
        }

        public void beforeStep(TestCaseRunner testRunner, TestCaseRunContext runContext, TestStep testStep) {
            if (WsdlLoadTestRunner.this.getProgress() > 1.0f && WsdlLoadTestRunner.this.loadTest.getCancelOnReachedLimit()) {
                testRunner.cancel("LoadTest Limit reached");
            } else if (runContext.getCurrentStep() != null) {
                for (LoadTestRunListener listener : WsdlLoadTestRunner.this.loadTest.getLoadTestRunListeners()) {
                    listener.beforeTestStep(WsdlLoadTestRunner.this, WsdlLoadTestRunner.this.context, testRunner, runContext, testStep);
                }
            }
        }

        public void afterStep(TestCaseRunner testRunner, TestCaseRunContext runContext, TestStepResult result) {
            for (LoadTestRunListener listener : WsdlLoadTestRunner.this.loadTest.getLoadTestRunListeners()) {
                listener.afterTestStep(WsdlLoadTestRunner.this, WsdlLoadTestRunner.this.context, testRunner, runContext, result);
            }
        }

        public void afterRun(TestCaseRunner testRunner, TestCaseRunContext runContext) {
            for (LoadTestRunListener listener : WsdlLoadTestRunner.this.loadTest.getLoadTestRunListeners()) {
                listener.afterTestCase(WsdlLoadTestRunner.this, WsdlLoadTestRunner.this.context, testRunner, runContext);
            }
        }
    }

    public class InternalPropertyChangeListener
    implements PropertyChangeListener {
        public void propertyChange(PropertyChangeEvent evt) {
            WsdlLoadTestRunner.this.updateThreadCount();
        }
    }

    public class InternalTestCaseRunner
    implements Runnable {
        private final WsdlTestCase testCase;
        private boolean canceled;
        private long runCount;
        private WsdlTestCaseRunner runner;
        private final int threadIndex;

        public InternalTestCaseRunner(WsdlTestCase testCase, int threadIndex) {
            this.testCase = testCase;
            this.threadIndex = threadIndex;
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        public void run() {
            try {
                if (System.getProperty("soapui.enablenamedthreads") != null) {
                    Thread.currentThread().setName(this.testCase.getName() + " " + WsdlLoadTestRunner.this.loadTest.getName() + " ThreadIndex = " + this.threadIndex);
                }
                this.runner = new WsdlTestCaseRunner(this.testCase, new StringToObjectMap());
                while (!this.canceled) {
                    try {
                        ((WsdlTestRunContext)this.runner.getRunContext()).reset();
                        ((WsdlTestRunContext)this.runner.getRunContext()).setProperty("ThreadIndex", this.threadIndex);
                        ((WsdlTestRunContext)this.runner.getRunContext()).setProperty("RunCount", this.runCount);
                        ((WsdlTestRunContext)this.runner.getRunContext()).setProperty("LoadTestRunner", WsdlLoadTestRunner.this);
                        ((WsdlTestRunContext)this.runner.getRunContext()).setProperty("LoadTestContext", WsdlLoadTestRunner.this.context);
                        InternalTestCaseRunner internalTestCaseRunner = this;
                        synchronized (internalTestCaseRunner) {
                            ((WsdlTestRunContext)this.runner.getRunContext()).setProperty("TotalRunCount", WsdlLoadTestRunner.this.startedCount++);
                        }
                        this.runner.run();
                    }
                    catch (Throwable e) {
                        System.err.println("Error running testcase: " + e);
                        SoapUI.logError(e);
                    }
                    ++this.runCount;
                    if (WsdlLoadTestRunner.this.afterRun(this)) continue;
                    break;
                }
                Object var4_4 = null;
                WsdlLoadTestRunner.this.finishRunner(this);
                this.testCase.release();
                this.testCase.removeTestRunListener(WsdlLoadTestRunner.this.testRunListener);
            }
            catch (Throwable throwable) {
                Object var4_5 = null;
                WsdlLoadTestRunner.this.finishRunner(this);
                this.testCase.release();
                this.testCase.removeTestRunListener(WsdlLoadTestRunner.this.testRunListener);
                throw throwable;
            }
        }

        public void cancel(String reason, boolean cancelRunner) {
            if (this.runner != null && cancelRunner) {
                this.runner.cancel(reason);
            }
            this.canceled = true;
        }

        public boolean isCanceled() {
            return this.canceled;
        }

        public long getRunCount() {
            return this.runCount;
        }

        public WsdlTestCase getTestCase() {
            return this.testCase;
        }
    }

    private final class TestCaseStarter
    extends Worker.WorkerAdapter {
        private List<WsdlTestCase> testCases = new ArrayList<WsdlTestCase>();
        private boolean canceled;

        private TestCaseStarter() {
        }

        public Object construct(XProgressMonitor monitor) {
            int startDelay = WsdlLoadTestRunner.this.loadTest.getStartDelay();
            int c = 0;
            while ((long)c < WsdlLoadTestRunner.this.loadTest.getThreadCount() && !this.canceled) {
                monitor.setProgress(1, "Creating Virtual User " + (c + 1));
                this.testCases.add(WsdlLoadTestRunner.this.createTestCase());
                ++c;
            }
            WsdlLoadTestRunner.this.startTime = System.currentTimeMillis();
            if (this.canceled) {
                WsdlLoadTestRunner.this.loadTest.getLoadTestLog().addEntry(new LoadTestLogMessageEntry("LoadTest canceled during startup at " + new Date(WsdlLoadTestRunner.this.startTime)));
                return null;
            }
            WsdlLoadTestRunner.this.loadTest.getLoadTestLog().addEntry(new LoadTestLogMessageEntry("LoadTest started at " + new Date(WsdlLoadTestRunner.this.startTime)));
            WsdlLoadTestRunner.this.threadsWaitingToStart = this.testCases.size();
            int cnt = 0;
            while (!this.testCases.isEmpty() && !this.canceled) {
                if (startDelay > 0) {
                    try {
                        Thread.sleep(startDelay);
                    }
                    catch (InterruptedException e) {
                        SoapUI.logError(e);
                    }
                }
                if (WsdlLoadTestRunner.this.status != TestRunner.Status.RUNNING || WsdlLoadTestRunner.this.getProgress() >= 1.0f) {
                    while (!this.testCases.isEmpty()) {
                        this.testCases.remove(0).release();
                    }
                    WsdlLoadTestRunner.this.threadsWaitingToStart = 0;
                    break;
                }
                if (this.testCases.isEmpty()) continue;
                WsdlLoadTestRunner.this.startTestCase(this.testCases.remove(0));
                monitor.setProgress(1, "Started thread " + ++cnt);
                WsdlLoadTestRunner.this.threadsWaitingToStart--;
            }
            return null;
        }

        public boolean onCancel() {
            WsdlLoadTestRunner.this.cancel("Stopped from UI during start-up");
            this.stop();
            return false;
        }

        public void stop() {
            if (!this.canceled) {
                this.canceled = true;
                while (!this.testCases.isEmpty()) {
                    this.testCases.remove(0).release();
                }
                WsdlLoadTestRunner.this.threadsWaitingToStart = 0;
            }
        }
    }
}

