/*
 * Decompiled with CFR 0.152.
 */
package com.eviware.soapui.impl.wsdl.panels.project;

import com.eviware.soapui.impl.EmptyPanelBuilder;
import com.eviware.soapui.impl.wsdl.WsdlProject;
import com.eviware.soapui.impl.wsdl.panels.project.WsdlProjectDesktopPanel;
import com.eviware.soapui.support.components.JPropertiesTable;
import com.eviware.soapui.support.scripting.SoapUIScriptEngineRegistry;
import com.eviware.soapui.ui.desktop.DesktopPanel;
import javax.swing.JPanel;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class WsdlProjectPanelBuilder
extends EmptyPanelBuilder<WsdlProject> {
    public JPanel buildOverviewPanel(WsdlProject project) {
        JPropertiesTable<WsdlProject> table = new JPropertiesTable<WsdlProject>("Project Properties", project);
        if (project.isOpen()) {
            table.addProperty("Name", "name", true);
            table.addProperty("Description", "description", true);
            table.addProperty("File", "path");
            if (!project.isDisabled()) {
                table.addProperty("Resource Root", "resourceRoot", new String[]{null, "${projectDir}", "${workspaceDir}"});
                table.addProperty("Cache Definitions", "cacheDefinitions", JPropertiesTable.BOOLEAN_OPTIONS);
                table.addPropertyShadow("Project Password", "shadowPassword", true);
                table.addProperty("Script Language", "defaultScriptLanguage", SoapUIScriptEngineRegistry.getAvailableEngineIds());
                table.addProperty("Hermes Config", "hermesConfig", true);
            }
        } else {
            table.addProperty("File", "path");
        }
        return table;
    }

    @Override
    public boolean hasOverviewPanel() {
        return true;
    }

    @Override
    public boolean hasDesktopPanel() {
        return true;
    }

    @Override
    public DesktopPanel buildDesktopPanel(WsdlProject modelItem) {
        return new WsdlProjectDesktopPanel(modelItem);
    }
}

