/*
 * Decompiled with CFR 0.152.
 */
package com.eviware.soapui.impl.wsdl.panels.testcase;

import com.eviware.soapui.SoapUI;
import com.eviware.soapui.impl.support.actions.ShowOnlineHelpAction;
import com.eviware.soapui.impl.wsdl.testcase.WsdlTestCase;
import com.eviware.soapui.support.Tools;
import com.eviware.soapui.support.UISupport;
import com.eviware.soapui.support.components.JXToolBar;
import com.eviware.soapui.support.components.NativeBrowserComponent;
import com.eviware.soapui.testondemand.DependencyValidator;
import com.eviware.soapui.testondemand.Location;
import com.eviware.soapui.testondemand.TestOnDemandCaller;
import com.eviware.x.dialogs.Worker;
import com.eviware.x.dialogs.XProgressDialog;
import com.eviware.x.dialogs.XProgressMonitor;
import com.google.common.base.Joiner;
import com.google.common.base.Strings;
import edu.umd.cs.findbugs.annotations.NonNull;
import java.awt.BorderLayout;
import java.awt.Color;
import java.awt.Component;
import java.awt.Dimension;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.util.ArrayList;
import java.util.List;
import javax.swing.AbstractAction;
import javax.swing.Action;
import javax.swing.JComboBox;
import javax.swing.JEditorPane;
import javax.swing.JLabel;
import javax.swing.JPanel;

public class TestOnDemandPanel
extends JPanel {
    private static final String FIRST_PAGE_URL = "http://www.soapui.org/Appindex/test-on-demand.html";
    private static final String GET_MORE_LOCATIONS_URL = "http://www2.smartbear.com/AlertSite_Monitor_APIs_Learn_More.html";
    private static final String GET_MORE_LOCATIONS_MESSAGE = "More locations trial";
    private static final String INITIALIZING_MESSAGE = "Initializing...";
    private static final String NO_LOCATIONS_FOUND_MESSAGE = "No locations found";
    private static final String COULD_NOT_GET_LOCATIONS_MESSAGE = "Could not get Test On Demand Locations. Check your network connection.";
    private static final String COULD_NOT_UPLOAD_MESSAGE = "Could not upload TestCase to the selected location";
    private static final String UPLOAD_TEST_CASE_HEADING = "Upload TestCase";
    private static final String UPLOADING_TEST_CASE_MESSAGE = "Uploading TestCase..";
    private static final String SERVER_IP_ADDRESSES_PREFIX = "IP: ";
    private static final String SERVER_IP_ADDRESSES_DELIMETER = ", ";
    private static final String NO_SERVER_IP_ADDRESSES_MESSAGE = "<No IP addresses found>";
    @NonNull
    private JComboBox locationsComboBox;
    @NonNull
    private CustomNativeBrowserComponent browser;
    @NonNull
    private Action sendTestCaseAction;
    @NonNull
    private static List<Location> locationsCache = new ArrayList<Location>();
    @NonNull
    JLabel serverIPAddressesLabel = new JLabel();
    @NonNull
    TestOnDemandCaller caller;
    private final WsdlTestCase testCase;
    protected DependencyValidator validator;

    public TestOnDemandPanel(WsdlTestCase testCase) {
        super(new BorderLayout());
        this.testCase = testCase;
        this.setBackground(Color.WHITE);
        this.setOpaque(true);
        this.setValidator();
        this.setCaller();
        this.add(this.buildToolbar(), "North");
        if (!SoapUI.isJXBrowserDisabled(true)) {
            this.browser = new CustomNativeBrowserComponent(true, false);
            this.add(this.browser.getComponent(), "Center");
        } else {
            JEditorPane jxbrowserDisabledPanel = new JEditorPane();
            jxbrowserDisabledPanel.setText("Browser component disabled or not available on this platform");
            this.add((Component)jxbrowserDisabledPanel, "Center");
        }
        this.openInInternalBrowser(FIRST_PAGE_URL);
    }

    protected void setValidator() {
        this.validator = new DependencyValidator();
    }

    protected void setCaller() {
        this.caller = new TestOnDemandCaller();
    }

    public void release() {
        if (this.browser != null) {
            this.browser.release();
        }
    }

    private Component buildToolbar() {
        JXToolBar toolbar = UISupport.createToolbar();
        this.sendTestCaseAction = new SendTestCaseAction();
        this.sendTestCaseAction.setEnabled(false);
        this.locationsComboBox = this.buildInitializingLocationsComboBox();
        this.locationsComboBox.addActionListener(new LocationComboBoxAction());
        this.serverIPAddressesLabel.setPreferredSize(new Dimension(1000, 10));
        this.serverIPAddressesLabel.setForeground(Color.GRAY);
        toolbar.addFixed(UISupport.createToolbarButton(this.sendTestCaseAction));
        toolbar.addRelatedGap();
        toolbar.addFixed(this.locationsComboBox);
        toolbar.addSpace(10);
        toolbar.addFixed(this.serverIPAddressesLabel);
        toolbar.addGlue();
        toolbar.addFixed(UISupport.createToolbarButton(new ShowOnlineHelpAction("http://www.soapui.org/userguide/")));
        return toolbar;
    }

    private JComboBox buildInitializingLocationsComboBox() {
        JComboBox<String> initLocationsComboBox = new JComboBox<String>();
        initLocationsComboBox.setPreferredSize(new Dimension(170, 10));
        initLocationsComboBox.addItem(INITIALIZING_MESSAGE);
        initLocationsComboBox.setEnabled(false);
        return initLocationsComboBox;
    }

    public void initializeLocationsCache() {
        if (locationsCache.isEmpty()) {
            new TestOnDemandCallerThread().start();
        } else {
            this.populateLocationsComboBox();
        }
    }

    private void populateLocationsComboBox() {
        this.locationsComboBox.removeAllItems();
        if (locationsCache.isEmpty()) {
            this.locationsComboBox.addItem(NO_LOCATIONS_FOUND_MESSAGE);
            this.openInInternalBrowser(SoapUI.PUSH_PAGE_ERROR_URL);
        } else {
            for (Location location : locationsCache) {
                this.locationsComboBox.addItem(location);
            }
            this.locationsComboBox.addItem(GET_MORE_LOCATIONS_MESSAGE);
            this.locationsComboBox.setEnabled(true);
            this.sendTestCaseAction.setEnabled(true);
        }
        this.invalidate();
    }

    private void openURLSafely(String url) {
        if (SoapUI.isJXBrowserDisabled(true)) {
            Tools.openURL(url);
        } else if (this.browser != null) {
            this.browser.navigate(url, null);
        }
    }

    private void openInInternalBrowser(String url) {
        if (!SoapUI.isJXBrowserDisabled(true) && this.browser != null) {
            this.browser.navigate(url, null);
        }
    }

    private void openInExternalBrowser(String url) {
        Tools.openURL(url);
    }

    private String getFirstPageURL() {
        return System.getProperty("soapui.testondemand.firstpage.url", FIRST_PAGE_URL);
    }

    private String getMoreLocationsURL() {
        return System.getProperty("soapui.testondemand.getlocations.url", GET_MORE_LOCATIONS_URL);
    }

    private class TestOnDemandCallerThread
    extends Thread {
        private TestOnDemandCallerThread() {
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         * Enabled aggressive block sorting
         * Enabled unnecessary exception pruning
         * Enabled aggressive exception aggregation
         */
        public void run() {
            try {
                try {
                    locationsCache = TestOnDemandPanel.this.caller.getLocations();
                }
                catch (Exception e) {
                    SoapUI.logError(e, TestOnDemandPanel.COULD_NOT_GET_LOCATIONS_MESSAGE);
                    Object var3_2 = null;
                    TestOnDemandPanel.this.populateLocationsComboBox();
                    return;
                }
                Object var3_1 = null;
            }
            catch (Throwable throwable) {
                Object var3_3 = null;
                TestOnDemandPanel.this.populateLocationsComboBox();
                throw throwable;
            }
            TestOnDemandPanel.this.populateLocationsComboBox();
        }
    }

    private class SendTestCaseWorker
    extends Worker.WorkerAdapter {
        private final WsdlTestCase testCase;
        private final Location selectedLocation;
        private String result = null;

        public SendTestCaseWorker(WsdlTestCase testCase, Location selectedLocation) {
            this.testCase = testCase;
            this.selectedLocation = selectedLocation;
        }

        public Object construct(XProgressMonitor monitor) {
            try {
                this.result = TestOnDemandPanel.this.caller.sendTestCase(this.testCase, this.selectedLocation);
            }
            catch (Exception e) {
                SoapUI.logError(e);
                UISupport.showErrorMessage(TestOnDemandPanel.COULD_NOT_UPLOAD_MESSAGE);
            }
            return this.result;
        }

        public String getResult() {
            return this.result;
        }
    }

    private class CustomNativeBrowserComponent
    extends NativeBrowserComponent {
        public CustomNativeBrowserComponent(boolean addToolbar, boolean addStatusBar) {
            super(addToolbar, addStatusBar);
        }
    }

    private class LocationComboBoxAction
    implements ActionListener {
        private LocationComboBoxAction() {
        }

        public void actionPerformed(ActionEvent e) {
            Object selectedItem = TestOnDemandPanel.this.locationsComboBox.getSelectedItem();
            if (selectedItem != null) {
                if (TestOnDemandPanel.this.locationsComboBox.getSelectedItem().equals(TestOnDemandPanel.GET_MORE_LOCATIONS_MESSAGE)) {
                    TestOnDemandPanel.this.openInExternalBrowser(TestOnDemandPanel.this.getMoreLocationsURL());
                    TestOnDemandPanel.this.sendTestCaseAction.setEnabled(false);
                    TestOnDemandPanel.this.serverIPAddressesLabel.setText(null);
                } else {
                    if (TestOnDemandPanel.this.locationsComboBox.isEnabled() && !TestOnDemandPanel.this.sendTestCaseAction.isEnabled()) {
                        TestOnDemandPanel.this.openInInternalBrowser(TestOnDemandPanel.this.getFirstPageURL());
                        TestOnDemandPanel.this.sendTestCaseAction.setEnabled(true);
                    }
                    if (selectedItem instanceof Location) {
                        Object[] serverIPAddresses = ((Location)selectedItem).getServerIPAddresses();
                        if (serverIPAddresses != null && serverIPAddresses.length > 0) {
                            String severIpAddressList = Joiner.on((String)TestOnDemandPanel.SERVER_IP_ADDRESSES_DELIMETER).join(serverIPAddresses);
                            TestOnDemandPanel.this.serverIPAddressesLabel.setText(TestOnDemandPanel.SERVER_IP_ADDRESSES_PREFIX + severIpAddressList);
                        } else {
                            TestOnDemandPanel.this.serverIPAddressesLabel.setText("IP: <No IP addresses found>");
                        }
                        TestOnDemandPanel.this.invalidate();
                    }
                }
            }
        }
    }

    private class SendTestCaseAction
    extends AbstractAction {
        public SendTestCaseAction() {
            this.putValue("SmallIcon", UISupport.createImageIcon("/run.gif"));
            this.putValue("ShortDescription", "Run Test On Demand report");
        }

        public void actionPerformed(ActionEvent arg0) {
            if (TestOnDemandPanel.this.validator != null && !TestOnDemandPanel.this.validator.isValid(TestOnDemandPanel.this.testCase)) {
                UISupport.showErrorMessage("Your project contains external dependencies that are not supported by the Test-On-Demand functionality at this point.");
                return;
            }
            if (TestOnDemandPanel.this.locationsComboBox != null) {
                Location selectedLocation = (Location)TestOnDemandPanel.this.locationsComboBox.getSelectedItem();
                XProgressDialog progressDialog = UISupport.getDialogs().createProgressDialog(TestOnDemandPanel.UPLOAD_TEST_CASE_HEADING, 3, TestOnDemandPanel.UPLOADING_TEST_CASE_MESSAGE, false);
                SendTestCaseWorker sendTestCaseWorker = new SendTestCaseWorker(TestOnDemandPanel.this.testCase, selectedLocation);
                try {
                    progressDialog.run(sendTestCaseWorker);
                }
                catch (Exception e) {
                    SoapUI.logError(e);
                }
                String redirectUrl = sendTestCaseWorker.getResult();
                if (!Strings.isNullOrEmpty((String)redirectUrl)) {
                    TestOnDemandPanel.this.openURLSafely(redirectUrl);
                }
            }
        }
    }
}

