/*
 * Decompiled with CFR 0.152.
 */
package com.eviware.soapui.impl.wsdl.panels.teststeps.support;

import com.eviware.soapui.SoapUI;
import com.eviware.soapui.impl.wsdl.MutableTestPropertyHolder;
import com.eviware.soapui.impl.wsdl.WsdlProject;
import com.eviware.soapui.impl.wsdl.panels.teststeps.support.DefaultPropertyTableHolderModel;
import com.eviware.soapui.impl.wsdl.panels.teststeps.support.PropertyHolderTableModel;
import com.eviware.soapui.impl.wsdl.teststeps.AMFRequestTestStep;
import com.eviware.soapui.impl.wsdl.teststeps.JdbcRequestTestStep;
import com.eviware.soapui.model.TestPropertyHolder;
import com.eviware.soapui.model.environment.Environment;
import com.eviware.soapui.model.environment.EnvironmentListener;
import com.eviware.soapui.model.iface.Interface;
import com.eviware.soapui.model.mock.MockService;
import com.eviware.soapui.model.project.Project;
import com.eviware.soapui.model.propertyexpansion.PropertyExpansionImpl;
import com.eviware.soapui.model.propertyexpansion.PropertyExpansionUtils;
import com.eviware.soapui.model.support.ProjectListenerAdapter;
import com.eviware.soapui.model.support.TestPropertyUtils;
import com.eviware.soapui.model.testsuite.TestProperty;
import com.eviware.soapui.model.testsuite.TestPropertyListener;
import com.eviware.soapui.model.testsuite.TestSuite;
import com.eviware.soapui.model.tree.nodes.PropertyTreeNode;
import com.eviware.soapui.support.StringUtils;
import com.eviware.soapui.support.UISupport;
import com.eviware.soapui.support.components.JXToolBar;
import com.eviware.soapui.support.xml.XmlUtils;
import com.eviware.x.form.XFormDialog;
import com.eviware.x.form.support.ADialogBuilder;
import com.eviware.x.form.support.AField;
import com.eviware.x.form.support.AForm;
import java.awt.BorderLayout;
import java.awt.Component;
import java.awt.Point;
import java.awt.datatransfer.DataFlavor;
import java.awt.datatransfer.Transferable;
import java.awt.dnd.DropTarget;
import java.awt.dnd.DropTargetDragEvent;
import java.awt.dnd.DropTargetDropEvent;
import java.awt.dnd.DropTargetEvent;
import java.awt.dnd.DropTargetListener;
import java.awt.event.ActionEvent;
import java.io.BufferedReader;
import java.io.File;
import java.io.FileReader;
import java.io.IOException;
import java.util.Arrays;
import java.util.HashSet;
import javax.swing.AbstractAction;
import javax.swing.JButton;
import javax.swing.JPanel;
import javax.swing.JScrollPane;
import javax.swing.JTable;
import javax.swing.SwingUtilities;
import javax.swing.TransferHandler;
import javax.swing.event.ListSelectionEvent;
import javax.swing.event.ListSelectionListener;
import javax.swing.table.DefaultTableCellRenderer;

public class PropertyHolderTable
extends JPanel {
    protected final TestPropertyHolder holder;
    protected PropertyHolderTableModel propertiesModel;
    protected RemovePropertyAction removePropertyAction;
    protected AddPropertyAction addPropertyAction;
    protected InternalTestPropertyListener testPropertyListener;
    protected JTable propertiesTable;
    protected JXToolBar toolbar;
    protected LoadPropertiesAction loadPropertiesAction;
    protected MovePropertyUpAction movePropertyUpAction;
    protected MovePropertyDownAction movePropertyDownAction;
    private EnvironmentListener environmentListener;
    private ProjectListenerAdapter projectListener;

    public PropertyHolderTable(TestPropertyHolder holder) {
        super(new BorderLayout());
        this.holder = holder;
        this.loadPropertiesAction = new LoadPropertiesAction();
        this.testPropertyListener = new InternalTestPropertyListener();
        holder.addTestPropertyListener(this.testPropertyListener);
        JScrollPane scrollPane = new JScrollPane(this.buildPropertiesTable());
        if (this.getHolder().getModelItem() != null) {
            DropTarget dropTarget = new DropTarget(scrollPane, new PropertyHolderTablePropertyExpansionDropTarget());
            dropTarget.setDefaultActions(3);
        }
        this.add((Component)scrollPane, "Center");
        this.add(this.buildToolbar(), "North");
        this.projectListener = new ProjectListenerAdapter(){

            public void environmentSwitched(Environment environment) {
                PropertyHolderTable.this.getPropertiesModel().fireTableDataChanged();
            }
        };
    }

    protected JTable buildPropertiesTable() {
        this.propertiesModel = new DefaultPropertyTableHolderModel(this.holder);
        this.propertiesTable = new PropertiesHolderJTable();
        this.propertiesTable.setSurrendersFocusOnKeystroke(true);
        this.propertiesTable.putClientProperty("terminateEditOnFocusLost", Boolean.TRUE);
        this.propertiesTable.getSelectionModel().addListSelectionListener(new ListSelectionListener(){

            public void valueChanged(ListSelectionEvent e) {
                int selectedRow = PropertyHolderTable.this.propertiesTable.getSelectedRow();
                if (PropertyHolderTable.this.removePropertyAction != null) {
                    PropertyHolderTable.this.removePropertyAction.setEnabled(selectedRow != -1);
                }
                if (PropertyHolderTable.this.movePropertyUpAction != null) {
                    PropertyHolderTable.this.movePropertyUpAction.setEnabled(selectedRow > 0);
                }
                if (PropertyHolderTable.this.movePropertyDownAction != null) {
                    PropertyHolderTable.this.movePropertyDownAction.setEnabled(selectedRow >= 0 && selectedRow < PropertyHolderTable.this.propertiesTable.getRowCount() - 1);
                }
            }
        });
        this.propertiesTable.setDragEnabled(true);
        this.propertiesTable.setTransferHandler(new TransferHandler("testProperty"));
        if (this.getHolder().getModelItem() != null) {
            DropTarget dropTarget = new DropTarget(this.propertiesTable, new PropertyHolderTablePropertyExpansionDropTarget());
            dropTarget.setDefaultActions(3);
        }
        this.propertiesTable.getColumnModel().getColumn(1).setCellRenderer(new PropertiesTableCellRenderer());
        return this.propertiesTable;
    }

    private Component buildToolbar() {
        this.toolbar = UISupport.createSmallToolbar();
        if (this.holder instanceof MutableTestPropertyHolder) {
            this.removePropertyAction = new RemovePropertyAction();
            this.addPropertyAction = new AddPropertyAction();
            this.movePropertyUpAction = new MovePropertyUpAction();
            this.movePropertyDownAction = new MovePropertyDownAction();
            JButton addPropertyButton = UISupport.createToolbarButton(this.addPropertyAction);
            this.toolbar.add(addPropertyButton);
            JButton removePropertyButton = UISupport.createToolbarButton(this.removePropertyAction);
            this.toolbar.add(removePropertyButton);
            this.toolbar.addRelatedGap();
            JButton movePropertyUpButton = UISupport.createToolbarButton(this.movePropertyUpAction);
            this.toolbar.add(movePropertyUpButton);
            JButton movePropertyDownButton = UISupport.createToolbarButton(this.movePropertyDownAction);
            this.toolbar.add(movePropertyDownButton);
            if (!(this.holder instanceof AMFRequestTestStep) && !(this.holder instanceof JdbcRequestTestStep)) {
                this.toolbar.addRelatedGap();
                this.toolbar.add(UISupport.createToolbarButton(new SortPropertiesAction()));
                this.toolbar.addRelatedGap();
            }
        }
        JButton clearPropertiesButton = UISupport.createToolbarButton(new ClearPropertiesAction());
        this.toolbar.add(clearPropertiesButton);
        JButton loadPropertiesButton = UISupport.createToolbarButton(this.loadPropertiesAction);
        this.toolbar.add(loadPropertiesButton);
        this.toolbar.add(UISupport.createToolbarButton(new SavePropertiesAction()));
        return this.toolbar;
    }

    public JXToolBar getToolbar() {
        return this.toolbar;
    }

    public JTable getPropertiesTable() {
        return this.propertiesTable;
    }

    public void release() {
        if (this.propertiesTable.isEditing()) {
            this.propertiesTable.getCellEditor().stopCellEditing();
        }
        this.holder.removeTestPropertyListener(this.testPropertyListener);
        if (this.holder instanceof WsdlProject) {
            WsdlProject project = (WsdlProject)this.holder;
            project.removeEnvironmentListener(this.environmentListener);
            project.removeProjectListener(this.projectListener);
        }
        this.projectListener = null;
    }

    public void setEnabled(boolean enabled) {
        this.addPropertyAction.setEnabled(enabled);
        this.removePropertyAction.setEnabled(enabled);
        this.propertiesTable.setEnabled(enabled);
        this.loadPropertiesAction.setEnabled(enabled);
        super.setEnabled(enabled);
    }

    public TestPropertyHolder getHolder() {
        return this.holder;
    }

    public PropertyHolderTableModel getPropertiesModel() {
        return this.propertiesModel;
    }

    public EnvironmentListener getEnvironmentListener() {
        return this.environmentListener;
    }

    public void setEnvironmentListener(EnvironmentListener environmentListener) {
        this.environmentListener = environmentListener;
    }

    public void interfaceAdded(Interface iface) {
    }

    public void interfaceRemoved(Interface iface) {
    }

    public void interfaceUpdated(Interface iface) {
    }

    public void testSuiteAdded(TestSuite testSuite) {
    }

    public void testSuiteRemoved(TestSuite testSuite) {
    }

    public void testSuiteMoved(TestSuite testSuite, int index, int offset) {
    }

    public void mockServiceAdded(MockService mockService) {
    }

    public void mockServiceRemoved(MockService mockService) {
    }

    public void afterLoad(Project project) {
    }

    public void beforeSave(Project project) {
    }

    public void environmentAdded(Environment env) {
    }

    public void environmentRemoved(Environment env, int index) {
    }

    public void environmentSwitched(Environment environment) {
    }

    public ProjectListenerAdapter getProjectListener() {
        return this.projectListener;
    }

    public void setProjectListener(ProjectListenerAdapter projectListener) {
        this.projectListener = projectListener;
    }

    protected static class PropertiesTableCellRenderer
    extends DefaultTableCellRenderer {
        protected PropertiesTableCellRenderer() {
        }

        public Component getTableCellRendererComponent(JTable table, Object value, boolean isSelected, boolean hasFocus, int row, int column) {
            String val;
            Component component = super.getTableCellRendererComponent(table, value, isSelected, hasFocus, row, column);
            if (value instanceof String && value != null && ((String)value).length() > 0 && ((val = ((String)table.getValueAt(row, 0)).toLowerCase()).startsWith("password") || val.endsWith("password"))) {
                component = super.getTableCellRendererComponent(table, "**************", isSelected, hasFocus, row, column);
            }
            return component;
        }
    }

    public final class PropertyHolderTablePropertyExpansionDropTarget
    implements DropTargetListener {
        public void dragEnter(DropTargetDragEvent dtde) {
            if (!this.isAcceptable(dtde.getTransferable(), dtde.getLocation())) {
                dtde.rejectDrag();
            }
        }

        public void dragExit(DropTargetEvent dtde) {
        }

        public void dragOver(DropTargetDragEvent dtde) {
            if (!this.isAcceptable(dtde.getTransferable(), dtde.getLocation())) {
                dtde.rejectDrag();
            } else {
                dtde.acceptDrag(dtde.getDropAction());
            }
        }

        public void drop(DropTargetDropEvent dtde) {
            if (!this.isAcceptable(dtde.getTransferable(), dtde.getLocation())) {
                dtde.rejectDrop();
            } else {
                try {
                    Transferable transferable = dtde.getTransferable();
                    Object transferData = transferable.getTransferData(transferable.getTransferDataFlavors()[0]);
                    if (transferData instanceof PropertyTreeNode.PropertyModelItem) {
                        dtde.acceptDrop(dtde.getDropAction());
                        PropertyTreeNode.PropertyModelItem modelItem = (PropertyTreeNode.PropertyModelItem)transferData;
                        String xpath = modelItem.getXPath();
                        if (xpath == null && XmlUtils.seemsToBeXml(modelItem.getProperty().getValue()) && (xpath = UISupport.selectXPath("Create PropertyExpansion", "Select XPath below", modelItem.getProperty().getValue(), null)) != null) {
                            xpath = PropertyExpansionUtils.shortenXPathForPropertyExpansion(xpath, modelItem.getProperty().getValue());
                        }
                        PropertyExpansionImpl propertyExpansion = new PropertyExpansionImpl(modelItem.getProperty(), xpath);
                        Point point = dtde.getLocation();
                        int column = PropertyHolderTable.this.getPropertiesTable().columnAtPoint(point);
                        int row = PropertyHolderTable.this.getPropertiesTable().rowAtPoint(point);
                        if (row == -1) {
                            if (PropertyHolderTable.this.holder instanceof MutableTestPropertyHolder) {
                                MutableTestPropertyHolder mtph = (MutableTestPropertyHolder)PropertyHolderTable.this.holder;
                                String name = UISupport.prompt("Specify unique name of property", "Add Property", modelItem.getProperty().getName());
                                while (name != null && mtph.hasProperty(name)) {
                                    name = UISupport.prompt("Specify unique name of property", "Add Property", modelItem.getProperty().getName());
                                }
                                if (name != null) {
                                    mtph.addProperty(name).setValue(propertyExpansion.toString());
                                }
                            }
                        } else {
                            PropertyHolderTable.this.getPropertiesTable().setValueAt(propertyExpansion.toString(), row, column);
                        }
                        dtde.dropComplete(true);
                    }
                }
                catch (Exception e) {
                    SoapUI.logError(e);
                }
            }
        }

        public void dropActionChanged(DropTargetDragEvent dtde) {
        }

        public boolean isAcceptable(Transferable transferable, Point point) {
            int row = PropertyHolderTable.this.getPropertiesTable().rowAtPoint(point);
            if (row >= 0) {
                int column = PropertyHolderTable.this.getPropertiesTable().columnAtPoint(point);
                if (column != 1) {
                    return false;
                }
                if (!PropertyHolderTable.this.getPropertiesTable().isCellEditable(row, column)) {
                    return false;
                }
            } else if (!(PropertyHolderTable.this.getHolder() instanceof MutableTestPropertyHolder)) {
                return false;
            }
            DataFlavor[] flavors = transferable.getTransferDataFlavors();
            for (int i = 0; i < flavors.length; ++i) {
                DataFlavor flavor = flavors[i];
                if (!flavor.isMimeTypeEqual("application/x-java-jvm-local-objectref")) continue;
                try {
                    Object modelItem = transferable.getTransferData(flavor);
                    if (!(modelItem instanceof PropertyTreeNode.PropertyModelItem) || ((PropertyTreeNode.PropertyModelItem)modelItem).getProperty().getModelItem() == PropertyHolderTable.this.getHolder().getModelItem()) continue;
                    return PropertyExpansionUtils.canExpandProperty(PropertyHolderTable.this.getHolder().getModelItem(), ((PropertyTreeNode.PropertyModelItem)modelItem).getProperty());
                }
                catch (Exception ex) {
                    SoapUI.logError(ex);
                }
            }
            return false;
        }
    }

    @AForm(name="Load Properties", description="Set load options below")
    private static interface LoadOptionsForm {
        @AField(name="File", description="The Properties file to load", type=AField.AFieldType.FILE)
        public static final String FILE = "File";
        @AField(name="Create Missing", description="Creates Missing Properties", type=AField.AFieldType.BOOLEAN)
        public static final String CREATEMISSING = "Create Missing";
        @AField(name="Delete Remaining", description="Deletes properties not in file", type=AField.AFieldType.BOOLEAN)
        public static final String DELETEREMAINING = "Delete Remaining";
    }

    private class SortPropertiesAction
    extends AbstractAction {
        public SortPropertiesAction() {
            this.putValue("SmallIcon", UISupport.createImageIcon("/arrow_down.png"));
            this.putValue("ShortDescription", "Sorts properties alphabetically");
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        public void actionPerformed(ActionEvent e) {
            if (PropertyHolderTable.this.holder.getPropertyCount() == 0) {
                UISupport.showErrorMessage("No properties to sort!");
                return;
            }
            try {
                UISupport.setHourglassCursor();
                TestPropertyUtils.sortProperties((MutableTestPropertyHolder)PropertyHolderTable.this.holder);
                Object var3_2 = null;
            }
            catch (Throwable throwable) {
                Object var3_3 = null;
                UISupport.resetCursor();
                throw throwable;
            }
            UISupport.resetCursor();
        }
    }

    private class SavePropertiesAction
    extends AbstractAction {
        public SavePropertiesAction() {
            this.putValue("SmallIcon", UISupport.createImageIcon("/set_properties_target.gif"));
            this.putValue("ShortDescription", "Saves current property-values to a file");
        }

        public void actionPerformed(ActionEvent e) {
            if (PropertyHolderTable.this.holder.getPropertyCount() == 0) {
                UISupport.showErrorMessage("No properties to save!");
                return;
            }
            File file = UISupport.getFileDialogs().saveAs(this, "Save Properties");
            if (file != null) {
                try {
                    int cnt = TestPropertyUtils.saveTo(PropertyHolderTable.this.holder, file.getAbsolutePath());
                    UISupport.showInfoMessage("Saved " + cnt + " propert" + (cnt == 1 ? "y" : "ies") + " to file");
                }
                catch (IOException e1) {
                    UISupport.showErrorMessage(e1);
                }
            }
        }
    }

    protected class LoadPropertiesAction
    extends AbstractAction {
        private XFormDialog dialog;

        public LoadPropertiesAction() {
            this.putValue("SmallIcon", UISupport.createImageIcon("/load_properties.gif"));
            this.putValue("ShortDescription", "Loads property values from an external file");
        }

        public void actionPerformed(ActionEvent e) {
            if (this.dialog == null) {
                this.dialog = ADialogBuilder.buildDialog(LoadOptionsForm.class);
            }
            this.dialog.getFormField("Delete Remaining").setEnabled(PropertyHolderTable.this.holder instanceof MutableTestPropertyHolder);
            this.dialog.getFormField("Create Missing").setEnabled(PropertyHolderTable.this.holder instanceof MutableTestPropertyHolder);
            if (this.dialog.show()) {
                try {
                    BufferedReader reader = new BufferedReader(new FileReader(this.dialog.getValue("File")));
                    String line = reader.readLine();
                    int count = 0;
                    HashSet<String> names = new HashSet<String>(Arrays.asList(PropertyHolderTable.this.holder.getPropertyNames()));
                    while (line != null) {
                        int ix;
                        if (line.trim().length() > 0 && line.charAt(0) != '#' && (ix = line.indexOf(61)) > 0) {
                            String value;
                            String name = line.substring(0, ix).trim();
                            String string = value = line.length() > ix ? line.substring(ix + 1) : "";
                            if (value.endsWith("\\")) {
                                value = value.substring(0, value.length() - 1);
                                String ln = reader.readLine();
                                while (ln != null && ln.endsWith("\\")) {
                                    value = value + ln.substring(0, ln.length() - 1);
                                    ln = reader.readLine();
                                }
                                if (ln != null) {
                                    value = value + ln;
                                }
                                if (ln == null) break;
                            }
                            if (PropertyHolderTable.this.holder.hasProperty(name)) {
                                ++count;
                                PropertyHolderTable.this.holder.setPropertyValue(name, value);
                            } else if (this.dialog.getBooleanValue("Create Missing") && PropertyHolderTable.this.holder instanceof MutableTestPropertyHolder) {
                                TestProperty prop = ((MutableTestPropertyHolder)PropertyHolderTable.this.holder).addProperty(name);
                                if (!prop.isReadOnly()) {
                                    prop.setValue(value);
                                }
                                ++count;
                            }
                            names.remove(name);
                        }
                        line = reader.readLine();
                    }
                    if (this.dialog.getBooleanValue("Delete Remaining") && PropertyHolderTable.this.holder instanceof MutableTestPropertyHolder) {
                        for (String name : names) {
                            ((MutableTestPropertyHolder)PropertyHolderTable.this.holder).removeProperty(name);
                        }
                    }
                    reader.close();
                    UISupport.showInfoMessage("Added/Updated " + count + " properties from file");
                }
                catch (Exception ex) {
                    UISupport.showErrorMessage(ex);
                }
            }
        }
    }

    protected class MovePropertyDownAction
    extends AbstractAction {
        public MovePropertyDownAction() {
            this.putValue("SmallIcon", UISupport.createImageIcon("/down_arrow.gif"));
            this.putValue("ShortDescription", "Moves selected property down one row");
            this.setEnabled(false);
        }

        public void actionPerformed(ActionEvent e) {
            int ix = PropertyHolderTable.this.propertiesTable.getSelectedRow();
            if (ix != -1) {
                ((MutableTestPropertyHolder)PropertyHolderTable.this.holder).moveProperty(PropertyHolderTable.this.holder.getPropertyAt(ix).getName(), ix + 1);
                PropertyHolderTable.this.propertiesTable.setRowSelectionInterval(ix + 1, ix + 1);
            }
        }
    }

    protected class MovePropertyUpAction
    extends AbstractAction {
        public MovePropertyUpAction() {
            this.putValue("SmallIcon", UISupport.createImageIcon("/up_arrow.gif"));
            this.putValue("ShortDescription", "Moves selected property up one row");
            this.setEnabled(false);
        }

        public void actionPerformed(ActionEvent e) {
            int ix = PropertyHolderTable.this.propertiesTable.getSelectedRow();
            if (ix != -1) {
                ((MutableTestPropertyHolder)PropertyHolderTable.this.holder).moveProperty(PropertyHolderTable.this.holder.getPropertyAt(ix).getName(), ix - 1);
                PropertyHolderTable.this.propertiesTable.setRowSelectionInterval(ix - 1, ix - 1);
            }
        }
    }

    protected class ClearPropertiesAction
    extends AbstractAction {
        public ClearPropertiesAction() {
            this.putValue("SmallIcon", UISupport.createImageIcon("/clear_properties.gif"));
            this.putValue("ShortDescription", "Clears all current property values");
        }

        public void actionPerformed(ActionEvent e) {
            if (UISupport.confirm("Clear all property values?", "Clear Properties")) {
                for (String name : PropertyHolderTable.this.holder.getPropertyNames()) {
                    PropertyHolderTable.this.holder.getProperty(name).setValue(null);
                }
            }
        }
    }

    protected class RemovePropertyAction
    extends AbstractAction {
        public RemovePropertyAction() {
            this.putValue("SmallIcon", UISupport.createImageIcon("/remove_property.gif"));
            this.putValue("ShortDescription", "Removes the selected property from the property list");
            this.setEnabled(false);
        }

        public void actionPerformed(ActionEvent e) {
            int row = PropertyHolderTable.this.propertiesTable.getSelectedRow();
            if (row == -1) {
                return;
            }
            UISupport.stopCellEditing(PropertyHolderTable.this.propertiesTable);
            String propertyName = PropertyHolderTable.this.propertiesModel.getValueAt(row, 0).toString();
            if (UISupport.confirm("Remove property [" + propertyName + "]?", "Remove Property")) {
                ((MutableTestPropertyHolder)PropertyHolderTable.this.holder).removeProperty(propertyName);
                PropertyHolderTable.this.propertiesModel.fireTableRowsDeleted(row, row);
            }
        }
    }

    private class AddPropertyAction
    extends AbstractAction {
        public AddPropertyAction() {
            this.putValue("SmallIcon", UISupport.createImageIcon("/add_property.gif"));
            this.putValue("ShortDescription", "Adds a property to the property list");
        }

        public void actionPerformed(ActionEvent e) {
            String name = UISupport.prompt("Specify unique property name", "Add Property", "");
            if (StringUtils.hasContent(name)) {
                if (PropertyHolderTable.this.holder.hasProperty(name)) {
                    UISupport.showErrorMessage("Property name [" + name + "] already exists..");
                    return;
                }
                ((MutableTestPropertyHolder)PropertyHolderTable.this.holder).addProperty(name);
                final int row = PropertyHolderTable.this.holder.getPropertyNames().length - 1;
                PropertyHolderTable.this.propertiesModel.fireTableDataChanged();
                SwingUtilities.invokeLater(new Runnable(){

                    public void run() {
                        PropertyHolderTable.this.requestFocusInWindow();
                        PropertyHolderTable.this.scrollRectToVisible(PropertyHolderTable.this.propertiesTable.getCellRect(row, 1, true));
                        SwingUtilities.invokeLater(new Runnable(){

                            public void run() {
                                PropertyHolderTable.this.propertiesTable.editCellAt(row, 1);
                                Component editorComponent = PropertyHolderTable.this.propertiesTable.getEditorComponent();
                                if (editorComponent != null) {
                                    editorComponent.requestFocusInWindow();
                                }
                            }
                        });
                    }
                });
            }
        }
    }

    private final class InternalTestPropertyListener
    implements TestPropertyListener {
        private boolean enabled = true;

        private InternalTestPropertyListener() {
        }

        public boolean isEnabled() {
            return this.enabled;
        }

        public void setEnabled(boolean enabled) {
            this.enabled = enabled;
        }

        public void propertyAdded(String name) {
            if (this.enabled) {
                PropertyHolderTable.this.propertiesModel.fireTableDataChanged();
            }
        }

        public void propertyRemoved(String name) {
            if (this.enabled) {
                PropertyHolderTable.this.propertiesModel.fireTableDataChanged();
            }
        }

        public void propertyRenamed(String oldName, String newName) {
            if (this.enabled) {
                PropertyHolderTable.this.propertiesModel.fireTableDataChanged();
            }
        }

        public void propertyValueChanged(String name, String oldValue, String newValue) {
            if (this.enabled) {
                PropertyHolderTable.this.propertiesModel.fireTableDataChanged();
            }
        }

        public void propertyMoved(String name, int oldIndex, int newIndex) {
            if (this.enabled) {
                PropertyHolderTable.this.propertiesModel.fireTableDataChanged();
            }
        }
    }

    public class PropertiesHolderJTable
    extends JTable {
        public PropertiesHolderJTable() {
            super(PropertyHolderTable.this.propertiesModel);
            this.setSelectionMode(0);
            this.setSurrendersFocusOnKeystroke(true);
            this.setRowHeight(19);
        }

        public PropertyTreeNode.PropertyModelItem getTestProperty() {
            int index = this.getSelectedRow();
            if (index == -1) {
                return null;
            }
            TestProperty property = PropertyHolderTable.this.propertiesModel.getPropertyAtRow(index);
            return new PropertyTreeNode.PropertyModelItem(property, true);
        }
    }
}

