/*
 * Decompiled with CFR 0.152.
 */
package com.eviware.soapui.impl.wsdl.submit.transports.http;

import com.eviware.soapui.SoapUI;
import com.eviware.soapui.impl.wsdl.submit.transports.http.SSLInfo;
import com.eviware.soapui.impl.wsdl.submit.transports.http.support.metrics.SoapUIMetrics;
import com.eviware.soapui.impl.wsdl.support.CompressionSupport;
import com.eviware.soapui.impl.wsdl.support.http.HttpClientSupport;
import com.eviware.soapui.settings.HttpSettings;
import com.eviware.soapui.support.StringUtils;
import com.eviware.soapui.support.Tools;
import java.io.ByteArrayInputStream;
import java.io.ByteArrayOutputStream;
import java.io.FileInputStream;
import java.io.FileOutputStream;
import java.io.IOException;
import java.io.InputStream;
import javax.net.ssl.SSLSession;
import org.apache.http.Header;
import org.apache.http.HeaderElement;
import org.apache.http.HttpEntity;
import org.apache.http.HttpResponse;
import org.apache.http.NameValuePair;
import org.apache.http.entity.BufferedHttpEntity;
import org.apache.http.impl.io.HttpTransportMetricsImpl;
import org.apache.http.io.HttpTransportMetrics;
import org.apache.http.util.EntityUtils;

public class HttpMethodSupport {
    private long timeTaken;
    private long startTime;
    private long maxSize;
    private long responseReadTime;
    private byte[] responseBody;
    private SSLInfo sslInfo;
    private String dumpFile;
    private Throwable failureCause;
    private boolean decompress = !SoapUI.getSettings().getBoolean(HttpSettings.DISABLE_RESPONSE_DECOMPRESSION);
    private HttpResponse httpResponse;
    private SoapUIMetrics metrics = new SoapUIMetrics((HttpTransportMetrics)new HttpTransportMetricsImpl(), (HttpTransportMetrics)new HttpTransportMetricsImpl());

    public boolean isDecompress() {
        return this.decompress;
    }

    public void setDecompress(boolean decompress) {
        this.decompress = decompress;
    }

    public String getDumpFile() {
        return this.dumpFile;
    }

    public void setDumpFile(String dumpFile) {
        this.dumpFile = dumpFile;
    }

    public void afterReadResponse(SSLSession session) {
        if (session != null) {
            this.sslInfo = new SSLInfo(session);
        }
    }

    public long getMaxSize() {
        return this.maxSize;
    }

    public void setMaxSize(long maxSize) {
        this.maxSize = maxSize;
    }

    public void afterWriteRequest() {
        if (this.startTime == 0L) {
            this.startTime = System.nanoTime();
        }
    }

    public void initStartTime() {
        this.startTime = System.nanoTime();
    }

    public long getTimeTaken() {
        if (this.timeTaken == 0L) {
            this.timeTaken = (System.nanoTime() - this.startTime) / 1000000L;
        }
        return this.timeTaken;
    }

    public long getStartTime() {
        return this.startTime;
    }

    public SSLInfo getSSLInfo() {
        return this.sslInfo;
    }

    public String getResponseContentType() {
        if (this.hasHttpResponse() && this.httpResponse.getEntity() != null && this.httpResponse.getEntity().getContentType() != null) {
            return this.httpResponse.getEntity().getContentType().getValue();
        }
        return null;
    }

    public long getResponseReadTime() {
        return this.responseReadTime / 1000000L;
    }

    public long getResponseReadTimeNanos() {
        return this.responseReadTime;
    }

    public byte[] getDecompressedResponseBody() throws IOException {
        String compressionAlg;
        if (this.hasHttpResponse() && (compressionAlg = HttpClientSupport.getResponseCompressionType(this.httpResponse)) != null) {
            try {
                return CompressionSupport.decompress(compressionAlg, this.responseBody);
            }
            catch (Exception e) {
                IOException ioe = new IOException("Decompression of response failed");
                ioe.initCause(e);
                throw ioe;
            }
        }
        return this.responseBody;
    }

    public String getResponseCharset() {
        if (this.hasHttpResponse()) {
            Header header = null;
            if (this.httpResponse.getEntity() != null) {
                header = this.httpResponse.getEntity().getContentType();
            }
            if (header != null) {
                for (HeaderElement headerElement : header.getElements()) {
                    NameValuePair parameter = headerElement.getParameterByName("charset");
                    if (parameter == null) continue;
                    return parameter.getValue();
                }
            }
            Header contentEncodingHeader = null;
            if (this.httpResponse.getEntity() != null) {
                contentEncodingHeader = this.httpResponse.getEntity().getContentEncoding();
            }
            if (contentEncodingHeader != null) {
                try {
                    String value = contentEncodingHeader.getValue();
                    if (CompressionSupport.getAvailableAlgorithm(value) == null) {
                        new String("").getBytes(value);
                        return value;
                    }
                }
                catch (Exception exception) {
                    // empty catch block
                }
            }
        }
        return null;
    }

    public Throwable getFailureCause() {
        return this.failureCause;
    }

    public boolean isFailed() {
        return this.failureCause != null;
    }

    public void setFailed(Throwable t) {
        this.failureCause = t;
    }

    public boolean hasResponse() {
        return this.responseBody != null;
    }

    public HttpResponse getHttpResponse() {
        return this.httpResponse;
    }

    public void setHttpResponse(HttpResponse httpResponse) {
        this.httpResponse = httpResponse;
    }

    public boolean hasHttpResponse() {
        return this.httpResponse != null;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public byte[] getResponseBody() throws IOException {
        if (this.responseBody != null) {
            return this.responseBody;
        }
        if (this.hasHttpResponse() && this.httpResponse.getEntity() != null) {
            long now = System.nanoTime();
            BufferedHttpEntity bufferedEntity = new BufferedHttpEntity(this.httpResponse.getEntity());
            long contentLength = bufferedEntity.getContentLength();
            if (this.metrics != null) {
                this.metrics.setContentLength(contentLength);
            }
            InputStream instream = bufferedEntity.getContent();
            try {
                if (this.maxSize == 0L || contentLength >= 0L && contentLength <= this.maxSize) {
                    String compressionAlg;
                    this.responseReadTime = System.nanoTime() - now;
                    this.responseBody = EntityUtils.toByteArray((HttpEntity)bufferedEntity);
                    try {
                        if (StringUtils.hasContent(this.dumpFile)) {
                            Tools.writeAll(new FileOutputStream(this.dumpFile), new ByteArrayInputStream(this.responseBody));
                        }
                    }
                    catch (IOException e) {
                        e.printStackTrace();
                    }
                    if (this.decompress && this.responseBody.length > 0 && (compressionAlg = HttpClientSupport.getResponseCompressionType(this.httpResponse)) != null) {
                        try {
                            this.responseBody = CompressionSupport.decompress(compressionAlg, this.responseBody);
                        }
                        catch (Exception e) {
                            IOException ioe = new IOException("Decompression of response failed");
                            ioe.initCause(e);
                            throw ioe;
                        }
                    }
                } else {
                    ByteArrayOutputStream outstream;
                    try {
                        if (StringUtils.hasContent(this.dumpFile) && instream != null) {
                            FileOutputStream fileOutputStream = new FileOutputStream(this.dumpFile);
                            Tools.writeAll(fileOutputStream, instream);
                            this.responseReadTime = System.nanoTime() - now;
                            fileOutputStream.close();
                            instream = new FileInputStream(this.dumpFile);
                        }
                    }
                    catch (IOException e) {
                        e.printStackTrace();
                    }
                    ByteArrayOutputStream byteArrayOutputStream = outstream = instream == null ? new ByteArrayOutputStream() : Tools.readAll(instream, this.maxSize);
                    if (this.responseReadTime == 0L) {
                        this.responseReadTime = System.nanoTime() - now;
                    }
                    this.responseBody = outstream.toByteArray();
                }
                Object var11_11 = null;
            }
            catch (Throwable throwable) {
                Object var11_12 = null;
                instream.close();
                throw throwable;
            }
            instream.close();
            {
            }
        }
        return this.responseBody;
    }

    public SoapUIMetrics getMetrics() {
        return this.metrics;
    }
}

