/*
 * Decompiled with CFR 0.152.
 */
package com.eviware.soapui.impl.wsdl.submit.transports.http.support.attachments;

import com.eviware.soapui.SoapUI;
import com.eviware.soapui.impl.support.http.HttpRequestInterface;
import com.eviware.soapui.impl.wsdl.submit.transports.http.support.attachments.WsdlRequestMimeMessageRequestEntity;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import javax.mail.MessagingException;
import javax.mail.internet.MimeMessage;
import javax.mail.internet.MimeMultipart;
import org.apache.http.Header;
import org.apache.http.entity.AbstractHttpEntity;
import org.apache.http.message.BasicHeader;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class RestRequestMimeMessageRequestEntity
extends AbstractHttpEntity {
    private final MimeMessage message;
    private final HttpRequestInterface<?> restRequest;

    public RestRequestMimeMessageRequestEntity(MimeMessage message, HttpRequestInterface<?> restRequest) {
        this.message = message;
        this.restRequest = restRequest;
    }

    public long getContentLength() {
        try {
            WsdlRequestMimeMessageRequestEntity.DummyOutputStream out = new WsdlRequestMimeMessageRequestEntity.DummyOutputStream();
            this.writeTo(out);
            return out.getSize();
        }
        catch (Exception e) {
            SoapUI.logError(e);
            return -1L;
        }
    }

    public Header getContentType() {
        try {
            String header = this.message.getHeader("Content-Type")[0];
            int ix = header.indexOf("boundary");
            return new BasicHeader("Content-Type", this.restRequest.getMediaType() + "; " + header.substring(ix));
        }
        catch (MessagingException e) {
            SoapUI.logError(e);
            return new BasicHeader("Content-Type", this.restRequest.getMediaType());
        }
    }

    public boolean isRepeatable() {
        return true;
    }

    public void writeTo(OutputStream arg0) throws IOException {
        try {
            arg0.write("\r\n".getBytes());
            ((MimeMultipart)this.message.getContent()).writeTo(arg0);
        }
        catch (Exception e) {
            SoapUI.logError(e);
        }
    }

    public InputStream getContent() throws IOException, IllegalStateException {
        try {
            return this.message.getInputStream();
        }
        catch (MessagingException e) {
            throw new IOException(e);
        }
    }

    public boolean isStreaming() {
        return false;
    }
}

