/*
 * Decompiled with CFR 0.152.
 */
package com.eviware.soapui.impl.wsdl.submit.transports.jms.util;

import com.eviware.soapui.SoapUI;
import com.eviware.soapui.impl.wsdl.support.MessageExchangeModelItem;
import com.eviware.soapui.model.ModelItem;
import com.eviware.soapui.model.iface.MessageExchange;
import com.eviware.soapui.model.iface.Request;
import com.eviware.soapui.support.StringUtils;
import com.eviware.soapui.support.types.StringToStringMap;
import com.eviware.soapui.support.xml.XmlUtils;
import java.util.Enumeration;
import javax.jms.BytesMessage;
import javax.jms.JMSException;
import javax.jms.MapMessage;

public class JMSUtils {
    private static boolean checkIfJMS(Request request) {
        try {
            String endpoint = request.getEndpoint();
            return StringUtils.hasContent(endpoint) && endpoint.startsWith("jms://");
        }
        catch (NullPointerException e) {
            SoapUI.logError(e);
            return false;
        }
    }

    private static boolean checkIfJMS(MessageExchangeModelItem messageExchange) {
        try {
            MessageExchange me = messageExchange.getMessageExchange();
            if (me != null) {
                StringToStringMap strmap = me.getProperties();
                if (strmap != null && strmap.containsKey("Endpoint")) {
                    String r = me.getProperty("Endpoint");
                    return r != null && r.startsWith("jms://");
                }
                return false;
            }
            return false;
        }
        catch (NullPointerException e) {
            SoapUI.logError(e);
            return false;
        }
    }

    public static boolean checkIfJMS(ModelItem modelItem) {
        if (modelItem instanceof Request) {
            return JMSUtils.checkIfJMS((Request)modelItem);
        }
        if (modelItem instanceof MessageExchangeModelItem) {
            return JMSUtils.checkIfJMS((MessageExchangeModelItem)modelItem);
        }
        return false;
    }

    public static String extractMapMessagePayloadToString(MapMessage mapMessage) throws JMSException {
        StringBuffer sb = new StringBuffer();
        Enumeration mapNames = mapMessage.getMapNames();
        while (mapNames.hasMoreElements()) {
            String key = (String)mapNames.nextElement();
            String value = mapMessage.getString(key);
            sb.append(key + ": " + value);
        }
        return sb.toString();
    }

    public static String extractMapMessagePayloadToXML(MapMessage mapMessage) throws JMSException {
        StringBuffer sb = new StringBuffer("<message>\n");
        Enumeration mapNames = mapMessage.getMapNames();
        while (mapNames.hasMoreElements()) {
            String key = (String)mapNames.nextElement();
            String value = mapMessage.getString(key);
            sb.append("<" + key + ">" + XmlUtils.entitize(value) + "</" + key + ">\n");
        }
        sb.append("</message>");
        return sb.toString();
    }

    public static byte[] extractByteArrayFromMessage(BytesMessage message) throws JMSException {
        byte[] bytes = new byte[(int)message.getBodyLength()];
        message.readBytes(bytes);
        return bytes;
    }
}

