/*
 * Decompiled with CFR 0.152.
 */
package com.eviware.soapui.impl.wsdl.support;

import com.eviware.soapui.support.Tools;
import java.io.ByteArrayInputStream;
import java.io.ByteArrayOutputStream;
import java.io.IOException;
import java.io.InputStream;
import java.util.zip.DeflaterOutputStream;
import java.util.zip.GZIPInputStream;
import java.util.zip.GZIPOutputStream;
import java.util.zip.InflaterInputStream;

public class CompressionSupport {
    public static final String ALG_GZIP = "gzip";
    public static final String ALG_DEFLATE = "deflate";
    private static final String[] algs = new String[]{"gzip", "deflate"};

    public static String getAvailableAlgorithms(String separator) {
        StringBuffer buf = new StringBuffer();
        for (int i = 0; i < algs.length; ++i) {
            if (i > 0) {
                buf.append(separator);
            }
            buf.append(algs[i]);
        }
        return buf.toString();
    }

    public static String getAvailableAlgorithm(String httpContentEncoding) {
        for (int i = 0; i < algs.length; ++i) {
            if (!httpContentEncoding.toLowerCase().endsWith(algs[i])) continue;
            return algs[i];
        }
        return null;
    }

    private static void checkAlg(String alg) throws Exception {
        if (!ALG_GZIP.equals(alg) && !ALG_DEFLATE.equals(alg)) {
            throw new Exception("Compression algorithm not supported: " + alg);
        }
    }

    public static byte[] compress(String alg, byte[] content) throws Exception {
        CompressionSupport.checkAlg(alg);
        if (ALG_GZIP.equals(alg)) {
            return CompressionSupport.GZIPCompress(content);
        }
        if (ALG_DEFLATE.equals(alg)) {
            return CompressionSupport.DeflaterCompress(content);
        }
        return null;
    }

    public static byte[] decompress(String alg, byte[] content) throws Exception {
        CompressionSupport.checkAlg(alg);
        if (ALG_GZIP.equals(alg)) {
            return CompressionSupport.GZIPDecompress(content);
        }
        if (ALG_DEFLATE.equals(alg)) {
            return CompressionSupport.DeflaterDecompress(content);
        }
        return null;
    }

    public static InputStream createCompressionInputStream(String alg, byte[] content) throws Exception {
        CompressionSupport.checkAlg(alg);
        ByteArrayInputStream bais = new ByteArrayInputStream(content);
        if (ALG_GZIP.equals(alg)) {
            return new GZIPInputStream(bais);
        }
        if (ALG_DEFLATE.equals(alg)) {
            return new InflaterInputStream(bais);
        }
        return null;
    }

    private static byte[] GZIPCompress(byte[] requestContent) throws IOException {
        ByteArrayOutputStream compressedContent = new ByteArrayOutputStream();
        GZIPOutputStream gzipstream = new GZIPOutputStream(compressedContent);
        gzipstream.write(requestContent);
        gzipstream.finish();
        return compressedContent.toByteArray();
    }

    private static byte[] GZIPDecompress(byte[] content) throws IOException {
        ByteArrayInputStream in = new ByteArrayInputStream(content);
        GZIPInputStream zipin = new GZIPInputStream(in);
        ByteArrayOutputStream out = Tools.readAll(zipin, -1L);
        content = out.toByteArray();
        out.close();
        zipin.close();
        return content;
    }

    private static byte[] DeflaterCompress(byte[] requestContent) throws IOException {
        ByteArrayOutputStream compressedContent = new ByteArrayOutputStream();
        DeflaterOutputStream defstream = new DeflaterOutputStream(compressedContent);
        defstream.write(requestContent);
        defstream.finish();
        return compressedContent.toByteArray();
    }

    private static byte[] DeflaterDecompress(byte[] content) throws IOException {
        ByteArrayInputStream in = new ByteArrayInputStream(content);
        InflaterInputStream zipin = new InflaterInputStream(in);
        ByteArrayOutputStream out = Tools.readAll(zipin, -1L);
        content = out.toByteArray();
        out.close();
        zipin.close();
        return content;
    }
}

