/*
 * Decompiled with CFR 0.152.
 */
package com.eviware.soapui.impl.wsdl.support.http;

import com.eviware.soapui.SoapUI;
import com.eviware.soapui.model.propertyexpansion.PropertyExpander;
import com.eviware.soapui.model.propertyexpansion.PropertyExpansionContext;
import com.eviware.soapui.model.settings.Settings;
import com.eviware.soapui.settings.ProxySettings;
import com.eviware.soapui.support.StringUtils;
import java.net.InetAddress;
import java.net.MalformedURLException;
import java.net.URL;
import java.net.UnknownHostException;
import java.util.regex.Matcher;
import java.util.regex.Pattern;
import org.apache.http.HttpHost;
import org.apache.http.auth.AuthScope;
import org.apache.http.auth.Credentials;
import org.apache.http.auth.NTCredentials;
import org.apache.http.auth.UsernamePasswordCredentials;
import org.apache.http.client.methods.HttpUriRequest;
import org.apache.http.impl.client.BasicCredentialsProvider;
import org.apache.http.protocol.HttpContext;

public class ProxyUtils {
    private static boolean proxyEnabled = SoapUI.getSettings().getBoolean(ProxySettings.ENABLE_PROXY);

    public static void initProxySettings(Settings settings, HttpUriRequest httpMethod, HttpContext httpContext, String urlString, PropertyExpansionContext context) {
        boolean enabled = proxyEnabled;
        BasicCredentialsProvider credsProvider = new BasicCredentialsProvider();
        String proxyHost = System.getProperty("http.proxyHost");
        String proxyPort = System.getProperty("http.proxyPort");
        if (proxyHost == null && enabled) {
            proxyHost = PropertyExpander.expandProperties(context, settings.getString(ProxySettings.HOST, ""));
        }
        if (proxyPort == null && proxyHost != null && enabled) {
            proxyPort = PropertyExpander.expandProperties(context, settings.getString(ProxySettings.PORT, ""));
        }
        if (!StringUtils.isNullOrEmpty(proxyHost) && !StringUtils.isNullOrEmpty(proxyPort)) {
            String[] excludes = PropertyExpander.expandProperties(context, settings.getString(ProxySettings.EXCLUDES, "")).split(",");
            try {
                URL url = new URL(urlString);
                if (!ProxyUtils.excludes(excludes, url.getHost(), url.getPort())) {
                    HttpHost proxy = new HttpHost(proxyHost, Integer.parseInt(proxyPort));
                    String proxyUsername = PropertyExpander.expandProperties(context, settings.getString(ProxySettings.USERNAME, null));
                    String proxyPassword = PropertyExpander.expandProperties(context, settings.getString(ProxySettings.PASSWORD, null));
                    if (proxyUsername != null && proxyPassword != null && proxyUsername.trim().length() > 0 && proxyPassword.trim().length() > 0) {
                        UsernamePasswordCredentials proxyCreds = new UsernamePasswordCredentials(proxyUsername, proxyPassword);
                        int ix = proxyUsername.indexOf(92);
                        if (ix > 0) {
                            String domain = proxyUsername.substring(0, ix);
                            if (proxyUsername.length() > ix + 1) {
                                String user = proxyUsername.substring(ix + 1);
                                proxyCreds = new NTCredentials(user, proxyPassword, proxyHost, domain);
                            }
                        }
                        credsProvider.setCredentials(new AuthScope(proxy.getHostName(), proxy.getPort()), (Credentials)proxyCreds);
                        httpContext.setAttribute("http.auth.credentials-provider", (Object)credsProvider);
                    }
                    httpMethod.getParams().setParameter("http.route.default-proxy", (Object)proxy);
                }
            }
            catch (MalformedURLException e) {
                SoapUI.logError(e);
            }
        }
    }

    public static boolean excludes(String[] excludes, String proxyHost, int proxyPort) {
        for (int c = 0; c < excludes.length; ++c) {
            String exclude = excludes[c].trim();
            if (exclude.length() == 0) continue;
            int ix = exclude.indexOf(58);
            if (ix >= 0 && exclude.length() > ix + 1) {
                String excludePort = exclude.substring(ix + 1);
                if (proxyPort == -1 || !excludePort.equals(String.valueOf(proxyPort))) continue;
                exclude = exclude.substring(0, ix);
            }
            String excludeIp = exclude.indexOf(42) >= 0 ? exclude : ProxyUtils.nslookup(exclude, true);
            String ip = ProxyUtils.nslookup(proxyHost, true);
            Pattern pattern = Pattern.compile(excludeIp);
            Matcher matcher = pattern.matcher(ip);
            Matcher matcher2 = pattern.matcher(proxyHost);
            if (!matcher.find() && !matcher2.find()) continue;
            return true;
        }
        return false;
    }

    private static String nslookup(String s, boolean ip) {
        String address;
        try {
            InetAddress host = InetAddress.getByName(s);
            address = ip ? host.getHostAddress() : host.getHostName();
        }
        catch (UnknownHostException ue) {
            return s;
        }
        return address;
    }

    public static boolean isProxyEnabled() {
        return proxyEnabled;
    }

    public static void setProxyEnabled(boolean proxyEnabled) {
        ProxyUtils.proxyEnabled = proxyEnabled;
    }
}

