/*
 * Decompiled with CFR 0.152.
 */
package com.eviware.soapui.impl.wsdl.support.policy;

import com.eviware.soapui.impl.support.definition.InterfaceDefinitionPart;
import com.eviware.soapui.impl.wsdl.support.wsdl.WsdlContext;
import com.eviware.soapui.impl.wsdl.support.wsdl.WsdlUtils;
import com.eviware.soapui.support.StringUtils;
import com.eviware.soapui.support.xml.XmlUtils;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.List;
import javax.wsdl.Definition;
import javax.wsdl.extensions.ElementExtensible;
import javax.xml.namespace.QName;
import org.apache.xmlbeans.XmlObject;
import org.apache.xmlbeans.XmlOptions;
import org.w3.x2007.x05.addressing.metadata.AddressingDocument;
import org.w3c.dom.Element;
import org.xmlsoap.schemas.ws.x2004.x09.policy.OptionalType;
import org.xmlsoap.schemas.ws.x2004.x09.policy.Policy;
import org.xmlsoap.schemas.ws.x2004.x09.policy.PolicyDocument;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class PolicyUtils {
    public static final String WS_XMLSOAP_POLICY_NAMESPACE = "http://schemas.xmlsoap.org/ws/2004/09/policy";
    public static final String WS_W3_POLICY_NAMESPACE = "http://www.w3.org/ns/ws-policy";
    public static final String WS_SECURITY_NAMESPACE = "http://docs.oasis-open.org/wss/2004/01/oasis-200401-wss-wssecurity-utility-1.0.xsd";

    public static List<Policy> getPolicies(WsdlContext wsdlContext) {
        ArrayList<Policy> policies = new ArrayList<Policy>();
        try {
            List<InterfaceDefinitionPart> parts = wsdlContext.getDefinitionCache().getDefinitionParts();
            for (int i = 0; i < parts.size(); ++i) {
                InterfaceDefinitionPart part = parts.get(i);
                String content = part.getContent();
                XmlObject xml = XmlUtils.createXmlObject(content);
                XmlObject[] paths = xml.selectPath("declare namespace wsp='http://www.w3.org/ns/ws-policy';//wsp:Policy");
                List<XmlObject> listOfXmlObjcts = Arrays.asList(paths);
                XmlObject[] paths1 = xml.selectPath("declare namespace wsp='http://schemas.xmlsoap.org/ws/2004/09/policy';//wsp:Policy");
                listOfXmlObjcts.addAll(Arrays.asList(paths1));
                for (XmlObject obj : paths = (XmlObject[])listOfXmlObjcts.toArray()) {
                    String xx = obj.xmlText(new XmlOptions().setSaveOuter());
                    PolicyDocument policyDocument = PolicyDocument.Factory.parse((String)xx);
                    Policy polc = policyDocument.getPolicy();
                    policies.add(polc);
                }
            }
        }
        catch (Exception e) {
            e.printStackTrace();
        }
        return null;
    }

    public static boolean isAddressing(Policy policy) {
        return policy.getAddressingList().size() > 0;
    }

    public static List<Policy> getAddressingPolicies(WsdlContext wsdlContext) {
        ArrayList<Policy> addressingPolicies = new ArrayList<Policy>();
        List<Policy> policies = PolicyUtils.getPolicies(wsdlContext);
        for (Policy policy : policies) {
            if (!PolicyUtils.isAddressing(policy)) continue;
            addressingPolicies.add(policy);
        }
        return addressingPolicies;
    }

    public static Policy getAttachedPolicy(ElementExtensible item, Definition def) {
        Policy rtnPolicy;
        block5: {
            String usedPolicyNamespace;
            block4: {
                rtnPolicy = null;
                usedPolicyNamespace = WS_W3_POLICY_NAMESPACE;
                Element[] policyReferences = WsdlUtils.getExentsibilityElements(item, new QName(WS_W3_POLICY_NAMESPACE, "PolicyReference"));
                if (policyReferences.length <= 0) {
                    policyReferences = WsdlUtils.getExentsibilityElements(item, new QName(WS_XMLSOAP_POLICY_NAMESPACE, "PolicyReference"));
                    usedPolicyNamespace = WS_XMLSOAP_POLICY_NAMESPACE;
                }
                if (policyReferences.length <= 0) break block4;
                String policyId = policyReferences[0].getAttribute("URI");
                if (StringUtils.isNullOrEmpty(policyId)) break block5;
                Element[] policies = WsdlUtils.getExentsibilityElements((ElementExtensible)def, new QName(usedPolicyNamespace, "Policy"));
                Element policy = null;
                for (int i = 0; i < policies.length; ++i) {
                    policy = policies[i];
                    String policyIdx = policy.getAttributeNS(WS_SECURITY_NAMESPACE, "Id");
                    if (!policyId.equals("#" + policyIdx)) continue;
                    rtnPolicy = PolicyUtils.getPolicy(policy, usedPolicyNamespace);
                }
                break block5;
            }
            Element[] itemPolicies = WsdlUtils.getExentsibilityElements(item, new QName(usedPolicyNamespace, "Policy"));
            if (itemPolicies.length > 0) {
                for (int i = 0; i < itemPolicies.length; ++i) {
                    Element policy = itemPolicies[i];
                    rtnPolicy = PolicyUtils.getPolicy(policy, usedPolicyNamespace);
                }
            }
        }
        return rtnPolicy;
    }

    public static Policy getPolicy(Element policy, String usedPolicyNamespace) {
        Policy newPolicy = null;
        Element exactlyOne = XmlUtils.getFirstChildElementNS(policy, usedPolicyNamespace, "ExactlyOne");
        if (exactlyOne != null) {
            Element all = XmlUtils.getFirstChildElementNS(exactlyOne, usedPolicyNamespace, "All");
            if (all != null) {
                newPolicy = PolicyUtils.getAddressingPolicy(all, usedPolicyNamespace);
            }
        } else {
            newPolicy = PolicyUtils.getAddressingPolicy(policy, usedPolicyNamespace);
        }
        return newPolicy;
    }

    private static Policy getAddressingPolicy(Element wsamAddressingElm, String usedPolicyNamespace) {
        Element usingAddressing;
        Element wsAddressing = XmlUtils.getFirstChildElementNS(wsamAddressingElm, "http://www.w3.org/2007/05/addressing/metadata", "Addressing");
        Element addressingPolicy = null;
        Policy newPolicy = PolicyDocument.Factory.newInstance().addNewPolicy();
        AddressingDocument.Addressing newAddressing = null;
        if (wsAddressing != null) {
            newAddressing = newPolicy.addNewAddressing();
            String optional = wsAddressing.getAttributeNS(usedPolicyNamespace, "Optional");
            if (!StringUtils.isNullOrEmpty(optional) && optional.equals(OptionalType.TRUE.toString())) {
                newAddressing.setOptional(OptionalType.TRUE);
            } else {
                newAddressing.setOptional(OptionalType.FALSE);
            }
            addressingPolicy = XmlUtils.getFirstChildElementNS(wsAddressing, usedPolicyNamespace, "Policy");
            if (addressingPolicy != null) {
                Element exactlyOne = XmlUtils.getFirstChildElementNS(addressingPolicy, usedPolicyNamespace, "ExactlyOne");
                if (exactlyOne != null) {
                    Element all = XmlUtils.getFirstChildElementNS(exactlyOne, usedPolicyNamespace, "All");
                    if (all != null) {
                        PolicyUtils.getAddressingAnonymous(all, newAddressing);
                    }
                } else {
                    PolicyUtils.getAddressingAnonymous(addressingPolicy, newAddressing);
                }
            }
        }
        if ((usingAddressing = XmlUtils.getFirstChildElementNS(wsamAddressingElm, "http://www.w3.org/2006/05/addressing/wsdl", "UsingAddressing")) != null) {
            newPolicy.addNewUsingAddressing();
        }
        return newPolicy;
    }

    private static void getAddressingAnonymous(Element addressingPolicy, AddressingDocument.Addressing newAddressing) {
        Policy innerPolicy = newAddressing.addNewPolicy();
        Element anonymousElm = XmlUtils.getFirstChildElementNS(addressingPolicy, new QName("http://www.w3.org/2007/05/addressing/metadata", "AnonymousResponses"));
        if (anonymousElm != null) {
            innerPolicy.addNewAnonymousResponses();
        } else {
            Element nonAnonymousElement = XmlUtils.getFirstChildElementNS(addressingPolicy, new QName("http://www.w3.org/2007/05/addressing/metadata", "NonAnonymousResponses"));
            if (nonAnonymousElement != null) {
                innerPolicy.addNewNonAnonymousResponses();
            }
        }
    }
}

