/*
 * Decompiled with CFR 0.152.
 */
package com.eviware.soapui.impl.wsdl.support.wsdl;

import com.eviware.soapui.SoapUI;
import com.eviware.soapui.config.WsaVersionTypeConfig;
import com.eviware.soapui.impl.wsdl.WsdlInterface;
import com.eviware.soapui.impl.wsdl.WsdlProject;
import com.eviware.soapui.impl.wsdl.support.BindingImporter;
import com.eviware.soapui.impl.wsdl.support.policy.PolicyUtils;
import com.eviware.soapui.impl.wsdl.support.soap.Soap11HttpBindingImporter;
import com.eviware.soapui.impl.wsdl.support.soap.Soap12HttpBindingImporter;
import com.eviware.soapui.impl.wsdl.support.soap.SoapJMSBindingImporter;
import com.eviware.soapui.impl.wsdl.support.soap.TibcoSoapJMSBindingImporter;
import com.eviware.soapui.impl.wsdl.support.wsdl.WsdlContext;
import com.eviware.soapui.impl.wsdl.support.wsdl.WsdlLoader;
import com.eviware.soapui.impl.wsdl.support.wsdl.WsdlUtils;
import com.eviware.soapui.settings.WsdlSettings;
import com.eviware.soapui.support.Tools;
import com.eviware.soapui.support.UISupport;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import javax.wsdl.Binding;
import javax.wsdl.Definition;
import javax.wsdl.Port;
import javax.wsdl.PortType;
import javax.wsdl.Service;
import javax.wsdl.extensions.ElementExtensible;
import javax.xml.namespace.QName;
import org.apache.log4j.Logger;

public class WsdlImporter {
    private static List<BindingImporter> bindingImporters = new ArrayList<BindingImporter>();
    private static WsdlImporter instance;
    private static final Logger log;

    public static WsdlInterface[] importWsdl(WsdlProject project, String wsdlUrl) throws Exception {
        return WsdlImporter.importWsdl(project, wsdlUrl, null);
    }

    public static WsdlInterface[] importWsdl(WsdlProject project, String wsdlUrl, QName bindingName) throws Exception {
        return WsdlImporter.importWsdl(project, wsdlUrl, bindingName, null);
    }

    public static WsdlInterface[] importWsdl(WsdlProject project, String wsdlUrl, QName bindingName, WsdlLoader wsdlLoader) throws Exception {
        WsdlContext wsdlContext = new WsdlContext(wsdlUrl = Tools.normalizeFileSeparators(wsdlUrl));
        if (!wsdlContext.load(wsdlLoader)) {
            UISupport.showErrorMessage("Failed to import WSDL");
            return null;
        }
        Definition definition = wsdlContext.getDefinition();
        ArrayList<WsdlInterface> result = new ArrayList<WsdlInterface>();
        if (bindingName != null) {
            WsdlInterface[] wsdlInterfaceArray;
            WsdlInterface iface = WsdlImporter.importBinding(project, wsdlContext, (Binding)definition.getAllBindings().get(bindingName));
            if (iface == null) {
                wsdlInterfaceArray = new WsdlInterface[]{};
            } else {
                WsdlInterface[] wsdlInterfaceArray2 = new WsdlInterface[1];
                wsdlInterfaceArray = wsdlInterfaceArray2;
                wsdlInterfaceArray2[0] = iface;
            }
            return wsdlInterfaceArray;
        }
        HashMap<Binding, WsdlInterface> importedBindings = new HashMap<Binding, WsdlInterface>();
        Map serviceMap = definition.getAllServices();
        if (serviceMap.isEmpty()) {
            log.info((Object)("Missing services in [" + wsdlUrl + "], check for bindings"));
        } else {
            for (Service service : serviceMap.values()) {
                Map portMap = service.getPorts();
                for (Port port : portMap.values()) {
                    Binding binding = port.getBinding();
                    if (importedBindings.containsKey(binding)) {
                        String endpoint = WsdlUtils.getSoapEndpoint(port);
                        if (endpoint == null) continue;
                        ((WsdlInterface)importedBindings.get(binding)).addEndpoint(endpoint);
                        continue;
                    }
                    String ifaceName = WsdlImporter.getInterfaceNameForBinding(binding);
                    WsdlInterface ifc = (WsdlInterface)project.getInterfaceByName(ifaceName);
                    if (ifc != null) {
                        Boolean res = UISupport.confirmOrCancel("Interface [" + ifc.getName() + "] already exists in project, update instead?", "Import WSDL");
                        if (res == null) {
                            return new WsdlInterface[0];
                        }
                        if (!res.booleanValue() || !ifc.updateDefinition(wsdlUrl, false)) continue;
                        importedBindings.put(binding, ifc);
                        result.add(ifc);
                        continue;
                    }
                    WsdlInterface iface = WsdlImporter.importBinding(project, wsdlContext, binding);
                    if (iface == null) continue;
                    String endpoint = WsdlUtils.getSoapEndpoint(port);
                    if (endpoint != null) {
                        iface.addEndpoint(endpoint);
                    }
                    if (iface.getWsaVersion().equals(WsaVersionTypeConfig.NONE.toString())) {
                        iface.setWsaVersion(WsdlUtils.getUsingAddressing((ElementExtensible)port));
                    }
                    if (iface.getWsaVersion().equals(WsaVersionTypeConfig.NONE.toString())) {
                        iface.processPolicy(PolicyUtils.getAttachedPolicy((ElementExtensible)port, wsdlContext.getDefinition()));
                    }
                    result.add(iface);
                    importedBindings.put(binding, iface);
                }
            }
        }
        Map bindingMap = definition.getAllBindings();
        if (!bindingMap.isEmpty()) {
            for (Binding binding : bindingMap.values()) {
                if (importedBindings.containsKey(binding)) continue;
                PortType portType = binding.getPortType();
                if (portType == null) {
                    log.warn((Object)("Missing portType for binding [" + binding.getQName().toString() + "]"));
                    continue;
                }
                String ifaceName = WsdlImporter.getInterfaceNameForBinding(binding);
                WsdlInterface ifc = (WsdlInterface)project.getInterfaceByName(ifaceName);
                if (ifc != null && result.indexOf(ifc) == -1) {
                    Boolean res = UISupport.confirmOrCancel("Interface [" + ifc.getName() + "] already exists in project, update instead?", "Import WSDL");
                    if (res == null) {
                        return new WsdlInterface[0];
                    }
                    if (!res.booleanValue() || !ifc.updateDefinition(wsdlUrl, false)) continue;
                    importedBindings.put(binding, ifc);
                    result.add(ifc);
                    continue;
                }
                WsdlInterface iface = WsdlImporter.importBinding(project, wsdlContext, binding);
                if (iface == null) continue;
                result.add(iface);
                importedBindings.put(binding, ifc);
            }
        }
        if (importedBindings.isEmpty() && serviceMap.isEmpty() && bindingMap.isEmpty()) {
            UISupport.showErrorMessage("Found nothing to import in [" + wsdlUrl + "]");
        }
        if (result.size() > 0) {
            ((WsdlInterface)result.get(result.size() - 1)).setWsdlContext(wsdlContext);
        }
        return result.toArray(new WsdlInterface[result.size()]);
    }

    public static final String getInterfaceNameForBinding(Binding binding) {
        if (SoapUI.getSettings().getBoolean(WsdlSettings.NAME_WITH_BINDING)) {
            return binding.getQName().getLocalPart();
        }
        return binding.getPortType().getQName().getLocalPart();
    }

    private static WsdlInterface importBinding(WsdlProject project, WsdlContext wsdlContext, Binding binding) throws Exception {
        log.info((Object)("Finding importer for " + binding.getQName()));
        for (int c = 0; c < bindingImporters.size(); ++c) {
            BindingImporter importer = bindingImporters.get(c);
            if (!importer.canImport(binding)) continue;
            log.info((Object)("Importing binding " + binding.getQName()));
            WsdlInterface iface = importer.importBinding(project, wsdlContext, binding);
            String url = wsdlContext.getUrl();
            iface.setDefinition(url);
            return iface;
        }
        log.info((Object)("Missing importer for " + binding.getQName()));
        return null;
    }

    static {
        log = Logger.getLogger(WsdlImporter.class);
        try {
            bindingImporters.add(new Soap11HttpBindingImporter());
            bindingImporters.add(new Soap12HttpBindingImporter());
            bindingImporters.add(new SoapJMSBindingImporter());
            bindingImporters.add(new TibcoSoapJMSBindingImporter());
        }
        catch (Exception e) {
            SoapUI.logError(e);
        }
    }
}

