/*
 * Decompiled with CFR 0.152.
 */
package com.eviware.soapui.impl.wsdl.support.wss.saml.callback;

import com.eviware.soapui.impl.wsdl.support.wss.saml.callback.SAMLCallbackHandler;
import java.security.cert.X509Certificate;
import java.util.Collections;
import java.util.List;
import javax.xml.parsers.DocumentBuilder;
import javax.xml.parsers.DocumentBuilderFactory;
import org.apache.ws.security.components.crypto.Crypto;
import org.apache.ws.security.message.WSSecEncryptedKey;
import org.apache.ws.security.saml.ext.SAMLCallback;
import org.apache.ws.security.saml.ext.bean.ActionBean;
import org.apache.ws.security.saml.ext.bean.AttributeBean;
import org.apache.ws.security.saml.ext.bean.AttributeStatementBean;
import org.apache.ws.security.saml.ext.bean.AuthDecisionStatementBean;
import org.apache.ws.security.saml.ext.bean.AuthenticationStatementBean;
import org.apache.ws.security.saml.ext.bean.KeyInfoBean;
import org.apache.ws.security.saml.ext.bean.SubjectBean;
import org.apache.ws.security.saml.ext.bean.SubjectLocalityBean;
import org.w3c.dom.Document;
import org.w3c.dom.Element;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public abstract class AbstractSAMLCallbackHandler
implements SAMLCallbackHandler {
    protected String subjectName = null;
    protected String subjectQualifier = null;
    protected String confirmationMethod = null;
    protected X509Certificate[] certs;
    protected Statement statement = Statement.AUTHN;
    protected KeyInfoBean.CERT_IDENTIFIER certIdentifier = KeyInfoBean.CERT_IDENTIFIER.X509_CERT;
    protected byte[] ephemeralKey = null;
    protected String issuer = null;
    protected String subjectNameIDFormat = null;
    protected String subjectLocalityIpAddress = null;
    protected String subjectLocalityDnsAddress = null;
    protected String resource = null;
    protected List<?> customAttributeValues = null;
    private Crypto crypto;
    private String alias;
    private String customAttributeName;

    public AbstractSAMLCallbackHandler(Crypto crypto, String alias, String assertionTypeFriendlyName, String confirmationMethodFriendlyName) {
        this.crypto = crypto;
        this.alias = alias;
        this.setStatement(assertionTypeFriendlyName);
        this.setConfirmationMethod(confirmationMethodFriendlyName);
    }

    public AbstractSAMLCallbackHandler(String assertionTypeFriendlyName, String confirmationMethodFriendlyName) {
        this.setStatement(assertionTypeFriendlyName);
        this.setConfirmationMethod(confirmationMethodFriendlyName);
    }

    @Override
    public void setCertIdentifier(KeyInfoBean.CERT_IDENTIFIER certIdentifier) {
        this.certIdentifier = certIdentifier;
    }

    @Override
    public void setCerts(X509Certificate[] certs) {
        this.certs = certs;
    }

    @Override
    public byte[] getEphemeralKey() {
        return this.ephemeralKey;
    }

    @Override
    public void setIssuer(String issuer) {
        this.issuer = issuer;
    }

    @Override
    public void setSubjectName(String subjectName) {
        this.subjectName = subjectName;
    }

    @Override
    public void setSubjectQualifier(String subjectQualifier) {
        this.subjectQualifier = subjectQualifier;
    }

    @Override
    public void setSubjectNameIDFormat(String subjectNameIDFormat) {
        this.subjectNameIDFormat = subjectNameIDFormat;
    }

    @Override
    public void setSubjectLocality(String ipAddress, String dnsAddress) {
        this.subjectLocalityIpAddress = ipAddress;
        this.subjectLocalityDnsAddress = dnsAddress;
    }

    @Override
    public void setResource(String resource) {
        this.resource = resource;
    }

    @Override
    public void setCustomAttributeName(String customAttributeName) {
        this.customAttributeName = customAttributeName;
    }

    @Override
    public void setCustomAttributeValues(List<?> customAttributeValues) {
        this.customAttributeValues = customAttributeValues;
    }

    @Override
    public Crypto getCrypto() {
        return this.crypto;
    }

    @Override
    public void setCrypto(Crypto crypto) {
        this.crypto = crypto;
    }

    @Override
    public String getAlias() {
        return this.alias;
    }

    @Override
    public void setAlias(String alias) {
        this.alias = alias;
    }

    @Override
    public void setStatement(String statement) {
        if (statement.equals("Authentication")) {
            this.statement = Statement.AUTHN;
        } else if (statement.equals("Attribute")) {
            this.statement = Statement.ATTR;
        } else if (statement.equals("Authorization")) {
            this.statement = Statement.AUTHZ;
        }
    }

    protected void createAndSetStatement(SubjectBean subjectBean, SAMLCallback callback) {
        if (this.statement == Statement.AUTHN) {
            AuthenticationStatementBean authBean = new AuthenticationStatementBean();
            if (subjectBean != null) {
                authBean.setSubject(subjectBean);
            }
            if (this.subjectLocalityIpAddress != null || this.subjectLocalityDnsAddress != null) {
                SubjectLocalityBean subjectLocality = new SubjectLocalityBean();
                subjectLocality.setIpAddress(this.subjectLocalityIpAddress);
                subjectLocality.setDnsAddress(this.subjectLocalityDnsAddress);
                authBean.setSubjectLocality(subjectLocality);
            }
            authBean.setAuthenticationMethod("Password");
            callback.setAuthenticationStatementData(Collections.singletonList(authBean));
        } else if (this.statement == Statement.ATTR) {
            AttributeStatementBean attrBean = new AttributeStatementBean();
            if (subjectBean != null) {
                attrBean.setSubject(subjectBean);
            }
            AttributeBean attributeBean = new AttributeBean();
            attributeBean.setSimpleName(this.customAttributeName);
            if (this.customAttributeValues != null) {
                attributeBean.setCustomAttributeValues(this.customAttributeValues);
            } else {
                attributeBean.setAttributeValues(Collections.singletonList("user"));
            }
            attrBean.setSamlAttributes(Collections.singletonList(attributeBean));
            callback.setAttributeStatementData(Collections.singletonList(attrBean));
        } else {
            AuthDecisionStatementBean authzBean = new AuthDecisionStatementBean();
            if (subjectBean != null) {
                authzBean.setSubject(subjectBean);
            }
            ActionBean actionBean = new ActionBean();
            actionBean.setContents("Read");
            authzBean.setActions(Collections.singletonList(actionBean));
            authzBean.setResource("endpoint");
            authzBean.setDecision(AuthDecisionStatementBean.Decision.PERMIT);
            authzBean.setResource(this.resource);
            callback.setAuthDecisionStatementData(Collections.singletonList(authzBean));
        }
    }

    protected KeyInfoBean createKeyInfo() throws Exception {
        KeyInfoBean keyInfo = new KeyInfoBean();
        if (this.statement == Statement.AUTHN) {
            keyInfo.setCertificate(this.certs[0]);
            keyInfo.setCertIdentifer(this.certIdentifier);
        } else if (this.statement == Statement.ATTR) {
            DocumentBuilderFactory docBuilderFactory = DocumentBuilderFactory.newInstance();
            docBuilderFactory.setNamespaceAware(true);
            DocumentBuilder docBuilder = docBuilderFactory.newDocumentBuilder();
            Document doc = docBuilder.newDocument();
            WSSecEncryptedKey encrKey = new WSSecEncryptedKey();
            encrKey.setKeyIdentifierType(3);
            encrKey.setUseThisCert(this.certs[0]);
            encrKey.prepare(doc, null);
            this.ephemeralKey = encrKey.getEphemeralKey();
            Element encryptedKeyElement = encrKey.getEncryptedKeyElement();
            Element keyInfoElement = doc.createElementNS("http://www.w3.org/2000/09/xmldsig#", "ds:KeyInfo");
            keyInfoElement.setAttributeNS("http://www.w3.org/2000/xmlns/", "xmlns:ds", "http://www.w3.org/2000/09/xmldsig#");
            keyInfoElement.appendChild(encryptedKeyElement);
            keyInfo.setElement(keyInfoElement);
        }
        return keyInfo;
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    public static enum Statement {
        AUTHN,
        ATTR,
        AUTHZ;

    }
}

