/*
 * Decompiled with CFR 0.152.
 */
package com.eviware.soapui.impl.wsdl.support.wss.support;

import com.eviware.soapui.impl.wsdl.support.wss.entries.WssEntryBase;
import com.eviware.soapui.support.UISupport;
import com.eviware.soapui.support.components.JXToolBar;
import com.eviware.soapui.support.types.StringToStringMap;
import java.awt.BorderLayout;
import java.awt.Color;
import java.awt.Component;
import java.awt.Dimension;
import java.awt.event.ActionEvent;
import java.util.List;
import javax.swing.AbstractAction;
import javax.swing.DefaultCellEditor;
import javax.swing.JButton;
import javax.swing.JComboBox;
import javax.swing.JPanel;
import javax.swing.JScrollPane;
import javax.swing.JTable;
import javax.swing.event.ListSelectionEvent;
import javax.swing.event.ListSelectionListener;
import javax.swing.table.AbstractTableModel;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class WSPartsTable
extends JPanel {
    private final List<StringToStringMap> parts;
    private WssEntryBase entry;
    private PartsTableModel partsTableModel;
    private JTable partsTable;
    private JButton removePartButton;

    public WSPartsTable(List<StringToStringMap> parts, WssEntryBase entry) {
        super(new BorderLayout());
        this.parts = parts;
        this.entry = entry;
        this.partsTableModel = new PartsTableModel();
        this.partsTable = new JTable(this.partsTableModel);
        this.partsTable.getSelectionModel().addListSelectionListener(new ListSelectionListener(){

            public void valueChanged(ListSelectionEvent e) {
                WSPartsTable.this.removePartButton.setEnabled(WSPartsTable.this.partsTable.getSelectedRow() != -1);
            }
        });
        this.partsTable.getColumnModel().getColumn(3).setCellEditor(new DefaultCellEditor(new JComboBox<String>(new String[]{"Content", "Element"})));
        JScrollPane scrollPane = new JScrollPane(this.partsTable);
        scrollPane.setBackground(Color.WHITE);
        scrollPane.setOpaque(true);
        this.add((Component)scrollPane, "Center");
        this.add(this.buildToolbar(), "North");
        this.setPreferredSize(new Dimension(350, 150));
    }

    private Component buildToolbar() {
        JXToolBar toolbar = UISupport.createSmallToolbar();
        toolbar.addFixed(UISupport.createToolbarButton(new AddPartAction()));
        this.removePartButton = UISupport.createToolbarButton(new RemovePartAction());
        toolbar.addFixed(this.removePartButton);
        return toolbar;
    }

    private class RemovePartAction
    extends AbstractAction {
        public RemovePartAction() {
            this.putValue("SmallIcon", UISupport.createImageIcon("/remove_property.gif"));
            this.putValue("ShortDescription", "Removes the selected part");
            this.setEnabled(false);
        }

        public void actionPerformed(ActionEvent e) {
            int row = WSPartsTable.this.partsTable.getSelectedRow();
            if (row == -1) {
                return;
            }
            if (UISupport.confirm("Remove selected Part?", "Remove Part")) {
                WSPartsTable.this.partsTableModel.remove(row);
                WSPartsTable.this.entry.saveConfig();
            }
        }
    }

    private class AddPartAction
    extends AbstractAction {
        public AddPartAction() {
            this.putValue("SmallIcon", UISupport.createImageIcon("/add_property.gif"));
            this.putValue("ShortDescription", "Adds a new part");
        }

        public void actionPerformed(ActionEvent e) {
            WSPartsTable.this.partsTableModel.addParts(new StringToStringMap());
            WSPartsTable.this.entry.saveConfig();
        }
    }

    private class PartsTableModel
    extends AbstractTableModel {
        private PartsTableModel() {
        }

        public int getColumnCount() {
            return 4;
        }

        public int getRowCount() {
            return WSPartsTable.this.parts.size();
        }

        public boolean isCellEditable(int rowIndex, int columnIndex) {
            return true;
        }

        public String getColumnName(int column) {
            switch (column) {
                case 0: {
                    return "ID";
                }
                case 1: {
                    return "Name";
                }
                case 2: {
                    return "Namespace";
                }
                case 3: {
                    return "Encode";
                }
            }
            return null;
        }

        public void setValueAt(Object aValue, int rowIndex, int columnIndex) {
            StringToStringMap part = (StringToStringMap)WSPartsTable.this.parts.get(rowIndex);
            if (aValue == null) {
                aValue = "";
            }
            switch (columnIndex) {
                case 0: {
                    part.put("name", "");
                    this.fireTableCellUpdated(rowIndex, 1);
                    part.put("id", aValue.toString());
                    break;
                }
                case 1: {
                    part.put("id", "");
                    this.fireTableCellUpdated(rowIndex, 0);
                    part.put("name", aValue.toString());
                    break;
                }
                case 2: {
                    part.put("id", "");
                    this.fireTableCellUpdated(rowIndex, 0);
                    part.put("namespace", aValue.toString());
                    break;
                }
                case 3: {
                    part.put("enc", aValue.toString());
                }
            }
            WSPartsTable.this.entry.saveConfig();
        }

        public Object getValueAt(int rowIndex, int columnIndex) {
            StringToStringMap part = (StringToStringMap)WSPartsTable.this.parts.get(rowIndex);
            switch (columnIndex) {
                case 0: {
                    return part.get("id");
                }
                case 1: {
                    return part.get("name");
                }
                case 2: {
                    return part.get("namespace");
                }
                case 3: {
                    return part.get("enc");
                }
            }
            return null;
        }

        public void remove(int row) {
            WSPartsTable.this.parts.remove(row);
            this.fireTableRowsDeleted(row, row);
        }

        public void addParts(StringToStringMap map) {
            WSPartsTable.this.parts.add(map);
            this.fireTableRowsInserted(WSPartsTable.this.parts.size() - 1, WSPartsTable.this.parts.size() - 1);
        }
    }
}

