/*
 * Decompiled with CFR 0.152.
 */
package com.eviware.soapui.impl.wsdl.support.xsd;

import com.eviware.soapui.SoapUI;
import com.eviware.soapui.config.StringListConfig;
import com.eviware.soapui.support.StringUtils;
import com.eviware.soapui.support.types.StringList;
import java.util.ArrayList;
import java.util.Collection;
import java.util.LinkedHashMap;
import java.util.Map;
import javax.xml.namespace.QName;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class SettingUtils {
    public static Collection<? extends QName> string2QNames(String string) {
        ArrayList<QName> result = new ArrayList<QName>();
        if (string != null && string.trim().length() > 0) {
            try {
                StringList names = StringList.fromXml(string);
                for (String name : names) {
                    QName qname = SettingUtils.string2qname(name);
                    result.add(qname);
                }
            }
            catch (Exception e) {
                SoapUI.logError(e);
            }
        }
        return result;
    }

    public static String qnames2String(Collection<? extends QName> qnames) {
        StringList names = new StringList();
        for (QName qName : qnames) {
            String string = SettingUtils.qname2string(qName);
            names.add(string);
        }
        return names.toXml();
    }

    private static QName string2qname(String name) {
        int ix = name.indexOf(64);
        if (ix >= 0) {
            return new QName(name.substring(ix + 1), name.substring(0, ix));
        }
        return new QName(name);
    }

    private static String qname2string(QName qname) {
        String ns = qname.getNamespaceURI();
        String localPart = qname.getLocalPart();
        if (ns != null && ns.length() > 0) {
            return localPart + "@" + ns;
        }
        return localPart;
    }

    public static String qnameValues2String(Map<QName, String[]> valueMap) {
        StringListConfig config = StringListConfig.Factory.newInstance();
        for (QName qname : valueMap.keySet()) {
            String[] values = valueMap.get(qname);
            String nameAndValues = SettingUtils.qname2string(qname) + "=" + StringUtils.join(values, ",");
            config.addEntry(nameAndValues);
        }
        return config.toString();
    }

    public static Map<QName, String[]> string2QNameValues(String string) {
        LinkedHashMap<QName, String[]> result = new LinkedHashMap<QName, String[]>();
        if (string != null && string.trim().length() > 0) {
            try {
                StringList list = StringList.fromXml(string);
                for (String s : list) {
                    String[] words = s.split("=");
                    if (words.length != 2) continue;
                    String name = words[0];
                    String[] values = words[1].split(",");
                    if (name.length() <= 0 || values.length <= 0) continue;
                    QName qname = SettingUtils.string2qname(name);
                    result.put(qname, values);
                }
            }
            catch (Exception e) {
                SoapUI.logError(e);
            }
        }
        return result;
    }
}

