/*
 * Decompiled with CFR 0.152.
 */
package com.eviware.soapui.impl.wsdl.teststeps;

import com.eviware.soapui.impl.support.http.HttpRequestInterface;
import com.eviware.soapui.impl.wsdl.submit.AbstractMessageExchange;
import com.eviware.soapui.impl.wsdl.submit.transports.http.HttpResponse;
import com.eviware.soapui.model.iface.Attachment;
import com.eviware.soapui.model.iface.Operation;
import com.eviware.soapui.support.types.StringToStringsMap;
import java.util.ArrayList;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class HttpResponseMessageExchange
extends AbstractMessageExchange<HttpRequestInterface<?>> {
    private HttpResponse response;
    private String requestContent;

    public HttpResponseMessageExchange(HttpRequestInterface<?> request) {
        super(request);
        this.response = request.getResponse();
        if (this.response != null) {
            for (String key : this.response.getPropertyNames()) {
                this.addProperty(key, this.response.getProperty(key));
            }
        }
    }

    @Override
    public String getEndpoint() {
        return this.response == null ? null : this.response.getURL().toString();
    }

    @Override
    public String getRequestContent() {
        if (this.requestContent != null) {
            return this.requestContent;
        }
        if (this.response == null) {
            this.response = ((HttpRequestInterface)this.getModelItem()).getResponse();
        }
        return this.response == null ? ((HttpRequestInterface)this.getModelItem()).getRequestContent() : this.response.getRequestContent();
    }

    @Override
    public String getResponseContentAsXml() {
        if (this.response == null) {
            this.response = ((HttpRequestInterface)this.getModelItem()).getResponse();
        }
        return this.response.getContentAsXml();
    }

    @Override
    public StringToStringsMap getRequestHeaders() {
        return this.response == null ? ((HttpRequestInterface)this.getModelItem()).getRequestHeaders() : this.response.getRequestHeaders();
    }

    @Override
    public Attachment[] getRequestAttachments() {
        return ((HttpRequestInterface)this.getModelItem()).getAttachments();
    }

    @Override
    public Attachment[] getResponseAttachments() {
        if (this.response == null) {
            this.response = ((HttpRequestInterface)this.getModelItem()).getResponse();
        }
        return this.response == null ? null : this.response.getAttachments();
    }

    @Override
    public String getResponseContent() {
        if (this.response == null) {
            this.response = ((HttpRequestInterface)this.getModelItem()).getResponse();
        }
        return this.response == null ? null : this.response.getContentAsString();
    }

    @Override
    public HttpResponse getResponse() {
        return this.response;
    }

    public void setResponse(HttpResponse response) {
        this.response = response;
    }

    @Override
    public StringToStringsMap getResponseHeaders() {
        if (this.response == null) {
            this.response = ((HttpRequestInterface)this.getModelItem()).getResponse();
        }
        return this.response == null ? new StringToStringsMap() : this.response.getResponseHeaders();
    }

    @Override
    public long getTimeTaken() {
        if (this.response == null) {
            this.response = ((HttpRequestInterface)this.getModelItem()).getResponse();
        }
        return this.response == null ? 0L : this.response.getTimeTaken();
    }

    @Override
    public long getTimestamp() {
        if (this.response == null) {
            this.response = ((HttpRequestInterface)this.getModelItem()).getResponse();
        }
        return this.response == null ? 0L : this.response.getTimestamp();
    }

    @Override
    public boolean isDiscarded() {
        return false;
    }

    @Override
    public Operation getOperation() {
        return null;
    }

    public int getResponseStatusCode() {
        return this.response == null ? 0 : this.response.getStatusCode();
    }

    public String getResponseContentType() {
        return this.response == null ? null : this.response.getContentType();
    }

    @Override
    public boolean hasRawData() {
        return this.response != null;
    }

    @Override
    public byte[] getRawRequestData() {
        return this.response == null ? null : this.response.getRawRequestData();
    }

    @Override
    public byte[] getRawResponseData() {
        return this.response == null ? null : this.response.getRawResponseData();
    }

    @Override
    public Attachment[] getResponseAttachmentsForPart(String name) {
        ArrayList<Attachment> result = new ArrayList<Attachment>();
        if (this.getResponseAttachments() != null) {
            for (Attachment attachment : this.getResponseAttachments()) {
                if (!attachment.getPart().equals(name)) continue;
                result.add(attachment);
            }
        }
        return result.toArray(new Attachment[result.size()]);
    }

    @Override
    public Attachment[] getRequestAttachmentsForPart(String name) {
        ArrayList<Attachment> result = new ArrayList<Attachment>();
        for (Attachment attachment : this.getRequestAttachments()) {
            if (!attachment.getPart().equals(name)) continue;
            result.add(attachment);
        }
        return result.toArray(new Attachment[result.size()]);
    }

    @Override
    public boolean hasRequest(boolean ignoreEmpty) {
        String requestContent = this.getRequestContent();
        return requestContent != null && (!ignoreEmpty || requestContent.trim().length() != 0);
    }

    @Override
    public boolean hasResponse() {
        String responseContent = this.getResponseContent();
        return responseContent != null && responseContent.trim().length() > 0;
    }
}

