/*
 * Decompiled with CFR 0.152.
 */
package com.eviware.soapui.impl.wsdl.teststeps;

import com.eviware.soapui.impl.rest.RestRequestInterface;
import com.eviware.soapui.impl.rest.RestResource;
import com.eviware.soapui.impl.wsdl.submit.AbstractRestMessageExchange;
import com.eviware.soapui.impl.wsdl.submit.transports.http.HttpResponse;
import com.eviware.soapui.model.iface.Attachment;
import com.eviware.soapui.model.iface.Operation;
import com.eviware.soapui.support.types.StringToStringsMap;
import com.eviware.soapui.support.xml.XmlUtils;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class RestResponseMessageExchange
extends AbstractRestMessageExchange<RestRequestInterface> {
    private HttpResponse response;
    private String requestContent;

    public RestResponseMessageExchange(RestRequestInterface request) {
        super(request);
        this.response = request.getResponse();
        if (this.response != null) {
            for (String key : this.response.getPropertyNames()) {
                this.addProperty(key, this.response.getProperty(key));
            }
        }
    }

    @Override
    public String getEndpoint() {
        return this.response == null ? null : this.response.getURL().toString();
    }

    @Override
    public boolean hasRawData() {
        return this.response != null;
    }

    @Override
    public byte[] getRawRequestData() {
        return this.response == null ? null : this.response.getRawRequestData();
    }

    @Override
    public byte[] getRawResponseData() {
        return this.response == null ? null : this.response.getRawResponseData();
    }

    @Override
    public String getRequestContent() {
        if (this.requestContent != null) {
            return this.requestContent;
        }
        if (this.response == null) {
            this.response = ((RestRequestInterface)this.getModelItem()).getResponse();
        }
        return this.response == null ? ((RestRequestInterface)this.getModelItem()).getRequestContent() : this.response.getRequestContent();
    }

    @Override
    public StringToStringsMap getRequestHeaders() {
        return this.response == null ? ((RestRequestInterface)this.getModelItem()).getRequestHeaders() : this.response.getRequestHeaders();
    }

    @Override
    public Attachment[] getRequestAttachments() {
        return ((RestRequestInterface)this.getModelItem()).getAttachments();
    }

    @Override
    public Attachment[] getResponseAttachments() {
        if (this.response == null) {
            this.response = ((RestRequestInterface)this.getModelItem()).getResponse();
        }
        return this.response == null ? null : this.response.getAttachments();
    }

    @Override
    public String getResponseContent() {
        if (this.response == null) {
            this.response = ((RestRequestInterface)this.getModelItem()).getResponse();
        }
        return this.response == null ? null : this.response.getContentAsString();
    }

    @Override
    public HttpResponse getResponse() {
        return this.response;
    }

    @Override
    public String getRequestContentAsXml() {
        String result = this.getRequestContent();
        return XmlUtils.seemsToBeXml(result) ? result : "<not-xml/>";
    }

    public void setResponse(HttpResponse response) {
        this.response = response;
    }

    @Override
    public String getResponseContentAsXml() {
        if (this.response == null) {
            this.response = ((RestRequestInterface)this.getModelItem()).getResponse();
        }
        return this.response == null ? null : this.response.getContentAsXml();
    }

    @Override
    public StringToStringsMap getResponseHeaders() {
        if (this.response == null) {
            this.response = ((RestRequestInterface)this.getModelItem()).getResponse();
        }
        return this.response == null ? new StringToStringsMap() : this.response.getResponseHeaders();
    }

    @Override
    public long getTimeTaken() {
        if (this.response == null) {
            this.response = ((RestRequestInterface)this.getModelItem()).getResponse();
        }
        return this.response == null ? 0L : this.response.getTimeTaken();
    }

    @Override
    public long getTimestamp() {
        if (this.response == null) {
            this.response = ((RestRequestInterface)this.getModelItem()).getResponse();
        }
        return this.response == null ? 0L : this.response.getTimestamp();
    }

    public void setRequestContent(String requestContent) {
        this.requestContent = requestContent;
    }

    @Override
    public boolean isDiscarded() {
        return false;
    }

    @Override
    public RestResource getResource() {
        return ((RestRequestInterface)this.getModelItem()).getResource();
    }

    @Override
    public RestRequestInterface getRestRequest() {
        return (RestRequestInterface)this.getModelItem();
    }

    @Override
    public Operation getOperation() {
        return this.getResource();
    }

    @Override
    public int getResponseStatusCode() {
        return this.response == null ? 0 : this.response.getStatusCode();
    }

    @Override
    public String getResponseContentType() {
        return this.response == null ? null : this.response.getContentType();
    }
}

