/*
 * Decompiled with CFR 0.152.
 */
package com.eviware.soapui.model.tree.nodes;

import com.eviware.soapui.model.iface.Interface;
import com.eviware.soapui.model.mock.MockService;
import com.eviware.soapui.model.project.Project;
import com.eviware.soapui.model.support.ProjectListenerAdapter;
import com.eviware.soapui.model.testsuite.TestSuite;
import com.eviware.soapui.model.tree.AbstractModelItemTreeNode;
import com.eviware.soapui.model.tree.SoapUITreeNode;
import com.eviware.soapui.model.tree.nodes.InterfaceTreeNode;
import com.eviware.soapui.model.tree.nodes.MockServiceTreeNode;
import com.eviware.soapui.model.tree.nodes.PropertiesTreeNode;
import com.eviware.soapui.model.tree.nodes.TestSuiteTreeNode;
import com.eviware.soapui.model.tree.nodes.WorkspaceTreeNode;
import com.eviware.soapui.settings.UISettings;
import java.util.ArrayList;
import java.util.List;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class ProjectTreeNode
extends AbstractModelItemTreeNode<Project> {
    private InternalProjectListener internalProjectListener;
    private List<InterfaceTreeNode> interfaceNodes = new ArrayList<InterfaceTreeNode>();
    private List<TestSuiteTreeNode> testSuiteNodes = new ArrayList<TestSuiteTreeNode>();
    private List<MockServiceTreeNode> mockServiceNodes = new ArrayList<MockServiceTreeNode>();
    private PropertiesTreeNode<?> propertiesTreeNode;

    public ProjectTreeNode(Project project, WorkspaceTreeNode workspaceNode) {
        super(project, workspaceNode.getWorkspace(), workspaceNode.getTreeModel());
        int c;
        if (!project.isOpen()) {
            return;
        }
        this.internalProjectListener = new InternalProjectListener();
        project.addProjectListener(this.internalProjectListener);
        for (c = 0; c < project.getInterfaceCount(); ++c) {
            Interface iface = project.getInterfaceAt(c);
            this.interfaceNodes.add(new InterfaceTreeNode(iface, this.getTreeModel()));
        }
        for (c = 0; c < project.getTestSuiteCount(); ++c) {
            this.testSuiteNodes.add(new TestSuiteTreeNode(project.getTestSuiteAt(c), this.getTreeModel()));
        }
        for (c = 0; c < project.getMockServiceCount(); ++c) {
            this.mockServiceNodes.add(new MockServiceTreeNode(project.getMockServiceAt(c), this.getTreeModel()));
        }
        this.initOrdering(this.interfaceNodes, UISettings.ORDER_SERVICES);
        this.getTreeModel().mapModelItems(this.interfaceNodes);
        this.getTreeModel().mapModelItems(this.testSuiteNodes);
        this.getTreeModel().mapModelItems(this.mockServiceNodes);
        this.propertiesTreeNode = PropertiesTreeNode.createDefaultPropertiesNode(project, this.getTreeModel());
        this.getTreeModel().mapModelItem(this.propertiesTreeNode);
    }

    @Override
    public void release() {
        super.release();
        this.getProject().removeProjectListener(this.internalProjectListener);
        for (InterfaceTreeNode interfaceTreeNode : this.interfaceNodes) {
            interfaceTreeNode.release();
        }
        for (TestSuiteTreeNode testSuiteTreeNode : this.testSuiteNodes) {
            testSuiteTreeNode.release();
        }
        for (MockServiceTreeNode mockServiceTreeNode : this.mockServiceNodes) {
            mockServiceTreeNode.release();
        }
        if (this.propertiesTreeNode != null) {
            this.propertiesTreeNode.release();
        }
    }

    @Override
    public int getChildCount() {
        if (this.propertiesTreeNode == null) {
            return 0;
        }
        int propMod = this.getTreeModel().isShowProperties() ? 1 : 0;
        return this.interfaceNodes.size() + this.testSuiteNodes.size() + this.mockServiceNodes.size() + propMod;
    }

    @Override
    public int getIndexOfChild(Object child) {
        if (this.propertiesTreeNode == null) {
            return -1;
        }
        if (child == this.propertiesTreeNode) {
            return 0;
        }
        int propMod = this.getTreeModel().isShowProperties() ? 1 : 0;
        int index = this.interfaceNodes.indexOf(child);
        if (index >= 0) {
            return index + propMod;
        }
        index = this.testSuiteNodes.indexOf(child);
        if (index >= 0) {
            return index + this.interfaceNodes.size() + propMod;
        }
        index = this.mockServiceNodes.indexOf(child);
        if (index >= 0) {
            return index + this.interfaceNodes.size() + this.testSuiteNodes.size() + propMod;
        }
        return -1;
    }

    @Override
    public SoapUITreeNode getChildNode(int index) {
        int propMod;
        if (this.propertiesTreeNode == null) {
            return null;
        }
        int n = propMod = this.getTreeModel().isShowProperties() ? 1 : 0;
        if (propMod == 1 && index == 0) {
            return this.propertiesTreeNode;
        }
        if (index < this.interfaceNodes.size() + propMod) {
            return this.interfaceNodes.get(index - propMod);
        }
        if (index < this.testSuiteNodes.size() + this.interfaceNodes.size() + propMod) {
            return this.testSuiteNodes.get(index - this.interfaceNodes.size() - propMod);
        }
        return this.mockServiceNodes.get(index - this.interfaceNodes.size() - this.testSuiteNodes.size() - propMod);
    }

    public Project getProject() {
        return (Project)this.getModelItem();
    }

    private class InternalProjectListener
    extends ProjectListenerAdapter {
        private InternalProjectListener() {
        }

        public void interfaceAdded(Interface iface) {
            InterfaceTreeNode interfaceTreeNode = new InterfaceTreeNode(iface, ProjectTreeNode.this.getTreeModel());
            ProjectTreeNode.this.interfaceNodes.add(interfaceTreeNode);
            ProjectTreeNode.this.reorder(false);
            ProjectTreeNode.this.getTreeModel().notifyNodeInserted(interfaceTreeNode);
        }

        public void interfaceRemoved(Interface iface) {
            SoapUITreeNode treeNode = ProjectTreeNode.this.getTreeModel().getTreeNode(iface);
            if (!ProjectTreeNode.this.interfaceNodes.contains(treeNode)) {
                throw new RuntimeException("Removing unkown interface");
            }
            ProjectTreeNode.this.getTreeModel().notifyNodeRemoved(treeNode);
            ProjectTreeNode.this.interfaceNodes.remove(treeNode);
        }

        public void testSuiteAdded(TestSuite testSuite) {
            TestSuiteTreeNode testSuiteNode = new TestSuiteTreeNode(testSuite, ProjectTreeNode.this.getTreeModel());
            ProjectTreeNode.this.testSuiteNodes.add(testSuite.getProject().getIndexOfTestSuite(testSuite), testSuiteNode);
            ProjectTreeNode.this.getTreeModel().notifyNodeInserted(testSuiteNode);
        }

        public void testSuiteRemoved(TestSuite testSuite) {
            SoapUITreeNode treeNode = ProjectTreeNode.this.getTreeModel().getTreeNode(testSuite);
            if (!ProjectTreeNode.this.testSuiteNodes.contains(treeNode)) {
                throw new RuntimeException("Removing unkown testSuite");
            }
            ProjectTreeNode.this.getTreeModel().notifyNodeRemoved(treeNode);
            ProjectTreeNode.this.testSuiteNodes.remove(treeNode);
        }

        public void testSuiteMoved(TestSuite testSuite, int index, int offset) {
            this.testSuiteRemoved(testSuite);
            this.testSuiteAdded(testSuite);
        }

        public void mockServiceAdded(MockService mockService) {
            MockServiceTreeNode mockServiceNode = new MockServiceTreeNode(mockService, ProjectTreeNode.this.getTreeModel());
            ProjectTreeNode.this.mockServiceNodes.add(mockServiceNode);
            ProjectTreeNode.this.getTreeModel().notifyNodeInserted(mockServiceNode);
        }

        public void mockServiceRemoved(MockService mockService) {
            SoapUITreeNode treeNode = ProjectTreeNode.this.getTreeModel().getTreeNode(mockService);
            if (!ProjectTreeNode.this.mockServiceNodes.contains(treeNode)) {
                throw new RuntimeException("Removing unkown mockService");
            }
            ProjectTreeNode.this.getTreeModel().notifyNodeRemoved(treeNode);
            ProjectTreeNode.this.mockServiceNodes.remove(treeNode);
        }
    }
}

