/*
 * Decompiled with CFR 0.152.
 */
package com.eviware.soapui.security.boundary;

import com.eviware.soapui.security.boundary.Boundary;
import com.eviware.soapui.security.boundary.DateBoundary;
import com.eviware.soapui.security.boundary.DateTimeBoundary;
import com.eviware.soapui.security.boundary.DecimalBoundary;
import com.eviware.soapui.security.boundary.IntegerBoundary;
import com.eviware.soapui.security.boundary.NormalisedStringBoundary;
import com.eviware.soapui.security.boundary.StringBoundary;

public abstract class AbstractBoundary
implements Boundary {
    public static final String XSD_LENGTH = "xsd:length";
    public static final String XSD_MAX_LENGTH = "xsd:maxLength";
    public static final String XSD_MIN_LENGTH = "xsd:minLength";
    public static final String XSD_MIN_INCLUSIVE = "xsd:minInclusive";
    public static final String XSD_MAX_INCLUSIVE = "xsd:maxInclusive";
    public static final String XSD_MIN_EXCLUSIVE = "xsd:minExclusive";
    public static final String XSD_MAX_EXCLUSIVE = "xsd:maxExclusive";
    public static final String XSD_TOTAL_DIGITS = "xsd:totalDigits";
    public static final String XSD_FRACTION_DIGITS = "xsd:fractionDigits";

    public static Boundary factory(String type) {
        if (type == null) {
            return null;
        }
        if (type.endsWith(":string")) {
            return new StringBoundary();
        }
        if (type.endsWith(":normalizedString")) {
            return new NormalisedStringBoundary();
        }
        if (type.endsWith(":integer")) {
            return new IntegerBoundary();
        }
        if (type.endsWith(":decimal")) {
            return new DecimalBoundary();
        }
        if (type.endsWith(":dateTime")) {
            return new DateTimeBoundary();
        }
        if (type.endsWith(":date")) {
            return new DateBoundary();
        }
        if (type.endsWith(":time")) {
            return new DateBoundary();
        }
        return null;
    }

    public static String outOfBoundaryValue(String baseType, String nodeName, String nodeValue) {
        Boundary boundary = AbstractBoundary.factory(baseType);
        if (XSD_MIN_LENGTH.equals(nodeName)) {
            return boundary.outOfBoundary(2, nodeValue);
        }
        if (XSD_MAX_LENGTH.equals(nodeName)) {
            return boundary.outOfBoundary(3, nodeValue);
        }
        if (XSD_LENGTH.equals(nodeName)) {
            return boundary.outOfBoundary(1, nodeValue);
        }
        if (XSD_MAX_EXCLUSIVE.equals(nodeName)) {
            return boundary.outOfBoundary(6, nodeValue);
        }
        if (XSD_MAX_INCLUSIVE.equals(nodeName)) {
            return boundary.outOfBoundary(8, nodeValue);
        }
        if (XSD_MIN_EXCLUSIVE.equals(nodeName)) {
            return boundary.outOfBoundary(7, nodeValue);
        }
        if (XSD_MIN_INCLUSIVE.equals(nodeName)) {
            return boundary.outOfBoundary(9, nodeValue);
        }
        if (XSD_TOTAL_DIGITS.equals(nodeName)) {
            return boundary.outOfBoundary(4, nodeValue);
        }
        if (XSD_FRACTION_DIGITS.equals(nodeName)) {
            return boundary.outOfBoundary(5, nodeValue);
        }
        return null;
    }
}

