/*
 * Decompiled with CFR 0.152.
 */
package com.eviware.soapui.security.panels;

import com.eviware.soapui.model.security.SecurityScan;
import com.eviware.soapui.model.testsuite.TestStep;
import com.eviware.soapui.security.SecurityTest;
import com.eviware.soapui.security.panels.SecurityScanNode;
import com.eviware.soapui.security.panels.SecurityTreeRootNode;
import com.eviware.soapui.security.panels.TestStepNode;
import javax.swing.JTree;
import javax.swing.tree.DefaultTreeModel;
import javax.swing.tree.MutableTreeNode;
import javax.swing.tree.TreePath;

public class SecurityScanTree
extends DefaultTreeModel {
    private SecurityTest securityTest;
    private SecurityTreeRootNode treeNode;

    public SecurityScanTree(SecurityTest securityTest, SecurityTreeRootNode treeNode) {
        super(treeNode);
        this.securityTest = securityTest;
        this.treeNode = treeNode;
    }

    public void insertNodeInto(TestStep testStep) {
        TestStepNode testStepNode = new TestStepNode((SecurityTreeRootNode)this.root, testStep, this.securityTest.getSecurityScansMap().get(testStep.getId()));
        this.insertNodeInto(testStepNode, (MutableTreeNode)this.root, this.root.getChildCount());
        this.nodeStructureChanged(this.root);
    }

    public void removeTestStep(TestStep testStep) {
        TestStepNode node = this.getTestStepNode(testStep);
        this.removeNodeFromParent(node);
    }

    protected TestStepNode getTestStepNode(TestStep testStep) {
        for (int cnt = 0; cnt < this.root.getChildCount(); ++cnt) {
            TestStepNode node = (TestStepNode)this.root.getChildAt(cnt);
            if (!node.getTestStep().getId().equals(testStep.getId())) continue;
            return node;
        }
        return null;
    }

    protected SecurityScanNode getSecurityScanNode(SecurityScan securityCheck) {
        TestStepNode testStepNode = this.getTestStepNode(securityCheck.getTestStep());
        for (int cnt = 0; cnt < testStepNode.getChildCount(); ++cnt) {
            SecurityScanNode node = (SecurityScanNode)testStepNode.getChildAt(cnt);
            if (!node.getSecurityScan().getType().equals(securityCheck.getType())) continue;
            return node;
        }
        return null;
    }

    public void addSecurityScanNode(JTree tree, SecurityScan securityCheck) {
        TestStepNode node = this.getTestStepNode(securityCheck.getTestStep());
        if (node != null) {
            SecurityScanNode newNode = new SecurityScanNode(securityCheck);
            this.insertNodeInto(newNode, node, node.getChildCount());
            this.nodeStructureChanged(node);
            for (int row = 0; row < tree.getRowCount(); ++row) {
                tree.expandRow(row);
            }
            tree.setSelectionInterval(this.getIndexOfChild(node, newNode) + 1, this.getIndexOfChild(node, newNode) + 1);
        }
    }

    public void removeSecurityScanNode(SecurityScan securityCheck) {
        TestStepNode testStepNode = this.getTestStepNode(securityCheck.getTestStep());
        SecurityScanNode node = this.getSecurityScanNode(securityCheck);
        this.removeNodeFromParent(node);
        this.nodeStructureChanged(testStepNode);
    }

    public TreePath moveTestStepNode(TestStep testStep, int index, int offset) {
        TestStepNode node = this.getTestStepNode(testStep);
        int index2 = this.getIndexOfChild(this.root, node);
        this.removeNodeFromParent(node);
        this.insertNodeInto(node, (MutableTreeNode)this.root, index2 + offset);
        return new TreePath(node.getPath());
    }

    public void release() {
        if (this.securityTest != null) {
            this.securityTest.removePropertyChangeListener(this.treeNode);
        }
    }
}

