/*
 * Decompiled with CFR 0.152.
 */
package com.eviware.soapui.security.panels;

import com.eviware.soapui.SoapUI;
import com.eviware.soapui.impl.support.actions.ShowOnlineHelpAction;
import com.eviware.soapui.impl.wsdl.panels.support.MockSecurityTestRunner;
import com.eviware.soapui.impl.wsdl.panels.testcase.actions.SetCredentialsAction;
import com.eviware.soapui.impl.wsdl.panels.testcase.actions.SetEndpointAction;
import com.eviware.soapui.impl.wsdl.panels.teststeps.support.AbstractGroovyEditorModel;
import com.eviware.soapui.impl.wsdl.panels.teststeps.support.PropertyHolderTable;
import com.eviware.soapui.impl.wsdl.testcase.WsdlTestCase;
import com.eviware.soapui.model.ModelItem;
import com.eviware.soapui.model.TestPropertyHolder;
import com.eviware.soapui.model.security.SecurityScan;
import com.eviware.soapui.model.testsuite.TestCaseRunner;
import com.eviware.soapui.model.testsuite.TestRunner;
import com.eviware.soapui.model.testsuite.TestStepResult;
import com.eviware.soapui.security.SecurityTest;
import com.eviware.soapui.security.SecurityTestRunContext;
import com.eviware.soapui.security.SecurityTestRunner;
import com.eviware.soapui.security.SecurityTestRunnerImpl;
import com.eviware.soapui.security.log.JFunctionalTestRunLog;
import com.eviware.soapui.security.log.JSecurityTestRunLog;
import com.eviware.soapui.security.panels.JSecurityTestTestStepList;
import com.eviware.soapui.security.result.SecurityResult;
import com.eviware.soapui.security.result.SecurityScanRequestResult;
import com.eviware.soapui.security.result.SecurityScanResult;
import com.eviware.soapui.security.result.SecurityTestStepResult;
import com.eviware.soapui.security.support.ProgressBarSecurityTestAdapter;
import com.eviware.soapui.security.support.SecurityTestRunListenerAdapter;
import com.eviware.soapui.settings.UISettings;
import com.eviware.soapui.support.DateUtil;
import com.eviware.soapui.support.DocumentListenerAdapter;
import com.eviware.soapui.support.StringUtils;
import com.eviware.soapui.support.UISupport;
import com.eviware.soapui.support.action.swing.SwingActionDelegate;
import com.eviware.soapui.support.components.GroovyEditorComponent;
import com.eviware.soapui.support.components.GroovyEditorInspector;
import com.eviware.soapui.support.components.JComponentInspector;
import com.eviware.soapui.support.components.JFocusableComponentInspector;
import com.eviware.soapui.support.components.JInspectorPanel;
import com.eviware.soapui.support.components.JInspectorPanelFactory;
import com.eviware.soapui.support.components.JUndoableTextArea;
import com.eviware.soapui.support.components.JXToolBar;
import com.eviware.soapui.support.dnd.JListDragAndDropable;
import com.eviware.soapui.support.swing.ComponentBag;
import com.eviware.soapui.support.types.StringToObjectMap;
import com.eviware.soapui.ui.support.KeySensitiveModelItemDesktopPanel;
import java.awt.BorderLayout;
import java.awt.Color;
import java.awt.Component;
import java.awt.Dimension;
import java.awt.event.ActionEvent;
import java.util.Date;
import java.util.List;
import javax.swing.AbstractAction;
import javax.swing.Action;
import javax.swing.BorderFactory;
import javax.swing.Box;
import javax.swing.JButton;
import javax.swing.JComponent;
import javax.swing.JLabel;
import javax.swing.JList;
import javax.swing.JPanel;
import javax.swing.JProgressBar;
import javax.swing.JScrollPane;
import javax.swing.JTabbedPane;
import javax.swing.JTextArea;
import javax.swing.JToolBar;
import javax.swing.ListModel;
import javax.swing.text.Document;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class SecurityTestDesktopPanel
extends KeySensitiveModelItemDesktopPanel<SecurityTest> {
    private JSecurityTestTestStepList testStepList;
    private JProgressBar progressBar;
    private JButton runButton;
    private JButton cancelButton;
    private SecurityTestRunner runner;
    private JButton setEndpointButton;
    private JButton setCredentialsButton;
    private JButton optionsButton;
    private JSecurityTestRunLog securityTestLog;
    private JFunctionalTestRunLog functionalTestLog;
    private ProgressBarSecurityTestAdapter progressBarAdapter;
    private ComponentBag stateDependantComponents = new ComponentBag();
    private boolean canceled;
    private JTextArea descriptionArea;
    private PropertyHolderTable propertiesTable;
    private GroovyEditorComponent tearDownGroovyEditor;
    private GroovyEditorComponent setupGroovyEditor;
    private JInspectorPanel testStepListInspectorPanel;
    private JInspectorPanel inspectorPanel;
    private SecurityTestRunner lastRunner;
    private SecurityTest securityTest;
    private JXToolBar toolbar;
    private InternalSecurityTestRunListener securityTestRunListener = new InternalSecurityTestRunListener();
    private JLabel cntLabel;
    private JComponentInspector<?> securityLogInspector;
    private JComponentInspector<?> functionalLogInspector;
    private SecurityResult.ResultStatus securityStatus;
    private SecurityResult.ResultStatus functionalStatus;
    private boolean startStepLogEntryAdded;

    public SecurityTestDesktopPanel(SecurityTest securityTest) {
        super(securityTest);
        this.buildUI();
        this.setPreferredSize(new Dimension(400, 550));
        this.securityTest = securityTest;
        securityTest.addSecurityTestRunListener(this.securityTestRunListener);
        this.progressBarAdapter = new ProgressBarSecurityTestAdapter(this.progressBar, securityTest, this.cntLabel);
    }

    protected JSecurityTestTestStepList getTestStepList() {
        return this.testStepList;
    }

    protected JSecurityTestRunLog getSecurityTestLog() {
        return this.securityTestLog;
    }

    protected void setTestStepList(JSecurityTestTestStepList testStepList) {
        this.testStepList = testStepList;
    }

    private void buildUI() {
        JPanel panel = new JPanel(new BorderLayout());
        panel.add(this.buildToolbar(), "First");
        panel.add(this.buildRunnerBar(), "Center");
        this.add((Component)panel, "North");
        JComponent securityLog = this.buildSecurityLog();
        this.inspectorPanel = JInspectorPanelFactory.build(this.buildContent());
        this.securityLogInspector = new JComponentInspector<JComponent>(securityLog, "Security Log", "Security Execution Log", true);
        this.inspectorPanel.addInspector(this.securityLogInspector);
        JComponent functionalLog = this.buildFunctionalLog();
        this.functionalLogInspector = new JComponentInspector<JComponent>(functionalLog, "TestCase Log", "Functional Execution Log", true);
        this.inspectorPanel.addInspector(this.functionalLogInspector);
        this.inspectorPanel.setDefaultDividerLocation(0.7f);
        this.inspectorPanel.setCurrentInspector("Security Log");
        if (StringUtils.hasContent(((SecurityTest)this.getModelItem()).getDescription()) && ((SecurityTest)this.getModelItem()).getSettings().getBoolean(UISettings.SHOW_DESCRIPTIONS)) {
            this.testStepListInspectorPanel.setCurrentInspector("Description");
        }
        this.initializeStatusIcons();
        this.add((Component)this.inspectorPanel.getComponent(), "Center");
    }

    private void initializeStatusIcons() {
        this.securityStatus = SecurityResult.ResultStatus.UNKNOWN;
        this.updateStatusIcon(this.securityStatus, this.securityLogInspector);
        this.functionalStatus = SecurityResult.ResultStatus.UNKNOWN;
        this.updateStatusIcon(this.functionalStatus, this.functionalLogInspector);
    }

    private void updateStatusIcon(SecurityResult.ResultStatus status, JComponentInspector<?> logInspector) {
        switch (status) {
            case FAILED: {
                logInspector.setIcon(UISupport.createImageIcon("/failed_securitytest.gif"));
                break;
            }
            case UNKNOWN: {
                logInspector.setIcon(UISupport.createImageIcon("/unknown_securitytest.gif"));
                break;
            }
            case OK: {
                logInspector.setIcon(UISupport.createImageIcon("/valid_securitytest.gif"));
            }
        }
    }

    private Component buildRunnerBar() {
        this.progressBar = new JProgressBar(0, ((SecurityTest)this.getModelItem()).getSecurityScanCount());
        JPanel progressPanel = new JPanel(new BorderLayout(10, 0));
        this.progressBar.setValue(0);
        this.progressBar.setStringPainted(true);
        this.progressBar.setString("");
        this.progressBar.setIndeterminate(false);
        this.progressBar.setBorder(BorderFactory.createMatteBorder(0, 0, 1, 1, Color.LIGHT_GRAY));
        progressPanel.setBorder(BorderFactory.createEmptyBorder(5, 5, 5, 5));
        progressPanel.add(this.progressBar);
        this.progressBar.setMinimumSize(new Dimension(0, 200));
        this.progressBar.setBackground(Color.WHITE);
        this.cntLabel = new JLabel("");
        this.cntLabel.setForeground(Color.white);
        this.cntLabel.setPreferredSize(new Dimension(50, 18));
        this.cntLabel.setHorizontalTextPosition(0);
        this.cntLabel.setHorizontalAlignment(0);
        this.cntLabel.setBorder(BorderFactory.createLineBorder(Color.LIGHT_GRAY));
        progressPanel.add((Component)this.cntLabel, "East");
        return progressPanel;
    }

    private JComponent buildSecurityLog() {
        this.securityTestLog = new JSecurityTestRunLog((SecurityTest)this.getModelItem());
        this.stateDependantComponents.add(this.securityTestLog);
        return this.securityTestLog;
    }

    private JComponent buildFunctionalLog() {
        this.functionalTestLog = new JFunctionalTestRunLog((SecurityTest)this.getModelItem());
        this.stateDependantComponents.add(this.functionalTestLog);
        return this.functionalTestLog;
    }

    private JComponent buildContent() {
        JTabbedPane tabs = new JTabbedPane(1);
        this.testStepListInspectorPanel = JInspectorPanelFactory.build(this.buildTestStepList(), 3);
        tabs.addTab("TestSteps", this.testStepListInspectorPanel.getComponent());
        this.addTabs(tabs, this.testStepListInspectorPanel);
        tabs.setTabLayoutPolicy(1);
        return UISupport.createTabPanel(tabs, true);
    }

    protected JComponent buildTestStepList() {
        this.testStepList = new JSecurityTestTestStepList((SecurityTest)this.getModelItem(), this.securityTestLog);
        return this.testStepList;
    }

    protected void addTabs(JTabbedPane tabs, JInspectorPanel inspectorPanel) {
        inspectorPanel.addInspector(new JFocusableComponentInspector<JPanel>(this.buildDescriptionPanel(), this.descriptionArea, "Description", "SecurityTest Description", true));
        inspectorPanel.addInspector(new JComponentInspector<JComponent>(this.buildPropertiesPanel(), "Properties", "SecurityTest level properties", true));
        inspectorPanel.addInspector(new GroovyEditorInspector(this.buildSetupScriptPanel(), "Setup Script", "Script to run before tunning a SecurityTest"));
        inspectorPanel.addInspector(new GroovyEditorInspector(this.buildTearDownScriptPanel(), "TearDown Script", "Script to run after a SecurityTest Run"));
    }

    protected GroovyEditorComponent buildTearDownScriptPanel() {
        this.tearDownGroovyEditor = new GroovyEditorComponent(new TearDownScriptGroovyEditorModel(), null);
        return this.tearDownGroovyEditor;
    }

    protected GroovyEditorComponent buildSetupScriptPanel() {
        this.setupGroovyEditor = new GroovyEditorComponent(new SetupScriptGroovyEditorModel(), null);
        return this.setupGroovyEditor;
    }

    protected JComponent buildPropertiesPanel() {
        JPanel panel = new JPanel(new BorderLayout());
        this.propertiesTable = this.buildPropertiesTable();
        panel.add((Component)this.propertiesTable, "Center");
        return panel;
    }

    protected PropertyHolderTable buildPropertiesTable() {
        return new PropertyHolderTable((TestPropertyHolder)this.getModelItem());
    }

    private JPanel buildDescriptionPanel() {
        JPanel panel = new JPanel(new BorderLayout());
        this.descriptionArea = new JUndoableTextArea(((SecurityTest)this.getModelItem()).getDescription());
        this.descriptionArea.getDocument().addDocumentListener(new DocumentListenerAdapter(){

            public void update(Document document) {
                ((SecurityTest)SecurityTestDesktopPanel.this.getModelItem()).setDescription(SecurityTestDesktopPanel.this.descriptionArea.getText());
            }
        });
        panel.setBorder(BorderFactory.createEmptyBorder(2, 2, 2, 2));
        panel.add((Component)new JScrollPane(this.descriptionArea), "Center");
        UISupport.addTitledBorder(panel, "SecurityTest Description");
        return panel;
    }

    protected Component buildToolbar() {
        this.toolbar = UISupport.createToolbar();
        this.runButton = UISupport.createToolbarButton(new RunSecurityTestAction());
        this.optionsButton = UISupport.createToolbarButton(SwingActionDelegate.createDelegate("SecurityTestOptionsAction", this.getModelItem(), null, "/options.gif"));
        this.optionsButton.setText(null);
        this.cancelButton = UISupport.createToolbarButton(new CancelRunSecuritytestAction(), false);
        this.setCredentialsButton = UISupport.createToolbarButton(new SetCredentialsAction(((SecurityTest)this.getModelItem()).getTestCase()));
        this.setEndpointButton = UISupport.createToolbarButton(new SetEndpointAction(((SecurityTest)this.getModelItem()).getTestCase()));
        this.stateDependantComponents.add(this.runButton);
        this.stateDependantComponents.add(this.optionsButton);
        this.stateDependantComponents.add(this.cancelButton);
        this.stateDependantComponents.add(this.setCredentialsButton);
        this.stateDependantComponents.add(this.setEndpointButton);
        this.addToolbarActions(this.toolbar);
        this.toolbar.addSeparator();
        this.toolbar.add(Box.createHorizontalGlue());
        this.toolbar.add(UISupport.createToolbarButton(new ShowOnlineHelpAction("http://www.soapui.org/Security/working-with-security-tests.html")));
        return this.toolbar;
    }

    protected JButton getSetEndpointButton() {
        return this.setEndpointButton;
    }

    public JButton getOptionsButton() {
        return this.optionsButton;
    }

    public void setOptionsButton(JButton optionsButton) {
        this.optionsButton = optionsButton;
    }

    protected void addToolbarActions(JToolBar toolbar) {
        toolbar.add(this.runButton);
        toolbar.add(this.cancelButton);
        toolbar.addSeparator();
        toolbar.add(this.setCredentialsButton);
        toolbar.add(this.setEndpointButton);
        toolbar.addSeparator();
        toolbar.add(this.optionsButton);
    }

    protected void runSecurityTest() {
        this.initializeStatusIcons();
        if (this.canceled) {
            this.runButton.setEnabled(true);
            this.cancelButton.setEnabled(false);
            return;
        }
        this.runButton.setEnabled(false);
        this.cancelButton.setEnabled(true);
        StringToObjectMap properties = new StringToObjectMap();
        properties.put("Interactive", Boolean.TRUE);
        this.lastRunner = null;
        this.runner = ((SecurityTest)this.getModelItem()).run(properties, true);
    }

    @Override
    protected boolean release() {
        this.testStepList.release();
        this.setupGroovyEditor.release();
        this.tearDownGroovyEditor.release();
        this.functionalTestLog.release();
        return super.release();
    }

    @Override
    public boolean onClose(boolean canCancel) {
        if (canCancel) {
            if (this.runner != null && this.runner.getStatus() == TestRunner.Status.RUNNING) {
                Boolean retval = UISupport.confirmOrCancel("Cancel running SecurityTest?", "Cancel Run");
                if (retval == null) {
                    return false;
                }
                if (retval.booleanValue() && this.runner != null) {
                    this.runner.cancel(null);
                }
            }
        } else if (this.runner != null && this.runner.getStatus() == TestRunner.Status.RUNNING && this.runner != null) {
            this.runner.cancel(null);
        }
        ((SecurityTest)this.getModelItem()).removeSecurityTestRunListener(this.securityTestRunListener);
        this.progressBarAdapter.release();
        this.propertiesTable.release();
        this.inspectorPanel.release();
        this.setupGroovyEditor.getEditor().release();
        this.tearDownGroovyEditor.getEditor().release();
        this.securityTestLog.release();
        this.lastRunner = null;
        return this.release();
    }

    protected void beforeRun() {
    }

    protected void afterRun() {
        this.runButton.setEnabled(true);
        this.cancelButton.setEnabled(false);
        this.testStepList.setEnabled(true);
    }

    public SecurityTestRunner getSecurityTestRunner() {
        return this.runner == null ? this.lastRunner : this.runner;
    }

    @Override
    public boolean dependsOn(ModelItem modelItem) {
        SecurityTest securityTest = (SecurityTest)this.getModelItem();
        return modelItem == securityTest || modelItem == securityTest.getTestCase() || modelItem == securityTest.getTestCase().getTestSuite() || modelItem == securityTest.getTestCase().getTestSuite().getProject();
    }

    protected SecurityTest getSecurityTest() {
        return this.securityTest;
    }

    @Override
    protected void renameModelItem() {
        SoapUI.getActionRegistry().performAction("RenameSecurityTestAction", (ModelItem)this.getModelItem(), null);
    }

    @Override
    protected void cloneModelItem() {
        SoapUI.getActionRegistry().performAction("CloneSecurityTestAction", (ModelItem)this.getModelItem(), null);
    }

    public class InternalSecurityTestRunListener
    extends SecurityTestRunListenerAdapter {
        public void beforeRun(TestCaseRunner testRunner, SecurityTestRunContext runContext) {
            SecurityTestDesktopPanel.this.securityTestLog.clear();
            SecurityTestDesktopPanel.this.functionalTestLog.clear();
            SecurityTestDesktopPanel.this.runButton.setEnabled(false);
            SecurityTestDesktopPanel.this.cancelButton.setEnabled(true);
            SecurityTestDesktopPanel.this.testStepList.setEnabled(false);
            String start = DateUtil.formatExtraFull(new Date());
            SecurityTestDesktopPanel.this.securityTestLog.addText("SecurityTest started at " + start);
            SecurityTestDesktopPanel.this.functionalTestLog.addText("Test started at " + start);
            SecurityTestDesktopPanel.this.beforeRun();
            SecurityTestDesktopPanel.this.progressBar.setValue(0);
            SecurityTestDesktopPanel.this.progressBar.setString("");
            if (SecurityTestDesktopPanel.this.runner == null) {
                SecurityTestDesktopPanel.this.runner = (SecurityTestRunnerImpl)testRunner;
            }
            SecurityTestDesktopPanel.this.securityStatus = SecurityResult.ResultStatus.UNKNOWN;
        }

        public void afterRun(TestCaseRunner testRunner, SecurityTestRunContext runContext) {
            SecurityTestRunnerImpl securityRunner = (SecurityTestRunnerImpl)testRunner;
            if (testRunner.getStatus() == TestRunner.Status.CANCELED) {
                SecurityTestDesktopPanel.this.securityTestLog.addText("SecurityTest canceled [" + testRunner.getReason() + "], time taken = " + securityRunner.getTimeTaken());
                SecurityTestDesktopPanel.this.functionalTestLog.addText("FunctionalTest canceled [" + testRunner.getReason() + "], time taken = " + securityRunner.getFunctionalTimeTaken());
            } else if (testRunner.getStatus() == TestRunner.Status.FAILED) {
                String msg = securityRunner.getReason();
                if (securityRunner.getError() != null) {
                    if (msg != null) {
                        msg = msg + ":";
                    }
                    msg = msg + securityRunner.getError();
                }
                SecurityTestDesktopPanel.this.securityTestLog.addText("SecurityTest failed [" + msg + "], time taken = " + securityRunner.getTimeTaken());
                if (SecurityTestDesktopPanel.this.functionalStatus == SecurityResult.ResultStatus.OK) {
                    SecurityTestDesktopPanel.this.functionalTestLog.addText("FunctionalTest finished with status [" + (Object)((Object)SecurityTestDesktopPanel.this.functionalStatus) + "], time taken = " + securityRunner.getFunctionalTimeTaken());
                } else if (SecurityTestDesktopPanel.this.functionalStatus == SecurityResult.ResultStatus.FAILED) {
                    SecurityTestDesktopPanel.this.functionalTestLog.addText("FunctionalTest failed [Failing due to failed test step], time taken = " + securityRunner.getFunctionalTimeTaken());
                }
            } else {
                SecurityTestDesktopPanel.this.securityTestLog.addText("SecurityTest finished with status [" + (Object)((Object)testRunner.getStatus()) + "], time taken = " + securityRunner.getTimeTaken());
                if (SecurityTestDesktopPanel.this.functionalStatus == SecurityResult.ResultStatus.OK) {
                    SecurityTestDesktopPanel.this.functionalTestLog.addText("FunctionalTest finished with status [" + (Object)((Object)SecurityTestDesktopPanel.this.functionalStatus) + "], time taken = " + securityRunner.getFunctionalTimeTaken());
                } else if (SecurityTestDesktopPanel.this.functionalStatus == SecurityResult.ResultStatus.FAILED) {
                    SecurityTestDesktopPanel.this.functionalTestLog.addText("FunctionalTest failed [Failing due to failed test step], time taken = " + securityRunner.getFunctionalTimeTaken());
                }
            }
            SecurityTestDesktopPanel.this.lastRunner = SecurityTestDesktopPanel.this.runner;
            SecurityTestDesktopPanel.this.runner = null;
            SecurityTestDesktopPanel.this.afterRun();
            if (testRunner.getStatus() == TestRunner.Status.FAILED) {
                SecurityTestDesktopPanel.this.securityStatus = SecurityResult.ResultStatus.FAILED;
            } else if ((testRunner.getStatus() == TestRunner.Status.FINISHED || testRunner.getStatus() == TestRunner.Status.CANCELED) && SecurityTestDesktopPanel.this.securityStatus != SecurityResult.ResultStatus.FAILED) {
                SecurityTestDesktopPanel.this.securityStatus = SecurityResult.ResultStatus.OK;
            }
            SecurityTestDesktopPanel.this.updateStatusIcon(SecurityTestDesktopPanel.this.securityStatus, SecurityTestDesktopPanel.this.securityLogInspector);
            SecurityTestDesktopPanel.this.updateStatusIcon(SecurityTestDesktopPanel.this.functionalStatus, SecurityTestDesktopPanel.this.functionalLogInspector);
        }

        public void beforeSecurityScan(TestCaseRunner testRunner, SecurityTestRunContext runContext, SecurityScan securityCheck) {
            SecurityTestDesktopPanel.this.securityTestLog.addSecurityScanResult(securityCheck);
        }

        public void afterSecurityScan(TestCaseRunner testRunner, SecurityTestRunContext runContext, SecurityScanResult securityCheckResult) {
            SecurityTestDesktopPanel.this.securityTestLog.updateSecurityScanResult(securityCheckResult);
            if (securityCheckResult.getStatus() == SecurityResult.ResultStatus.CANCELED && securityCheckResult.isHasRequestsWithWarnings()) {
                SecurityTestDesktopPanel.this.securityStatus = SecurityResult.ResultStatus.FAILED;
            } else if (securityCheckResult.getStatus() == SecurityResult.ResultStatus.FAILED) {
                SecurityTestDesktopPanel.this.securityStatus = SecurityResult.ResultStatus.FAILED;
            } else if (securityCheckResult.getStatus() == SecurityResult.ResultStatus.OK && SecurityTestDesktopPanel.this.securityStatus != SecurityResult.ResultStatus.FAILED) {
                SecurityTestDesktopPanel.this.securityStatus = SecurityResult.ResultStatus.OK;
            }
        }

        public void afterOriginalStep(TestCaseRunner testRunner, SecurityTestRunContext runContext, SecurityTestStepResult result) {
            SecurityTestDesktopPanel.this.functionalTestLog.addSecurityTestFunctionalStepResult(result.getOriginalTestStepResult());
            if (result.getOriginalTestStepResult().getStatus() == TestStepResult.TestStepStatus.FAILED) {
                SecurityTestDesktopPanel.this.functionalStatus = SecurityResult.ResultStatus.FAILED;
            } else if (result.getOriginalTestStepResult().getStatus() == TestStepResult.TestStepStatus.OK && SecurityTestDesktopPanel.this.functionalStatus != SecurityResult.ResultStatus.FAILED) {
                SecurityTestDesktopPanel.this.functionalStatus = SecurityResult.ResultStatus.OK;
            }
        }

        public void afterSecurityScanRequest(TestCaseRunner testRunner, SecurityTestRunContext runContext, SecurityScanRequestResult securityCheckReqResult) {
            SecurityTestDesktopPanel.this.securityTestLog.addSecurityScanRequestResult(securityCheckReqResult);
        }

        public void beforeStep(TestCaseRunner testRunner, SecurityTestRunContext runContext, TestStepResult testStepResult) {
            SecurityTestDesktopPanel.this.startStepLogEntryAdded = SecurityTestDesktopPanel.this.securityTestLog.addSecurityTestStepResult(testStepResult.getTestStep());
        }

        public void afterStep(TestCaseRunner testRunner, SecurityTestRunContext runContext, SecurityTestStepResult result) {
            boolean hasChecksToProcess = SecurityTestDesktopPanel.this.securityTest.getTestStepSecurityScansCount(result.getTestStep().getId()) > 0;
            SecurityTestDesktopPanel.this.securityTestLog.updateSecurityTestStepResult(result, hasChecksToProcess, SecurityTestDesktopPanel.this.startStepLogEntryAdded);
            if (result.getStatus() == SecurityResult.ResultStatus.FAILED) {
                SecurityTestDesktopPanel.this.securityStatus = SecurityResult.ResultStatus.FAILED;
            } else if (result.getStatus() == SecurityResult.ResultStatus.OK && SecurityTestDesktopPanel.this.securityStatus != SecurityResult.ResultStatus.FAILED) {
                SecurityTestDesktopPanel.this.securityStatus = SecurityResult.ResultStatus.OK;
            }
        }
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    public static class ModelItemListDragAndDropable
    extends JListDragAndDropable<JList> {
        public ModelItemListDragAndDropable(JList list, WsdlTestCase testCase) {
            super(list, testCase);
        }

        @Override
        public ModelItem getModelItemAtRow(int row) {
            return (ModelItem)((JList)this.getList()).getModel().getElementAt(row);
        }

        @Override
        public int getModelItemRow(ModelItem modelItem) {
            ListModel model = ((JList)this.getList()).getModel();
            for (int c = 0; c < model.getSize(); ++c) {
                if (model.getElementAt(c) != modelItem) continue;
                return c;
            }
            return -1;
        }

        @Override
        public Component getRenderer(ModelItem modelItem) {
            return ((JList)this.getList()).getCellRenderer().getListCellRendererComponent((JList<ModelItem>)this.getList(), modelItem, this.getModelItemRow(modelItem), true, true);
        }

        @Override
        public void setDragInfo(String dropInfo) {
            super.setDragInfo(dropInfo == null || dropInfo.length() == 0 ? null : dropInfo);
        }
    }

    private class TearDownScriptGroovyEditorModel
    extends AbstractGroovyEditorModel {
        public Action createRunAction() {
            return new AbstractAction(){

                public void actionPerformed(ActionEvent e) {
                    try {
                        MockSecurityTestRunner securityTestRunner = new MockSecurityTestRunner((SecurityTest)SecurityTestDesktopPanel.this.getModelItem());
                        ((SecurityTest)SecurityTestDesktopPanel.this.getModelItem()).runTearDownScript((SecurityTestRunContext)securityTestRunner.getRunContext(), securityTestRunner);
                    }
                    catch (Exception e1) {
                        UISupport.showErrorMessage(e1);
                    }
                }
            };
        }

        public TearDownScriptGroovyEditorModel() {
            super(new String[]{"log", "securityTest", "context", "testRunner"}, (ModelItem)SecurityTestDesktopPanel.this.getModelItem(), "TearDown");
        }

        public String getScript() {
            return ((SecurityTest)SecurityTestDesktopPanel.this.getModelItem()).getTearDownScript();
        }

        public void setScript(String text) {
            ((SecurityTest)SecurityTestDesktopPanel.this.getModelItem()).setTearDownScript(text);
        }
    }

    private class SetupScriptGroovyEditorModel
    extends AbstractGroovyEditorModel {
        public Action createRunAction() {
            return new AbstractAction(){

                public void actionPerformed(ActionEvent e) {
                    MockSecurityTestRunner securityTestRunner = new MockSecurityTestRunner((SecurityTest)SecurityTestDesktopPanel.this.getModelItem());
                    try {
                        ((SecurityTest)SecurityTestDesktopPanel.this.getModelItem()).runStartupScript((SecurityTestRunContext)securityTestRunner.getRunContext(), securityTestRunner);
                    }
                    catch (Exception e1) {
                        UISupport.showErrorMessage(e1);
                    }
                }
            };
        }

        public SetupScriptGroovyEditorModel() {
            super(new String[]{"log", "testCase", "context", "testRunner"}, (ModelItem)SecurityTestDesktopPanel.this.getModelItem(), "Setup");
        }

        public String getScript() {
            return ((SecurityTest)SecurityTestDesktopPanel.this.getModelItem()).getStartupScript();
        }

        public void setScript(String text) {
            ((SecurityTest)SecurityTestDesktopPanel.this.getModelItem()).setStartupScript(text);
        }
    }

    public class CancelRunSecuritytestAction
    extends AbstractAction {
        public CancelRunSecuritytestAction() {
            this.putValue("SmallIcon", UISupport.createImageIcon("/stop_testcase.gif"));
            this.putValue("ShortDescription", "Stops running this securitytest");
        }

        public void actionPerformed(ActionEvent e) {
            if (SecurityTestDesktopPanel.this.runner != null) {
                SecurityTestDesktopPanel.this.runner.cancel("canceled in UI");
            }
            SecurityTestDesktopPanel.this.canceled = true;
        }
    }

    public class RunSecurityTestAction
    extends AbstractAction {
        public RunSecurityTestAction() {
            this.putValue("SmallIcon", UISupport.createImageIcon("/run_testcase.gif"));
            this.putValue("ShortDescription", "Runs this securitytest");
        }

        public void actionPerformed(ActionEvent e) {
            SecurityTestDesktopPanel.this.canceled = false;
            boolean shouldRun = false;
            for (List<SecurityScan> scanList : SecurityTestDesktopPanel.this.securityTest.getSecurityScansMap().values()) {
                for (SecurityScan scan : scanList) {
                    if (scan.isDisabled()) continue;
                    shouldRun = true;
                }
            }
            if (shouldRun) {
                SecurityTestDesktopPanel.this.runSecurityTest();
            } else {
                UISupport.showInfoMessage("No Security Scans available to run.", "Security Test Warning");
            }
        }
    }
}

