/*
 * Decompiled with CFR 0.152.
 */
package com.eviware.soapui.security.registry;

import com.eviware.soapui.config.SecurityScanConfig;
import com.eviware.soapui.impl.wsdl.teststeps.HttpTestRequestStep;
import com.eviware.soapui.impl.wsdl.teststeps.RestTestRequestStep;
import com.eviware.soapui.impl.wsdl.teststeps.WsdlTestRequestStep;
import com.eviware.soapui.model.ModelItem;
import com.eviware.soapui.model.testsuite.TestStep;
import com.eviware.soapui.security.registry.AbstractSecurityScanFactory;
import com.eviware.soapui.security.scan.AbstractSecurityScan;
import com.eviware.soapui.security.scan.CrossSiteScriptingScan;

public class CrossSiteScriptingScanFactory
extends AbstractSecurityScanFactory {
    public CrossSiteScriptingScanFactory() {
        super("CrossSiteScriptingScan", "Cross Site Scripting", "Preforms a scan for Cross Site Scripting", "/cross_site_script_scan.gif");
    }

    public boolean canCreate(TestStep testStep) {
        return testStep instanceof WsdlTestRequestStep || testStep instanceof RestTestRequestStep || testStep instanceof HttpTestRequestStep;
    }

    public AbstractSecurityScan buildSecurityScan(TestStep testStep, SecurityScanConfig config, ModelItem parent) {
        return new CrossSiteScriptingScan(testStep, config, parent, "/cross_site_script_scan.gif");
    }

    public SecurityScanConfig createNewSecurityScan(String name) {
        SecurityScanConfig securityCheckConfig = SecurityScanConfig.Factory.newInstance();
        securityCheckConfig.setType("CrossSiteScriptingScan");
        securityCheckConfig.setName(name);
        return securityCheckConfig;
    }
}

