/*
 * Decompiled with CFR 0.152.
 */
package com.eviware.soapui.security.scan;

import com.eviware.soapui.SoapUI;
import com.eviware.soapui.config.InvalidSecurityScanConfig;
import com.eviware.soapui.config.SchemaTypeForSecurityScanConfig;
import com.eviware.soapui.config.SecurityScanConfig;
import com.eviware.soapui.config.StrategyTypeConfig;
import com.eviware.soapui.model.ModelItem;
import com.eviware.soapui.model.iface.MessageExchange;
import com.eviware.soapui.model.security.SecurityCheckedParameter;
import com.eviware.soapui.model.testsuite.TestCaseRunner;
import com.eviware.soapui.model.testsuite.TestProperty;
import com.eviware.soapui.model.testsuite.TestStep;
import com.eviware.soapui.security.SecurityTestRunContext;
import com.eviware.soapui.security.SecurityTestRunner;
import com.eviware.soapui.security.boundary.BoundaryRestrictionUtill;
import com.eviware.soapui.security.scan.AbstractSecurityScanWithProperties;
import com.eviware.soapui.security.ui.InvalidTypesTable;
import com.eviware.soapui.support.UISupport;
import com.eviware.soapui.support.types.StringToStringMap;
import com.eviware.soapui.support.xml.XmlObjectTreeModel;
import com.eviware.soapui.support.xml.XmlUtils;
import java.awt.Component;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import javax.swing.JComponent;
import javax.swing.JLabel;
import javax.swing.JPanel;
import org.apache.xmlbeans.XmlException;
import org.apache.xmlbeans.XmlObject;
import org.apache.xmlbeans.impl.schema.SchemaTypeImpl;

public class InvalidTypesSecurityScan
extends AbstractSecurityScanWithProperties {
    public static final String TYPE = "InvalidTypesSecurityScan";
    public static final String NAME = "Invalid Types";
    private InvalidTypesForSOAP invalidTypes;
    private TypeLabel typeLabel = new TypeLabel();
    private InvalidSecurityScanConfig invalidTypeConfig;
    private Map<SecurityCheckedParameter, ArrayList<String>> parameterMutations = new HashMap<SecurityCheckedParameter, ArrayList<String>>();
    private boolean mutation;

    public InvalidTypesSecurityScan(TestStep testStep, SecurityScanConfig config, ModelItem parent, String icon) {
        super(testStep, config, parent, icon);
        if (config.getConfig() == null || !(config.getConfig() instanceof InvalidSecurityScanConfig)) {
            this.initInvalidTypesConfig();
        } else {
            this.invalidTypeConfig = (InvalidSecurityScanConfig)config.getConfig();
        }
    }

    public void updateSecurityConfig(SecurityScanConfig config) {
        super.updateSecurityConfig(config);
        if (this.invalidTypeConfig != null) {
            this.invalidTypeConfig = (InvalidSecurityScanConfig)((SecurityScanConfig)this.getConfig()).getConfig();
        }
    }

    public InvalidSecurityScanConfig getInvalidTypeConfig() {
        if (this.invalidTypeConfig == null || ((SecurityScanConfig)this.getConfig()).getConfig() == null || !(((SecurityScanConfig)this.getConfig()).getConfig() instanceof InvalidSecurityScanConfig)) {
            this.initInvalidTypesConfig();
        }
        return this.invalidTypeConfig;
    }

    private void initInvalidTypesConfig() {
        ((SecurityScanConfig)this.getConfig()).setConfig((XmlObject)InvalidSecurityScanConfig.Factory.newInstance());
        this.invalidTypeConfig = (InvalidSecurityScanConfig)((SecurityScanConfig)this.getConfig()).getConfig();
        this.invalidTypes = new InvalidTypesForSOAP();
        for (int key : this.invalidTypes.getDefaultTypeMap().keySet()) {
            SchemaTypeForSecurityScanConfig newType = this.invalidTypeConfig.addNewTypesList();
            newType.setValue(this.invalidTypes.getDefaultTypeMap().get(key));
            newType.setType(key);
        }
    }

    public JComponent getAdvancedSettingsPanel() {
        return new InvalidTypesTable(this.getInvalidTypeConfig());
    }

    public JComponent getComponent() {
        JPanel panel = UISupport.createEmptyPanel(5, 75, 0, 5);
        panel.add((Component)this.typeLabel.getJLabel(), "Center");
        return panel;
    }

    public String getType() {
        return TYPE;
    }

    public boolean isConfigurable() {
        return true;
    }

    protected void execute(SecurityTestRunner securityTestRunner, TestStep testStep, SecurityTestRunContext context) {
        try {
            StringToStringMap updatedParams = this.updateRequestContent(testStep, context);
            MessageExchange message = (MessageExchange)((Object)testStep.run((TestCaseRunner)((Object)securityTestRunner), context));
            this.createMessageExchange(updatedParams, message, context);
        }
        catch (XmlException e) {
            SoapUI.logError(e, "[InvalidtypeSecurityScan]XPath seems to be invalid!");
            this.reportSecurityScanException("Property value is not XML or XPath is wrong!");
        }
        catch (Exception e) {
            SoapUI.logError(e, "[InvalidtypeSecurityScan]Property value is not valid xml!");
            this.reportSecurityScanException("Property value is not XML or XPath is wrong!");
        }
    }

    private StringToStringMap updateRequestContent(TestStep testStep, SecurityTestRunContext context) throws XmlException, Exception {
        StringToStringMap params = new StringToStringMap();
        if (this.parameterMutations.size() == 0) {
            this.mutateParameters(testStep, context);
        }
        if (this.getExecutionStrategy().getStrategy() == StrategyTypeConfig.ONE_BY_ONE) {
            for (SecurityCheckedParameter param : this.getParameterHolder().getParameterList()) {
                XmlObjectTreeModel.XmlTreeNode[] nodes;
                if (!this.parameterMutations.containsKey(param) || this.parameterMutations.get(param).size() <= 0) continue;
                TestProperty property = this.getTestStep().getProperties().get(param.getName());
                String value = context.expand(property.getValue());
                if (param.getXpath() == null || param.getXpath().trim().length() == 0) {
                    testStep.getProperties().get(param.getName()).setValue(this.parameterMutations.get(param).get(0));
                    params.put(param.getLabel(), this.parameterMutations.get(param).get(0));
                    this.parameterMutations.get(param).remove(0);
                    break;
                }
                if (value == null || value.trim().equals("")) continue;
                if (!XmlUtils.seemsToBeXml(value)) break;
                XmlObjectTreeModel model = new XmlObjectTreeModel(property.getSchemaType().getTypeSystem(), XmlUtils.createXmlObject(value));
                for (XmlObjectTreeModel.XmlTreeNode node : nodes = model.selectTreeNodes(context.expand(param.getXpath()))) {
                    node.setValue(1, this.parameterMutations.get(param).get(0));
                }
                params.put(param.getLabel(), this.parameterMutations.get(param).get(0));
                this.parameterMutations.get(param).remove(0);
                testStep.getProperties().get(param.getName()).setValue(model.getXmlObject().toString());
                break;
            }
        } else {
            for (TestProperty property : testStep.getPropertyList()) {
                String value = context.expand(property.getValue());
                if (!XmlUtils.seemsToBeXml(value)) continue;
                XmlObjectTreeModel model = null;
                model = new XmlObjectTreeModel(property.getSchemaType().getTypeSystem(), XmlUtils.createXmlObject(value));
                for (SecurityCheckedParameter param : this.getParameterHolder().getParameterList()) {
                    if (param.getXpath() == null || param.getXpath().trim().length() == 0) {
                        testStep.getProperties().get(param.getName()).setValue(this.parameterMutations.get(param).get(0));
                        params.put(param.getLabel(), this.parameterMutations.get(param).get(0));
                        this.parameterMutations.get(param).remove(0);
                        continue;
                    }
                    if (value == null || value.trim().equals("") || !param.getName().equals(property.getName())) continue;
                    XmlObjectTreeModel.XmlTreeNode[] nodes = model.selectTreeNodes(context.expand(param.getXpath()));
                    if (!this.parameterMutations.containsKey(param) || this.parameterMutations.get(param).size() <= 0) continue;
                    for (XmlObjectTreeModel.XmlTreeNode node : nodes) {
                        node.setValue(1, this.parameterMutations.get(param).get(0));
                    }
                    params.put(param.getLabel(), this.parameterMutations.get(param).get(0));
                    this.parameterMutations.get(param).remove(0);
                }
                if (model == null) continue;
                property.setValue(model.getXmlObject().toString());
            }
        }
        return params;
    }

    private void mutateParameters(TestStep testStep, SecurityTestRunContext context) throws XmlException, Exception {
        this.mutation = true;
        for (SecurityCheckedParameter parameter : this.getParameterHolder().getParameterList()) {
            String value;
            if (!parameter.isChecked()) continue;
            TestProperty property = this.getTestStep().getProperties().get(parameter.getName());
            if (parameter.getXpath() == null || parameter.getXpath().trim().length() == 0) {
                for (SchemaTypeForSecurityScanConfig invalidType : this.invalidTypeConfig.getTypesListList()) {
                    if (!this.parameterMutations.containsKey(parameter)) {
                        this.parameterMutations.put(parameter, new ArrayList());
                    }
                    this.parameterMutations.get(parameter).add(invalidType.getValue());
                }
                continue;
            }
            if (property.getValue() == null && property.getDefaultValue() == null || !XmlUtils.seemsToBeXml(value = context.expand(property.getValue()))) continue;
            XmlObjectTreeModel model = new XmlObjectTreeModel(property.getSchemaType().getTypeSystem(), XmlUtils.createXmlObject(value));
            XmlObjectTreeModel.XmlTreeNode[] nodes = model.selectTreeNodes(context.expand(parameter.getXpath()));
            List invalidTypes = this.invalidTypeConfig.getTypesListList();
            for (SchemaTypeForSecurityScanConfig type : invalidTypes) {
                if (nodes.length <= 0 || nodes[0].getSchemaType().getBuiltinTypeCode() == type.getType()) continue;
                if (!this.parameterMutations.containsKey(parameter)) {
                    this.parameterMutations.put(parameter, new ArrayList());
                }
                this.parameterMutations.get(parameter).add(type.getValue());
            }
        }
    }

    protected boolean hasNext(TestStep testStep, SecurityTestRunContext context) {
        boolean hasNext = false;
        if (!(this.parameterMutations != null && this.parameterMutations.size() != 0 || this.mutation)) {
            hasNext = this.getParameterHolder().getParameterList().size() > 0;
        } else {
            for (SecurityCheckedParameter param : this.parameterMutations.keySet()) {
                if (this.parameterMutations.get(param).size() <= 0) continue;
                hasNext = true;
                break;
            }
        }
        if (!hasNext) {
            this.parameterMutations.clear();
            this.mutation = false;
        }
        return hasNext;
    }

    public String getConfigDescription() {
        return "Configures invalid type security scan";
    }

    public String getConfigName() {
        return "Invalid Types Security Scan";
    }

    public String getHelpURL() {
        return "http://soapui.org/Security/invalid-types.html";
    }

    protected void clear() {
        this.parameterMutations.clear();
        this.mutation = false;
    }

    public TypeLabel getTypeLabel() {
        return this.typeLabel;
    }

    public void refreshRestrictionLabel(int row) {
        if (row == -1) {
            this.typeLabel.setJlabel("- no parameter selected -");
            return;
        }
        SecurityCheckedParameter parameter = this.getParameterAt(row);
        if (parameter == null) {
            return;
        }
        String name = parameter.getName();
        String xpath = parameter.getXpath();
        TestProperty tp = this.getTestStep().getProperty(name);
        XmlObjectTreeModel xmlObjectTreeModel = null;
        if (tp.getSchemaType() != null && XmlUtils.seemsToBeXml(tp.getValue())) {
            try {
                xmlObjectTreeModel = new XmlObjectTreeModel(tp.getSchemaType().getTypeSystem(), XmlUtils.createXmlObject(tp.getValue()));
            }
            catch (XmlException e) {
                SoapUI.logError(e);
            }
            XmlObjectTreeModel.XmlTreeNode[] treeNodes = xmlObjectTreeModel.selectTreeNodes(xpath);
            if (treeNodes.length == 0) {
                this.typeLabel.setJlabel("");
                return;
            }
            SchemaTypeImpl simpleType = (SchemaTypeImpl)treeNodes[0].getSchemaType();
            if (simpleType != null && !simpleType.isNoType()) {
                XmlObjectTreeModel model2 = new XmlObjectTreeModel(simpleType.getTypeSystem(), simpleType.getParseObject());
                List<String> list = BoundaryRestrictionUtill.getType(model2.getRootNode(), new ArrayList<String>());
                if (list.isEmpty()) {
                    this.typeLabel.setJlabel("parameter has type [" + simpleType.getName() + "]");
                } else {
                    this.typeLabel.setJlabel("parameter has types [" + list.toString() + "]");
                }
            } else {
                this.typeLabel.setJlabel("parameter is missing type in schema");
            }
        } else {
            this.typeLabel.setJlabel("- no parameter selected ->");
        }
    }

    public class TypeLabel {
        private String text = "<html><pre>    </pre></html>";
        private JLabel jlabel = new JLabel();

        public TypeLabel() {
            this.setJlabel(this.text);
        }

        public void setJlabel(String text) {
            text = text.replace("[", "");
            text = text.replace("]", "");
            this.jlabel.setText(text);
        }

        public JLabel getJLabel() {
            return this.jlabel;
        }
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    private class InvalidTypesForSOAP {
        private HashMap<Integer, String> typeMap = new HashMap();

        public InvalidTypesForSOAP() {
            this.generateInvalidTypes();
        }

        private void generateInvalidTypes() {
            this.typeMap.put(12, "SoapUI is\t the\r best\n");
            this.typeMap.put(35, "SoapUI is the best");
            this.typeMap.put(36, "SoapUI is the best");
            this.typeMap.put(4, "GpM7");
            this.typeMap.put(5, "0FB7");
            this.typeMap.put(22, "-1267896799");
            this.typeMap.put(30, "1267896799");
            this.typeMap.put(28, "-1");
            this.typeMap.put(29, "1");
            this.typeMap.put(27, "0");
            this.typeMap.put(23, "-882223334991111111");
            this.typeMap.put(31, "882223334991111111");
            this.typeMap.put(24, "-2147483647");
            this.typeMap.put(32, "294967295");
            this.typeMap.put(25, "-32768");
            this.typeMap.put(33, "65535");
            this.typeMap.put(26, "127");
            this.typeMap.put(34, "255");
            this.typeMap.put(11, "-1.23");
            this.typeMap.put(9, "-1E4f");
            this.typeMap.put(10, "12.45E+12");
            this.typeMap.put(3, "true");
            this.typeMap.put(13, "P1Y2M3DT10H30M12.3S");
            this.typeMap.put(14, "1999-05-31T13:20:00.000-05:00");
            this.typeMap.put(16, "1999-05-31");
        }

        public HashMap<Integer, String> getDefaultTypeMap() {
            return this.typeMap;
        }
    }
}

