/*
 * Decompiled with CFR 0.152.
 */
package com.eviware.soapui.security.scan;

import com.eviware.soapui.model.testsuite.TestStep;
import com.eviware.soapui.security.SecurityTestRunContext;
import com.eviware.soapui.support.types.StringToStringMap;
import java.util.Arrays;
import java.util.List;
import java.util.Stack;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class PropertyMutation {
    public static final String REQUEST_MUTATIONS_STACK = "RequestMutationsStack";
    private String propertyName;
    private String propertyValue;
    private StringToStringMap mutatedParameters;
    private TestStep testStep;

    public TestStep getTestStep() {
        return this.testStep;
    }

    public void setTestStep(TestStep testStep) {
        this.testStep = testStep;
    }

    public String getPropertyName() {
        return this.propertyName;
    }

    public String getPropertyValue() {
        return this.propertyValue;
    }

    public StringToStringMap getMutatedParameters() {
        return this.mutatedParameters;
    }

    public void setPropertyName(String propertyName) {
        this.propertyName = propertyName;
    }

    public void setPropertyValue(String propertyValue) {
        this.propertyValue = propertyValue;
    }

    public void setMutatedParameters(StringToStringMap mutatedParameters) {
        if (this.mutatedParameters == null) {
            this.mutatedParameters = new StringToStringMap();
        }
        this.mutatedParameters.putAll(mutatedParameters);
    }

    public void updateRequestProperty(TestStep testStep) {
        testStep.getProperty(this.getPropertyName()).setValue(this.getPropertyValue());
    }

    public void addMutation(SecurityTestRunContext context) {
        Stack stack = (Stack)context.get(REQUEST_MUTATIONS_STACK);
        stack.push(this);
    }

    public static PropertyMutation popMutation(SecurityTestRunContext context) {
        Stack requestMutationsStack = (Stack)context.get(REQUEST_MUTATIONS_STACK);
        return requestMutationsStack.empty() ? null : (PropertyMutation)requestMutationsStack.pop();
    }

    public static List<PropertyMutation> popAllMutation(SecurityTestRunContext context) {
        Stack requestMutationsStack = (Stack)context.get(REQUEST_MUTATIONS_STACK);
        PropertyMutation[] array = requestMutationsStack.toArray(new PropertyMutation[requestMutationsStack.size()]);
        requestMutationsStack.clear();
        return Arrays.asList(array);
    }
}

