/*
 * Decompiled with CFR 0.152.
 */
package com.eviware.soapui.security.support;

import com.eviware.soapui.model.security.SecurityScan;
import com.eviware.soapui.model.testsuite.TestCaseRunner;
import com.eviware.soapui.model.testsuite.TestRunner;
import com.eviware.soapui.model.testsuite.TestStepResult;
import com.eviware.soapui.security.SecurityTest;
import com.eviware.soapui.security.SecurityTestRunContext;
import com.eviware.soapui.security.SecurityTestRunnerImpl;
import com.eviware.soapui.security.result.SecurityResult;
import com.eviware.soapui.security.result.SecurityScanRequestResult;
import com.eviware.soapui.security.result.SecurityScanResult;
import com.eviware.soapui.security.result.SecurityTestStepResult;
import com.eviware.soapui.security.support.SecurityTestRunListenerAdapter;
import java.awt.Color;
import java.util.List;
import javax.swing.JLabel;
import javax.swing.JProgressBar;

public class ProgressBarSecurityTestAdapter {
    private final JProgressBar progressBar;
    private final SecurityTest securityTest;
    private InternalTestRunListener internalTestRunListener;
    private JLabel counterLabel;
    private static final Color OK_COLOR = new Color(0, 204, 102);
    private static final Color FAILED_COLOR = new Color(255, 102, 0);
    private static final Color UNKNOWN_COLOR = new Color(240, 240, 240);
    private static final String STATE_RUN = "In progress";
    private static final String STATE_DONE = "Done";
    private static final String STATE_CANCEL = "Canceled";
    private int alertsCounter;
    private int previousMaxCheckPosition;

    public ProgressBarSecurityTestAdapter(JProgressBar progressBar, SecurityTest securityTest, JLabel cntLabel) {
        this.progressBar = progressBar;
        this.securityTest = securityTest;
        progressBar.setBackground(UNKNOWN_COLOR);
        this.internalTestRunListener = new InternalTestRunListener();
        securityTest.addSecurityTestRunListener(this.internalTestRunListener);
        cntLabel.setOpaque(true);
        this.counterLabel = cntLabel;
    }

    public void release() {
        this.securityTest.removeSecurityTestRunListener(this.internalTestRunListener);
    }

    public class InternalTestRunListener
    extends SecurityTestRunListenerAdapter {
        public void beforeRun(TestCaseRunner testRunner, SecurityTestRunContext runContext) {
            int maximum = ((SecurityTestRunnerImpl)testRunner).getSecurityTest().getSecurityScanCount();
            for (String key : ProgressBarSecurityTestAdapter.this.securityTest.getSecurityScansMap().keySet()) {
                List<SecurityScan> securityCheckList = ProgressBarSecurityTestAdapter.this.securityTest.getSecurityScansMap().get(key);
                if (securityCheckList.size() <= 0 || !securityCheckList.get(0).getTestStep().isDisabled()) continue;
                maximum -= securityCheckList.size();
            }
            ProgressBarSecurityTestAdapter.this.progressBar.getModel().setMaximum(maximum);
            ProgressBarSecurityTestAdapter.this.progressBar.setForeground(OK_COLOR);
            ProgressBarSecurityTestAdapter.this.progressBar.setBackground(Color.white);
            ProgressBarSecurityTestAdapter.this.progressBar.setValue(0);
            ProgressBarSecurityTestAdapter.this.counterLabel.setOpaque(false);
            ProgressBarSecurityTestAdapter.this.alertsCounter = 0;
            ProgressBarSecurityTestAdapter.this.counterLabel.setText("");
        }

        public void beforeSecurityScan(TestCaseRunner testRunner, SecurityTestRunContext runContext, SecurityScan securityCheck) {
            if (ProgressBarSecurityTestAdapter.this.progressBar.isIndeterminate()) {
                return;
            }
            if (securityCheck != null) {
                ProgressBarSecurityTestAdapter.this.progressBar.setString("In progress:" + securityCheck.getTestStep().getName() + " - " + securityCheck.getName());
                ProgressBarSecurityTestAdapter.this.progressBar.setValue(runContext.getCurrentScanOnSecurityTestIndex());
            }
        }

        public void afterSecurityScan(TestCaseRunner testRunner, SecurityTestRunContext runContext, SecurityScanResult securityCheckResult) {
            if (securityCheckResult.getStatus() == SecurityResult.ResultStatus.CANCELED) {
                ProgressBarSecurityTestAdapter.this.progressBar.setString(ProgressBarSecurityTestAdapter.STATE_CANCEL);
            }
            if (securityCheckResult.getStatus() == SecurityResult.ResultStatus.CANCELED && securityCheckResult.isHasRequestsWithWarnings()) {
                ProgressBarSecurityTestAdapter.this.progressBar.setForeground(FAILED_COLOR);
            } else if (securityCheckResult.getStatus() == SecurityResult.ResultStatus.FAILED) {
                ProgressBarSecurityTestAdapter.this.progressBar.setForeground(FAILED_COLOR);
            } else if (securityCheckResult.getStatus() == SecurityResult.ResultStatus.OK && !ProgressBarSecurityTestAdapter.this.progressBar.getForeground().equals(FAILED_COLOR)) {
                ProgressBarSecurityTestAdapter.this.progressBar.setForeground(OK_COLOR);
            }
        }

        public void beforeStep(TestCaseRunner testRunner, SecurityTestRunContext runContext, TestStepResult testStepResult) {
            ProgressBarSecurityTestAdapter.this.previousMaxCheckPosition = ProgressBarSecurityTestAdapter.this.progressBar.getValue();
        }

        public void afterStep(TestCaseRunner testRunner, SecurityTestRunContext runContext, SecurityTestStepResult result) {
            int currentStepChecksCount = ProgressBarSecurityTestAdapter.this.securityTest.getTestStepSecurityScansCount(result.getTestStep().getId());
            ProgressBarSecurityTestAdapter.this.progressBar.setValue(ProgressBarSecurityTestAdapter.this.previousMaxCheckPosition + currentStepChecksCount);
        }

        public void afterRun(TestCaseRunner testRunner, SecurityTestRunContext runContext) {
            if (testRunner.getStatus() == TestRunner.Status.FAILED) {
                ProgressBarSecurityTestAdapter.this.progressBar.setForeground(FAILED_COLOR);
            } else if (testRunner.getStatus() == TestRunner.Status.FINISHED && !ProgressBarSecurityTestAdapter.this.progressBar.getForeground().equals(FAILED_COLOR)) {
                ProgressBarSecurityTestAdapter.this.progressBar.setForeground(OK_COLOR);
            }
            if (ProgressBarSecurityTestAdapter.this.progressBar.isIndeterminate()) {
                return;
            }
            if (!ProgressBarSecurityTestAdapter.this.progressBar.getString().equals(ProgressBarSecurityTestAdapter.STATE_CANCEL)) {
                ProgressBarSecurityTestAdapter.this.progressBar.setString(ProgressBarSecurityTestAdapter.STATE_DONE);
            }
            ProgressBarSecurityTestAdapter.this.progressBar.setBackground(UNKNOWN_COLOR);
        }

        public void afterSecurityScanRequest(TestCaseRunner testRunner, SecurityTestRunContext runContext, SecurityScanRequestResult securityCheckReqResult) {
            if (securityCheckReqResult.getStatus() == SecurityResult.ResultStatus.FAILED) {
                ProgressBarSecurityTestAdapter.this.counterLabel.setOpaque(true);
                ProgressBarSecurityTestAdapter.this.counterLabel.setBackground(FAILED_COLOR);
                ProgressBarSecurityTestAdapter.this.alertsCounter++;
                ProgressBarSecurityTestAdapter.this.counterLabel.setText(" " + ProgressBarSecurityTestAdapter.this.alertsCounter + " ");
                ProgressBarSecurityTestAdapter.this.progressBar.setForeground(FAILED_COLOR);
            } else if (securityCheckReqResult.getStatus() == SecurityResult.ResultStatus.CANCELED) {
                ProgressBarSecurityTestAdapter.this.progressBar.setString(ProgressBarSecurityTestAdapter.STATE_CANCEL);
            }
        }
    }
}

