/*
 * Decompiled with CFR 0.152.
 */
package com.eviware.soapui.support;

import com.eviware.soapui.SoapUI;
import com.eviware.soapui.impl.wsdl.support.http.ProxyUtils;
import com.eviware.soapui.model.propertyexpansion.PropertyExpander;
import com.eviware.soapui.model.propertyexpansion.PropertyExpansionContext;
import com.eviware.soapui.model.settings.Settings;
import com.eviware.soapui.settings.ProxySettings;
import com.eviware.soapui.support.StringUtils;
import com.eviware.soapui.support.Tools;
import com.eviware.soapui.support.UISupport;
import com.eviware.x.form.XFormDialog;
import java.awt.BorderLayout;
import java.awt.Color;
import java.awt.Component;
import java.awt.Dimension;
import java.awt.event.ActionEvent;
import java.io.IOException;
import java.net.InetSocketAddress;
import java.net.MalformedURLException;
import java.net.Proxy;
import java.net.URL;
import java.net.URLConnection;
import javax.swing.AbstractAction;
import javax.swing.BorderFactory;
import javax.swing.JButton;
import javax.swing.JDialog;
import javax.swing.JEditorPane;
import javax.swing.JPanel;
import javax.swing.JScrollPane;
import javax.xml.parsers.DocumentBuilder;
import javax.xml.parsers.DocumentBuilderFactory;
import javax.xml.parsers.ParserConfigurationException;
import org.w3c.dom.Document;
import org.w3c.dom.Element;
import org.w3c.dom.Node;
import org.w3c.dom.NodeList;
import org.xml.sax.SAXException;

public class SoapUIVersionUpdate {
    static final String VERSION_UPDATE_URL_SYS_PROP_KEY = "versionUpdateUrl";
    static final String LATEST_VERSION_XML_LOCATION = SoapUIVersionUpdate.versionUpdateUrl("http://dl.eviware.com/version-update/soapui-version.xml");
    public static final String VERSION_TO_SKIP = SoapUI.class.getName() + "@versionToSkip";
    protected static final String NO_RELEASE_NOTES_INFO = "<tr><td>Sorry! No Release notes currently available.</td></tr>";
    XFormDialog formDialog;
    private String latestVersion;
    private String releaseNotesCore;
    private String releaseNotesPro;
    private String downloadLinkCore;
    private String downloadLinkPro;

    public void getLatestVersionAvailable(URL versionUrl) throws Exception {
        try {
            URLConnection connection = null;
            if (ProxyUtils.isProxyEnabled()) {
                Settings settings = SoapUI.getSettings();
                PropertyExpansionContext context = null;
                String proxyHost = System.getProperty("http.proxyHost");
                String proxyPort = System.getProperty("http.proxyPort");
                if (proxyHost == null) {
                    proxyHost = PropertyExpander.expandProperties(context, settings.getString(ProxySettings.HOST, ""));
                }
                if (proxyPort == null) {
                    proxyPort = PropertyExpander.expandProperties(context, settings.getString(ProxySettings.PORT, ""));
                }
                Proxy proxy = new Proxy(Proxy.Type.HTTP, new InetSocketAddress(proxyHost, Integer.parseInt(proxyPort)));
                connection = versionUrl.openConnection(proxy);
            } else {
                connection = versionUrl.openConnection();
            }
            DocumentBuilderFactory dbf = DocumentBuilderFactory.newInstance();
            DocumentBuilder db = dbf.newDocumentBuilder();
            Document doc = db.parse(connection.getInputStream());
            doc.getDocumentElement().normalize();
            NodeList nodeLst = doc.getElementsByTagName("version");
            Node fstNode = nodeLst.item(0);
            if (fstNode.getNodeType() == 1) {
                Element fstElmnt = (Element)fstNode;
                NodeList vrsnNmbrElmntLst = fstElmnt.getElementsByTagName("version-number");
                Element vrsnNmbrElmnt = (Element)vrsnNmbrElmntLst.item(0);
                NodeList vrsnNmbr = vrsnNmbrElmnt.getChildNodes();
                this.latestVersion = vrsnNmbr.item(0).getNodeValue().toString();
                NodeList rlsNtsElmntLst = fstElmnt.getElementsByTagName("release-notes-core");
                Element rlsNtsElmnt = (Element)rlsNtsElmntLst.item(0);
                NodeList rlsNts = rlsNtsElmnt.getChildNodes();
                this.releaseNotesCore = rlsNts.item(0).getNodeValue().toString();
                NodeList rlsNtsElmntLstPro = fstElmnt.getElementsByTagName("release-notes-pro");
                Element rlsNtsElmntPro = (Element)rlsNtsElmntLstPro.item(0);
                NodeList rlsNtsPro = rlsNtsElmntPro.getChildNodes();
                this.releaseNotesPro = rlsNtsPro.item(0).getNodeValue().toString();
                NodeList coreDownloadNtsElmntLst = fstElmnt.getElementsByTagName("download-link-core");
                Element coreDownloadNtsElmnt = (Element)coreDownloadNtsElmntLst.item(0);
                NodeList coreDownloadNts = coreDownloadNtsElmnt.getChildNodes();
                this.downloadLinkCore = coreDownloadNts.item(0).getNodeValue().toString();
                NodeList proDownloadNtsElmntElmntLst = fstElmnt.getElementsByTagName("download-link-pro");
                Element proDownloadNtsElmnt = (Element)proDownloadNtsElmntElmntLst.item(0);
                NodeList proDownloadNts = proDownloadNtsElmnt.getChildNodes();
                this.downloadLinkPro = proDownloadNts.item(0).getNodeValue().toString();
            }
        }
        catch (Exception e) {
            SoapUI.logError(e, "Network Error for Version Update or Proxy");
            throw e;
        }
    }

    private static String versionUpdateUrl(String defaultUrl) {
        return System.getProperty(VERSION_UPDATE_URL_SYS_PROP_KEY, defaultUrl);
    }

    protected Document getVersionDocument(URL versionUrl) throws MalformedURLException, ParserConfigurationException, SAXException, IOException {
        DocumentBuilderFactory dbf = DocumentBuilderFactory.newInstance();
        DocumentBuilder db = dbf.newDocumentBuilder();
        Document doc = db.parse(versionUrl.openStream());
        return doc;
    }

    private boolean isNewReleaseAvailable() {
        String latestVersion;
        boolean isSnapshot;
        String currentSoapuiVersion = "4.5.1";
        int snapshotIndex = currentSoapuiVersion.indexOf("SNAPSHOT");
        boolean bl = isSnapshot = snapshotIndex > 0;
        if (isSnapshot) {
            currentSoapuiVersion = currentSoapuiVersion.substring(0, snapshotIndex - 1);
        }
        if (StringUtils.isNullOrEmpty(latestVersion = this.getLatestVersion())) {
            return false;
        }
        if (isSnapshot && currentSoapuiVersion.equals(latestVersion)) {
            return true;
        }
        return currentSoapuiVersion.compareTo(latestVersion) < 0;
    }

    protected String getReleaseNotes() {
        return this.getReleaseNotesCore();
    }

    public String getReleaseNotesCore() {
        return this.releaseNotesCore;
    }

    public String getReleaseNotesPro() {
        return this.releaseNotesPro;
    }

    public String getLatestVersion() {
        return this.latestVersion;
    }

    public void showNewVersionDownloadDialog() {
        JPanel versionUpdatePanel = new JPanel(new BorderLayout());
        JDialog dialog = new JDialog();
        versionUpdatePanel.add((Component)UISupport.buildDescription("New Version of soapUI is Available", "", null), "North");
        JEditorPane text = this.createReleaseNotesPane();
        JScrollPane scb = new JScrollPane(text);
        versionUpdatePanel.add((Component)scb, "Center");
        JPanel toolbar = this.buildToolbar(dialog);
        versionUpdatePanel.add((Component)toolbar, "South");
        dialog.setTitle("New Version Update");
        dialog.setModal(true);
        dialog.getContentPane().add(versionUpdatePanel);
        dialog.setSize(new Dimension(500, 640));
        UISupport.centerDialog(dialog, SoapUI.getFrame());
        dialog.setVisible(true);
    }

    protected JEditorPane createReleaseNotesPane() {
        JEditorPane text = new JEditorPane();
        try {
            text.setPage(this.getReleaseNotes());
            text.setEditable(false);
            text.setBorder(BorderFactory.createLineBorder(Color.black));
        }
        catch (IOException e) {
            text.setText(NO_RELEASE_NOTES_INFO);
            SoapUI.logError(e);
        }
        return text;
    }

    protected JPanel buildToolbar(JDialog dialog) {
        JPanel toolbarPanel = new JPanel(new BorderLayout());
        JPanel leftBtns = new JPanel();
        leftBtns.add(new JButton(new IgnoreUpdateAction(dialog)));
        leftBtns.add(new JButton(new RemindLaterAction(dialog)));
        JButton createToolbarButton = new JButton(new OpenDownloadUrlAction("Download latest version", this.getDownloadLinkCore(), dialog));
        JPanel rightBtn = new JPanel();
        rightBtn.add(createToolbarButton);
        toolbarPanel.add((Component)leftBtns, "West");
        toolbarPanel.add((Component)rightBtn, "East");
        return toolbarPanel;
    }

    public boolean skipThisVersion() {
        return SoapUI.getSettings().getString(VERSION_TO_SKIP, "").equals(this.getLatestVersion());
    }

    public void checkForNewVersion(boolean helpAction) {
        try {
            this.getLatestVersionAvailable(new URL(LATEST_VERSION_XML_LOCATION));
        }
        catch (Exception e) {
            SoapUI.log(e.getMessage());
            return;
        }
        if (this.isNewReleaseAvailable() && (!this.skipThisVersion() || helpAction)) {
            this.showNewVersionDownloadDialog();
        } else if (helpAction) {
            UISupport.showInfoMessage("You are running the latest version of soapUI!", "Version Check");
        }
    }

    protected String getDownloadLinkCore() {
        return this.downloadLinkCore;
    }

    protected String getDownloadLinkPro() {
        return this.downloadLinkPro;
    }

    public class OpenDownloadUrlAction
    extends AbstractAction {
        private final String url;
        private JDialog dialog;

        public OpenDownloadUrlAction(String title, String url, JDialog dialog) {
            super(title);
            this.url = url;
            this.dialog = dialog;
        }

        public void actionPerformed(ActionEvent e) {
            if (this.url == null) {
                UISupport.showErrorMessage("Missing url");
            } else {
                Tools.openURL(this.url);
            }
            this.dialog.setVisible(false);
        }
    }

    protected class RemindLaterAction
    extends AbstractAction {
        private JDialog dialog;

        public RemindLaterAction(JDialog dialog) {
            super("Remind Me Later");
            this.dialog = dialog;
        }

        public void actionPerformed(ActionEvent e) {
            this.dialog.setVisible(false);
        }
    }

    protected class IgnoreUpdateAction
    extends AbstractAction {
        private JDialog dialog;

        public IgnoreUpdateAction(JDialog dialog) {
            super("Ignore This Update");
            this.dialog = dialog;
        }

        public void actionPerformed(ActionEvent e) {
            SoapUI.getSettings().setString(VERSION_TO_SKIP, SoapUIVersionUpdate.this.getLatestVersion());
            this.dialog.setVisible(false);
        }
    }
}

