/*
 * Decompiled with CFR 0.152.
 */
package com.eviware.soapui.support.action.swing;

import com.eviware.soapui.model.ModelItem;
import com.eviware.soapui.support.action.SoapUIAction;
import com.eviware.soapui.support.action.swing.ActionComponentRegistry;
import com.eviware.soapui.support.action.swing.ActionList;
import com.eviware.soapui.support.action.swing.ActionListBuilder;
import com.eviware.soapui.support.action.swing.ActionSupport;
import com.eviware.soapui.support.action.swing.SoapUIActionMarker;
import com.eviware.soapui.support.actions.MarkerAction;
import com.eviware.soapui.support.components.JXToolBar;
import com.jgoodies.looks.HeaderStyle;
import java.util.HashMap;
import java.util.Map;
import javax.swing.Action;
import javax.swing.BorderFactory;
import javax.swing.JComponent;

public class JXSoapUIActionListToolBar
extends JXToolBar {
    private Map<String, Action> actionMap = new HashMap<String, Action>();

    public JXSoapUIActionListToolBar(ActionList actions, ModelItem modelItem) {
        this.addSpace(1);
        this.setRollover(true);
        this.putClientProperty("jgoodies.headerStyle", HeaderStyle.SINGLE);
        this.setBorder(BorderFactory.createEmptyBorder(3, 0, 3, 0));
        for (int i = 0; i < actions.getActionCount(); ++i) {
            Action action = actions.getActionAt(i);
            if (action instanceof MarkerAction) continue;
            if (action == ActionSupport.SEPARATOR_ACTION) {
                this.addSeparator();
                continue;
            }
            if (action instanceof ActionSupport.ActionListAction || action == null) continue;
            JComponent component = null;
            if (action instanceof SoapUIActionMarker) {
                SoapUIAction soapUIAction = ((SoapUIActionMarker)((Object)action)).getSoapUIAction();
                component = ActionComponentRegistry.buildActionComponent(soapUIAction, modelItem);
                this.actionMap.put(soapUIAction.getId(), action);
            }
            if (component != null) {
                this.add(component);
                continue;
            }
            this.add(action);
        }
    }

    public JXSoapUIActionListToolBar(ModelItem modelItem) {
        this(ActionListBuilder.buildActions(modelItem, "EditorToolbar"), modelItem);
    }

    public void setEnabled(String actionId, boolean enabled) {
        if (this.actionMap.containsKey(actionId)) {
            this.actionMap.get(actionId).setEnabled(enabled);
        }
    }
}

