/*
 * Decompiled with CFR 0.152.
 */
package com.eviware.soapui.support.components;

import com.eviware.soapui.SoapUI;
import com.eviware.soapui.impl.rest.panels.request.views.html.HttpHtmlResponseView;
import com.eviware.soapui.impl.rest.support.RestUtils;
import com.eviware.soapui.impl.support.panels.AbstractHttpXmlRequestDesktopPanel;
import com.eviware.soapui.impl.wsdl.support.http.ProxyUtils;
import com.eviware.soapui.impl.wsdl.testcase.WsdlTestCase;
import com.eviware.soapui.impl.wsdl.teststeps.HttpTestRequest;
import com.eviware.soapui.impl.wsdl.teststeps.HttpTestRequestStep;
import com.eviware.soapui.model.propertyexpansion.PropertyExpander;
import com.eviware.soapui.model.propertyexpansion.PropertyExpansionContext;
import com.eviware.soapui.model.settings.Settings;
import com.eviware.soapui.settings.ProxySettings;
import com.eviware.soapui.settings.WebRecordingSettings;
import com.eviware.soapui.support.StringUtils;
import com.eviware.soapui.support.Tools;
import com.eviware.soapui.support.UISupport;
import com.eviware.soapui.support.components.JXToolBar;
import com.eviware.soapui.support.types.StringList;
import com.eviware.soapui.support.types.StringToStringsMap;
import com.eviware.soapui.support.xml.XmlUtils;
import com.teamdev.jxbrowser.Browser;
import com.teamdev.jxbrowser.BrowserFactory;
import com.teamdev.jxbrowser.BrowserServices;
import com.teamdev.jxbrowser.BrowserType;
import com.teamdev.jxbrowser.Configurable;
import com.teamdev.jxbrowser.Feature;
import com.teamdev.jxbrowser.NewWindowContainer;
import com.teamdev.jxbrowser.NewWindowManager;
import com.teamdev.jxbrowser.NewWindowParams;
import com.teamdev.jxbrowser.cookie.HttpCookieStorage;
import com.teamdev.jxbrowser.events.NavigationAdapter;
import com.teamdev.jxbrowser.events.NavigationEvent;
import com.teamdev.jxbrowser.events.NavigationFinishedEvent;
import com.teamdev.jxbrowser.events.NavigationListener;
import com.teamdev.jxbrowser.events.NavigationStatusCode;
import com.teamdev.jxbrowser.events.StatusChangedEvent;
import com.teamdev.jxbrowser.events.StatusListener;
import com.teamdev.jxbrowser.gecko.xpcom.XPCOM;
import com.teamdev.jxbrowser.gecko.xpcom.XPCOMManager;
import com.teamdev.jxbrowser.mozilla.MozillaBrowser;
import com.teamdev.jxbrowser.mozilla.MozillaCookieStorage;
import com.teamdev.jxbrowser.prompt.DefaultPromptService;
import com.teamdev.jxbrowser.prompt.PromptService;
import com.teamdev.jxbrowser.proxy.AuthenticationHandler;
import com.teamdev.jxbrowser.proxy.ProxyConfig;
import com.teamdev.jxbrowser.proxy.ProxyServer;
import com.teamdev.jxbrowser.proxy.ProxyServerLogin;
import com.teamdev.jxbrowser.proxy.ServerType;
import com.teamdev.jxbrowser.security.HttpSecurityAction;
import com.teamdev.jxbrowser.security.HttpSecurityHandler;
import com.teamdev.jxbrowser.security.SecurityProblem;
import java.awt.BorderLayout;
import java.awt.Component;
import java.awt.Dimension;
import java.awt.Toolkit;
import java.awt.event.ActionEvent;
import java.beans.PropertyChangeListener;
import java.beans.PropertyChangeSupport;
import java.lang.reflect.InvocationTargetException;
import java.net.MalformedURLException;
import java.net.URL;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.Map;
import java.util.Set;
import javax.swing.AbstractAction;
import javax.swing.JEditorPane;
import javax.swing.JLabel;
import javax.swing.JPanel;
import org.mozilla.interfaces.nsIBinaryInputStream;
import org.mozilla.interfaces.nsIDOMWindow;
import org.mozilla.interfaces.nsIHttpChannel;
import org.mozilla.interfaces.nsIHttpHeaderVisitor;
import org.mozilla.interfaces.nsIInputStream;
import org.mozilla.interfaces.nsIInterfaceRequestor;
import org.mozilla.interfaces.nsIObserver;
import org.mozilla.interfaces.nsIObserverService;
import org.mozilla.interfaces.nsIRequest;
import org.mozilla.interfaces.nsISeekableStream;
import org.mozilla.interfaces.nsIServiceManager;
import org.mozilla.interfaces.nsISupports;
import org.mozilla.interfaces.nsIURI;
import org.mozilla.interfaces.nsIUploadChannel;
import org.mozilla.interfaces.nsIWeakReference;
import org.mozilla.interfaces.nsIWebProgress;
import org.mozilla.interfaces.nsIWebProgressListener;
import org.mozilla.xpcom.Mozilla;
import org.mozilla.xpcom.XPCOMException;

public class BrowserComponent
implements nsIWebProgressListener,
nsIWeakReference,
StatusListener {
    private static final String CONTENT_TYPE_FORM_URLENCODED = "application/x-www-form-urlencoded";
    private MozillaBrowser browser;
    private JPanel panel = new JPanel(new BorderLayout());
    private JPanel statusBar;
    private JLabel statusLabel;
    private String errorPage;
    private boolean showingErrorPage;
    public String url;
    private Boolean possibleError = false;
    private boolean disposed;
    private NavigationListener internalNavigationListener;
    private HttpHtmlResponseView httpHtmlResponseView;
    private static SoapUINewWindowManager newWindowManager;
    private static Map<nsIDOMWindow, BrowserComponent> browserMap;
    private static Map<BrowserComponent, Map<String, RecordedRequest>> browserRecordingMap;
    private static Object recordingHttpListener;
    private final boolean addStatusBar;
    private static boolean proxyAuthenticationInitialized;
    private PropertyChangeSupport pcs = new PropertyChangeSupport(this);
    public static final String EVENT_HTTP_ON_MODIFY_REQUEST = "http-on-modify-request";
    private InternalHttpSecurityHandler internalHttpSecurityHandler;
    private InternalNavigationAdapter internalNavigationAdapter;

    public BrowserComponent(boolean addToolbar, boolean addStatusBar) {
        this.addStatusBar = addStatusBar;
    }

    public Component getComponent() {
        if (SoapUI.isJXBrowserDisabled()) {
            JEditorPane jxbrowserDisabledPanel = new JEditorPane();
            jxbrowserDisabledPanel.setText("Browser Component disabled or not available on this platform");
            this.panel.add(jxbrowserDisabledPanel);
        } else if (this.browser == null) {
            if (this.addStatusBar) {
                this.statusBar = new JPanel(new BorderLayout());
                this.statusLabel = new JLabel();
                UISupport.setFixedSize(this.statusBar, new Dimension(20, 20));
                this.statusBar.add((Component)this.statusLabel, "West");
                this.panel.add((Component)this.statusBar, "South");
            }
            if (!this.initBrowser()) {
                return this.panel;
            }
            this.configureBrowser();
            this.browser.navigate("about:blank");
        }
        return this.panel;
    }

    private Component buildToolbar() {
        JXToolBar toolbar = UISupport.createToolbar();
        toolbar.addFixed(UISupport.createToolbarButton(new BackAction()));
        toolbar.addRelatedGap();
        toolbar.addFixed(UISupport.createToolbarButton(new ForwardAction()));
        toolbar.addGlue();
        return toolbar;
    }

    public void setRecordingHttpHtmlResponseView(HttpHtmlResponseView httpHtmlResponseView) {
        this.httpHtmlResponseView = httpHtmlResponseView;
        if (httpHtmlResponseView != null) {
            if (!browserRecordingMap.containsKey(this)) {
                browserRecordingMap.put(this, new HashMap());
            }
            HttpCookieStorage cookies = MozillaCookieStorage.getInstance((BrowserType)BrowserType.Mozilla);
            cookies.deleteCookie(cookies.getCookies());
        } else {
            browserRecordingMap.remove(this);
        }
    }

    public static boolean isHeaderExcluded(String header) {
        String excluded = SoapUI.getSettings().getString(WebRecordingSettings.EXCLUDED_HEADERS, null);
        ArrayList<String> result = new ArrayList<String>();
        if (excluded != null && excluded.trim().length() > 0) {
            try {
                StringList names = StringList.fromXml(excluded);
                for (String name : names) {
                    result.add(name);
                }
            }
            catch (Exception e) {
                SoapUI.logError(e);
            }
        }
        return result.contains(header);
    }

    private static String getContentType(byte[] requestData) {
        String request = new String(requestData);
        int ix = request.indexOf("Content-Type");
        if (ix >= 0 && ix < request.length() - 14) {
            String contentType = request.substring(ix + 14);
            contentType = contentType.substring(0, contentType.indexOf("\n") - 1);
            return contentType.trim();
        }
        return null;
    }

    private static String getRequestBody(byte[] requestData) {
        String request = new String(requestData);
        int ix = request.indexOf("\r\n\r\n");
        return ix == -1 ? "" : request.substring(ix + 4);
    }

    public synchronized boolean initBrowser() {
        if (this.browser != null || SoapUI.isJXBrowserDisabled()) {
            return false;
        }
        try {
            this.browser = (MozillaBrowser)BrowserFactory.createBrowser((BrowserType)BrowserType.Mozilla);
            browserMap.put(this.browser.getPeer().getNsIWebBrowser().getContentDOMWindow(), this);
            BrowserComponent.initNewWindowManager((Browser)this.browser, true);
            this.internalHttpSecurityHandler = new InternalHttpSecurityHandler();
            this.browser.setHttpSecurityHandler((HttpSecurityHandler)this.internalHttpSecurityHandler);
            this.internalNavigationListener = new InternalBrowserNavigationListener();
            this.browser.addNavigationListener(this.internalNavigationListener);
            this.browser.addStatusListener((StatusListener)this);
            this.internalNavigationAdapter = new InternalNavigationAdapter();
            this.browser.addNavigationListener((NavigationListener)this.internalNavigationAdapter);
            this.panel.add(this.browser.getComponent(), "Center");
            return true;
        }
        catch (Throwable t) {
            SoapUI.logError(t);
            return false;
        }
    }

    public static void initNewWindowManager(Browser browser, boolean forRecording) {
        if (newWindowManager == null) {
            newWindowManager = new SoapUINewWindowManager();
            browser.getServices().setNewWindowManager((NewWindowManager)newWindowManager);
            browser.getServices().setPromptService((PromptService)new DefaultPromptService());
        }
        if (forRecording && recordingHttpListener == null) {
            BrowserComponent.registerHttpListener();
        }
    }

    protected void replaceBrowser(Browser browser2) {
        browserMap.remove(this.browser.getPeer().getNsIWebBrowser().getContentDOMWindow());
        this.browser.stop();
        this.browser.removeNavigationListener(this.internalNavigationListener);
        this.browser.removeStatusListener((StatusListener)this);
        this.panel.remove(this.browser.getComponent());
        this.browser.dispose();
        this.browser = (MozillaBrowser)browser2;
        browserMap.put(this.browser.getPeer().getNsIWebBrowser().getContentDOMWindow(), this);
        this.browser.addNavigationListener(this.internalNavigationListener);
        this.browser.addStatusListener((StatusListener)this);
        this.panel.add(this.browser.getComponent(), "Center");
    }

    public void release() {
        if (this.browser != null) {
            this.disposed = true;
            this.cleanup();
        }
        this.possibleError = false;
    }

    private synchronized void cleanup() {
        if (this.browser != null) {
            browserMap.remove(this.browser.getPeer().getNsIWebBrowser().getContentDOMWindow());
            browserRecordingMap.remove(this);
            this.httpHtmlResponseView = null;
            this.browser.stop();
            this.browser.dispose();
            this.browser.removeNavigationListener(this.internalNavigationListener);
            this.browser.removeNavigationListener((NavigationListener)this.internalNavigationAdapter);
            this.browser.setHttpSecurityHandler(null);
            this.browser.removeStatusListener((StatusListener)this);
            this.panel.removeAll();
            this.browser = null;
        }
    }

    private void configureBrowser() {
        if (this.browser != null) {
            Configurable contentSettings = this.browser.getConfigurable();
            if (SoapUI.isJXBrowserPluginsDisabled()) {
                contentSettings.disableFeature(Feature.PLUGINS);
            } else {
                contentSettings.enableFeature(Feature.PLUGINS);
            }
        }
    }

    public void setContent(String contentAsString, String contextUri) {
        if (SoapUI.isJXBrowserDisabled()) {
            return;
        }
        if (this.browser == null && !this.initBrowser()) {
            return;
        }
        this.configureBrowser();
        try {
            this.browser.setContent(contentAsString, contextUri);
            this.pcs.firePropertyChange("content", null, null);
        }
        catch (Throwable e) {
            e.printStackTrace();
        }
    }

    public void setContent(String content) {
        if (SoapUI.isJXBrowserDisabled()) {
            return;
        }
        if (this.browser == null && !this.initBrowser()) {
            return;
        }
        this.configureBrowser();
        this.browser.setContent(content);
        this.pcs.firePropertyChange("content", null, null);
    }

    public void navigate(String url, String errorPage) {
        this.navigate(url, null, errorPage);
    }

    public String getContent() {
        return this.browser == null ? null : XmlUtils.serialize(this.browser.getDocument());
    }

    public String getUrl() {
        return this.url;
    }

    public void setUrl(String url) throws InterruptedException, InvocationTargetException {
        this.navigate(url, null);
    }

    public nsISupports queryInterface(String uuid) {
        return Mozilla.queryInterface((nsISupports)this, (String)uuid);
    }

    public nsISupports queryReferent(String uuid) {
        return Mozilla.queryInterface((nsISupports)this, (String)uuid);
    }

    public void onLocationChange(nsIWebProgress arg0, nsIRequest arg1, nsIURI arg2) {
        if (this.getUrl() != null && !this.getUrl().equals("about:blank")) {
            if (!this.possibleError.booleanValue()) {
                this.possibleError = true;
            } else if (!this.showingErrorPage) {
                this.showErrorPage();
            }
        }
    }

    public void onProgressChange(nsIWebProgress arg0, nsIRequest arg1, int arg2, int arg3, int arg4, int arg5) {
    }

    public void onSecurityChange(nsIWebProgress arg0, nsIRequest arg1, long arg2) {
    }

    public void onStateChange(nsIWebProgress arg0, nsIRequest request, long arg2, long arg3) {
        block4: {
            try {
                if (this.getUrl() != null && !this.getUrl().equals("about:blank")) {
                    nsIHttpChannel ch = null;
                    ch = (nsIHttpChannel)request.queryInterface("{9277fe09-f0cc-4cd9-bbce-581dd94b0260}");
                    if (ch != null) {
                        this.possibleError = false;
                        this.showingErrorPage = false;
                    }
                }
            }
            catch (XPCOMException e) {
                if (!this.possibleError.booleanValue() || this.showingErrorPage) break block4;
                this.showErrorPage();
            }
        }
    }

    private void showErrorPage() {
        if (this.errorPage != null && !this.errorPage.equals(this.getUrl())) {
            try {
                this.showingErrorPage = true;
                this.setUrl(this.errorPage);
            }
            catch (Throwable e) {
                e.printStackTrace();
            }
        }
    }

    public String getErrorPage() {
        return this.errorPage;
    }

    public void setErrorPage(String errorPage) {
        this.errorPage = errorPage;
    }

    public void onStatusChange(nsIWebProgress arg0, nsIRequest arg1, long arg2, String arg3) {
        block4: {
            try {
                if (this.getUrl() != null && !this.getUrl().equals("about:blank")) {
                    nsIHttpChannel ch = null;
                    ch = (nsIHttpChannel)arg1.queryInterface("{9277fe09-f0cc-4cd9-bbce-581dd94b0260}");
                    if (ch != null) {
                        this.possibleError = false;
                        this.showingErrorPage = false;
                    }
                }
            }
            catch (XPCOMException e) {
                if (!this.possibleError.booleanValue() || this.showingErrorPage) break block4;
                this.showErrorPage();
            }
        }
    }

    public void statusChanged(StatusChangedEvent event) {
        if (this.statusLabel != null) {
            this.statusLabel.setText(event.getStatusText());
        }
    }

    public boolean isBrowserInitialised() {
        return this.browser != null;
    }

    public static void updateJXBrowserProxy() {
        ProxyConfig proxyConf = BrowserServices.getInstance().getProxyConfig();
        if (proxyConf == null) {
            return;
        }
        try {
            proxyConf.setAutoDetectForNetwork(false);
            if (!proxyAuthenticationInitialized) {
                proxyConf.setAuthenticationHandler(ServerType.HTTP, new AuthenticationHandler(){

                    public ProxyServerLogin authenticationRequired(ServerType arg0) {
                        Settings settings = SoapUI.getSettings();
                        PropertyExpansionContext context = null;
                        String proxyUsername = PropertyExpander.expandProperties(context, settings.getString(ProxySettings.USERNAME, null));
                        String proxyPassword = PropertyExpander.expandProperties(context, settings.getString(ProxySettings.PASSWORD, null));
                        return new ProxyServerLogin(proxyUsername, proxyPassword);
                    }
                });
                proxyAuthenticationInitialized = true;
            }
            if (ProxyUtils.isProxyEnabled()) {
                Settings settings = SoapUI.getSettings();
                PropertyExpansionContext context = null;
                String proxyHost = System.getProperty("http.proxyHost");
                String proxyPort = System.getProperty("http.proxyPort");
                if (proxyHost == null) {
                    proxyHost = PropertyExpander.expandProperties(context, settings.getString(ProxySettings.HOST, ""));
                }
                if (proxyPort == null) {
                    proxyPort = PropertyExpander.expandProperties(context, settings.getString(ProxySettings.PORT, ""));
                }
                proxyConf.setProxy(ServerType.HTTP, new ProxyServer(proxyHost, Integer.parseInt(proxyPort)));
                proxyConf.setExceptions(PropertyExpander.expandProperties(context, settings.getString(ProxySettings.EXCLUDES, "")));
            } else {
                proxyConf.setDirectConnection();
            }
        }
        catch (Throwable throwable) {
            // empty catch block
        }
    }

    public void addPropertyChangeListener(PropertyChangeListener pcl) {
        this.pcs.addPropertyChangeListener(pcl);
    }

    public void rempvePropertyChangeListener(PropertyChangeListener pcl) {
        this.pcs.removePropertyChangeListener(pcl);
    }

    public static void registerHttpListener() {
        XPCOM.invokeLater((Runnable)new RecordingHttpListener());
    }

    public static String dumpUri(nsIURI uri) {
        if (uri == null) {
            return "";
        }
        return (uri.getUsername() == null || "".equals(uri.getUsername()) ? "" : uri.getUsername() + ":" + uri.getUserPass()) + uri.getScheme() + "://" + uri.getHost() + (uri.getPort() == -1 ? "" : ":" + uri.getPort()) + uri.getPath();
    }

    public void navigate(String url, String postData, String errorPage) {
        if (SoapUI.isJXBrowserDisabled()) {
            return;
        }
        if (errorPage != null) {
            this.setErrorPage(errorPage);
        }
        this.url = url;
        if (this.browser == null && !this.initBrowser()) {
            return;
        }
        this.configureBrowser();
        BrowserComponent.updateJXBrowserProxy();
        if (postData != null && postData.length() > 0) {
            this.browser.navigate(url, postData);
        } else {
            this.browser.navigate(url);
        }
        if (this.showingErrorPage) {
            this.showingErrorPage = false;
        }
    }

    static {
        browserMap = new HashMap<nsIDOMWindow, BrowserComponent>();
        browserRecordingMap = new HashMap<BrowserComponent, Map<String, RecordedRequest>>();
        proxyAuthenticationInitialized = false;
    }

    private static class RecordedRequest {
        private String url;
        private String contentType;
        private StringToStringsMap headers;
        private String method;
        private String content;

        public RecordedRequest(String url, String method) {
            this.url = url;
            this.method = method;
        }

        public void setContentType(String contentType) {
            this.contentType = contentType;
        }

        public void setHeaders(StringToStringsMap headersMap) {
            this.headers = headersMap;
        }

        public void setContent(String requestBody) {
            this.content = requestBody;
        }

        public String getUrl() {
            return this.url;
        }

        public String getContentType() {
            return this.contentType;
        }

        public StringToStringsMap getHeaders() {
            return this.headers;
        }

        public String getMethod() {
            return this.method;
        }

        public String getContent() {
            return this.content;
        }
    }

    private class ForwardAction
    extends AbstractAction {
        public ForwardAction() {
            this.putValue("SmallIcon", UISupport.createImageIcon("/arrow_right.png"));
            this.putValue("ShortDescription", "Navigate to next selection");
        }

        public void actionPerformed(ActionEvent e) {
            if (!BrowserComponent.this.browser.canGoForward()) {
                Toolkit.getDefaultToolkit().beep();
            } else {
                BrowserComponent.this.browser.goForward();
            }
        }
    }

    private class BackAction
    extends AbstractAction {
        public BackAction() {
            this.putValue("SmallIcon", UISupport.createImageIcon("/arrow_left.png"));
            this.putValue("ShortDescription", "Navigate to previous selection");
        }

        public void actionPerformed(ActionEvent e) {
            if (!BrowserComponent.this.browser.canGoBack()) {
                Toolkit.getDefaultToolkit().beep();
            } else {
                BrowserComponent.this.browser.goBack();
            }
        }
    }

    private final class InternalBrowserNavigationListener
    implements NavigationListener {
        private InternalBrowserNavigationListener() {
        }

        public void navigationStarted(NavigationEvent arg0) {
        }

        public void navigationFinished(NavigationFinishedEvent arg0) {
            Map map;
            RecordedRequest recordedRequest;
            if (browserRecordingMap.containsKey(BrowserComponent.this) && (recordedRequest = (RecordedRequest)(map = (Map)browserRecordingMap.get(BrowserComponent.this)).get(arg0.getUrl())) != null && BrowserComponent.this.httpHtmlResponseView != null && BrowserComponent.this.httpHtmlResponseView.isRecordHttpTrafic()) {
                HttpTestRequest httpTestRequest = (HttpTestRequest)((AbstractHttpXmlRequestDesktopPanel.HttpResponseDocument)BrowserComponent.this.httpHtmlResponseView.getDocument()).getRequest();
                WsdlTestCase testCase = httpTestRequest.getTestStep().getTestCase();
                int count = testCase.getTestStepList().size();
                String url2 = recordedRequest.getUrl();
                try {
                    url2 = new URL(recordedRequest.getUrl()).getPath();
                }
                catch (MalformedURLException e) {
                    // empty catch block
                }
                HttpTestRequestStep newHttpStep = (HttpTestRequestStep)testCase.addTestStep("httprequest", "Http Test Step " + ++count + " [" + url2 + "]", recordedRequest.getUrl(), recordedRequest.getMethod());
                newHttpStep.getTestRequest().setRequestHeaders(recordedRequest.getHeaders());
                if (recordedRequest.getContent() != null) {
                    newHttpStep.getTestRequest().setMediaType(recordedRequest.getContentType());
                    if (newHttpStep.getTestRequest().getMediaType().equals(BrowserComponent.CONTENT_TYPE_FORM_URLENCODED)) {
                        newHttpStep.getTestRequest().setPostQueryString(true);
                        newHttpStep.getTestRequest().setMediaType(BrowserComponent.CONTENT_TYPE_FORM_URLENCODED);
                        RestUtils.extractParamsFromQueryString(newHttpStep.getTestRequest().getParams(), recordedRequest.getContent());
                    } else {
                        newHttpStep.getTestRequest().setRequestContent(recordedRequest.getContent());
                    }
                }
            }
        }
    }

    private static final class SoapUINewWindowManager
    implements NewWindowManager {
        private SoapUINewWindowManager() {
        }

        public NewWindowContainer evaluateWindow(final NewWindowParams params) {
            return new NewWindowContainer(){

                public void insertBrowser(Browser browser) {
                    browser.addNavigationListener(new NavigationListener(){

                        public void navigationStarted(NavigationEvent arg0) {
                            arg0.getBrowser().removeNavigationListener((NavigationListener)this);
                            BrowserComponent browserComponent = null;
                            if (params.getParent() instanceof MozillaBrowser) {
                                browserComponent = (BrowserComponent)browserMap.get(((MozillaBrowser)params.getParent()).getPeer().getNsIWebBrowser().getContentDOMWindow());
                                if (browserRecordingMap.containsKey(browserComponent)) {
                                    browserComponent.replaceBrowser(arg0.getBrowser());
                                } else {
                                    browserComponent = null;
                                }
                            }
                            if (browserComponent == null) {
                                Tools.openURL(arg0.getUrl());
                            }
                        }

                        public void navigationFinished(NavigationFinishedEvent arg0) {
                        }
                    });
                }
            };
        }
    }

    private static final class RecordingHttpListener
    implements Runnable {
        private RecordingHttpListener() {
        }

        public void run() {
            recordingHttpListener = this;
            final Mozilla mozilla = Mozilla.getInstance();
            nsIServiceManager serviceManager = mozilla.getServiceManager();
            nsIObserverService observerService = (nsIObserverService)serviceManager.getServiceByContractID("@mozilla.org/observer-service;1", "{d07f5192-e3d1-11d2-8acd-00105a1b8860}");
            final nsIBinaryInputStream in = (nsIBinaryInputStream)XPCOMManager.getInstance().newComponent("@mozilla.org/binaryinputstream;1", nsIBinaryInputStream.class);
            nsIObserver httpObserver = new nsIObserver(){

                /*
                 * WARNING - Removed try catching itself - possible behaviour change.
                 * Enabled aggressive block sorting
                 * Enabled unnecessary exception pruning
                 * Enabled aggressive exception aggregation
                 */
                public void observe(nsISupports subject, String sTopic, String sData) {
                    try {
                        RecordedRequest rr;
                        BrowserComponent browserComponent;
                        nsIHttpChannel httpChannel;
                        block14: {
                            nsIInputStream uploadStream;
                            if (!BrowserComponent.EVENT_HTTP_ON_MODIFY_REQUEST.equals(sTopic)) {
                                System.out.println("HTTPObserver: Unknown event '" + sTopic + "'");
                                return;
                            }
                            httpChannel = (nsIHttpChannel)subject.queryInterface("{9277fe09-f0cc-4cd9-bbce-581dd94b0260}");
                            if (httpChannel.getNotificationCallbacks() == null) {
                                return;
                            }
                            nsIInterfaceRequestor interfaceRequestor = (nsIInterfaceRequestor)httpChannel.getNotificationCallbacks().queryInterface("{033a1470-8b2a-11d3-af88-00a024ffc08c}");
                            nsIDOMWindow window = (nsIDOMWindow)interfaceRequestor.getInterface("{a6cf906b-15b3-11d2-932e-00805f8add32}");
                            browserComponent = (BrowserComponent)browserMap.get(window);
                            if (browserComponent == null) return;
                            if (!browserRecordingMap.containsKey(browserComponent)) return;
                            rr = new RecordedRequest(BrowserComponent.dumpUri(httpChannel.getURI()), httpChannel.getRequestMethod());
                            nsIUploadChannel upload = (nsIUploadChannel)httpChannel.queryInterface("{ddf633d8-e9a4-439d-ad88-de636fd9bb75}");
                            byte[] requestData = null;
                            if (upload != null && (uploadStream = upload.getUploadStream()) != null && uploadStream.available() > 0L) {
                                nsISeekableStream seekable = (nsISeekableStream)uploadStream.queryInterface("{8429d350-1040-4661-8b71-f2a6ba455980}");
                                long pos = seekable.tell();
                                long available = uploadStream.available();
                                if (available > 0L) {
                                    try {
                                        try {
                                            Mozilla mozilla2 = mozilla;
                                            synchronized (mozilla2) {
                                                in.setInputStream(uploadStream);
                                                requestData = in.readByteArray(available);
                                                String requestBody = BrowserComponent.getRequestBody(requestData);
                                                if (requestBody != null && requestBody.length() > 0) {
                                                    rr.setContent(requestBody);
                                                    String contentType = BrowserComponent.getContentType(requestData);
                                                    if (StringUtils.hasContent(contentType)) {
                                                        rr.setContentType(contentType);
                                                    }
                                                }
                                            }
                                        }
                                        catch (Throwable e) {
                                            e.printStackTrace();
                                            Object var22_21 = null;
                                            seekable.seek(0, pos);
                                            break block14;
                                        }
                                        Object var22_20 = null;
                                    }
                                    catch (Throwable throwable) {
                                        Object var22_22 = null;
                                        seekable.seek(0, pos);
                                        throw throwable;
                                    }
                                    seekable.seek(0, pos);
                                }
                            }
                        }
                        final StringToStringsMap headersMap = new StringToStringsMap();
                        httpChannel.visitRequestHeaders(new nsIHttpHeaderVisitor(){

                            public void visitHeader(String header, String value) {
                                if (!BrowserComponent.isHeaderExcluded(header)) {
                                    headersMap.put(header, value);
                                }
                            }

                            public nsISupports queryInterface(String sIID) {
                                return Mozilla.queryInterface((nsISupports)this, (String)sIID);
                            }
                        });
                        rr.setHeaders(headersMap);
                        ((Map)browserRecordingMap.get(browserComponent)).put(rr.getUrl(), rr);
                        return;
                    }
                    catch (Throwable e) {
                        if (e.getMessage().indexOf("0x80004002") != -1) return;
                        SoapUI.logError(e);
                    }
                }

                public nsISupports queryInterface(String sIID) {
                    return Mozilla.queryInterface((nsISupports)this, (String)sIID);
                }
            };
            boolean blnObserverIsWeakReference = false;
            observerService.addObserver(httpObserver, BrowserComponent.EVENT_HTTP_ON_MODIFY_REQUEST, blnObserverIsWeakReference);
        }
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    private final class InternalHttpSecurityHandler
    implements HttpSecurityHandler {
        private InternalHttpSecurityHandler() {
        }

        public HttpSecurityAction onSecurityProblem(Set<SecurityProblem> arg0) {
            return HttpSecurityAction.CONTINUE;
        }
    }

    private final class InternalNavigationAdapter
    extends NavigationAdapter {
        private InternalNavigationAdapter() {
        }

        public void navigationFinished(NavigationFinishedEvent evt) {
            if (evt.getUrl().equals(SoapUI.PUSH_PAGE_URL) && !evt.getStatusCode().equals((Object)NavigationStatusCode.OK)) {
                BrowserComponent.this.browser.navigate(SoapUI.PUSH_PAGE_ERROR_URL);
            }
        }
    }
}

