/*
 * Decompiled with CFR 0.152.
 */
package com.eviware.soapui.support.components;

import com.eviware.soapui.support.UISupport;
import com.eviware.soapui.support.components.Undoable;
import java.awt.Dimension;
import java.awt.Toolkit;
import java.awt.event.FocusEvent;
import java.awt.event.FocusListener;
import java.awt.event.KeyAdapter;
import java.awt.event.KeyEvent;
import javax.swing.JFormattedTextField;
import javax.swing.KeyStroke;
import javax.swing.event.UndoableEditEvent;
import javax.swing.event.UndoableEditListener;
import javax.swing.undo.CannotRedoException;
import javax.swing.undo.CannotUndoException;
import javax.swing.undo.UndoManager;

public class JUndoableFormattedTextField
extends JFormattedTextField
implements Undoable,
UndoableEditListener,
FocusListener {
    public static final int UNDO_LIMIT = 100;
    private UndoManager undoManager;
    private boolean discardEditsOnSet = false;

    public JUndoableFormattedTextField() {
        this.init();
    }

    private void init() {
        this.getDocument().addUndoableEditListener(this);
        this.addFocusListener(this);
        this.setMinimumSize(new Dimension(50, 50));
        this.addKeyListener(new KeyAdapter(){

            public void keyPressed(KeyEvent e) {
                if (KeyStroke.getKeyStrokeForEvent(e).equals(UISupport.getKeyStroke("menu Z"))) {
                    JUndoableFormattedTextField.this.undo();
                } else if (KeyStroke.getKeyStrokeForEvent(e).equals(UISupport.getKeyStroke("menu Y"))) {
                    JUndoableFormattedTextField.this.redo();
                } else if (KeyStroke.getKeyStrokeForEvent(e).equals(UISupport.getKeyStroke("menu X"))) {
                    JUndoableFormattedTextField.this.cut();
                } else if (KeyStroke.getKeyStrokeForEvent(e).equals(UISupport.getKeyStroke("menu C"))) {
                    JUndoableFormattedTextField.this.copy();
                } else if (KeyStroke.getKeyStrokeForEvent(e).equals(UISupport.getKeyStroke("menu V"))) {
                    JUndoableFormattedTextField.this.paste();
                } else {
                    return;
                }
                e.consume();
            }
        });
    }

    public JUndoableFormattedTextField(String text) {
        super((Object)text);
        this.init();
    }

    public JUndoableFormattedTextField(int columns) {
        super((Object)columns);
        this.init();
    }

    public JUndoableFormattedTextField(JFormattedTextField.AbstractFormatter formatter) {
        super(formatter);
        this.init();
    }

    public void setText(String text) {
        this.ensureUndoManager();
        super.setText(text == null ? "" : text);
        if (this.discardEditsOnSet && this.undoManager != null) {
            this.undoManager.discardAllEdits();
        }
    }

    public boolean isDiscardEditsOnSet() {
        return this.discardEditsOnSet;
    }

    public void setDiscardEditsOnSet(boolean discardEditsOnSet) {
        this.discardEditsOnSet = discardEditsOnSet;
    }

    public UndoManager getUndoManager() {
        return this.undoManager;
    }

    private void ensureUndoManager() {
        if (this.isEditable() && this.undoManager == null) {
            this.undoManager = new UndoManager();
            this.undoManager.setLimit(100);
        }
    }

    public void focusGained(FocusEvent fe) {
        this.ensureUndoManager();
    }

    public void focusLost(FocusEvent fe) {
    }

    public void undoableEditHappened(UndoableEditEvent e) {
        if (this.undoManager != null) {
            this.undoManager.addEdit(e.getEdit());
        }
    }

    public void undo() {
        if (!this.isEditable()) {
            this.getToolkit().beep();
            return;
        }
        try {
            if (this.undoManager != null) {
                this.undoManager.undo();
            }
        }
        catch (CannotUndoException cue) {
            Toolkit.getDefaultToolkit().beep();
        }
    }

    public void redo() {
        if (!this.isEditable()) {
            this.getToolkit().beep();
            return;
        }
        try {
            if (this.undoManager != null) {
                this.undoManager.redo();
            }
        }
        catch (CannotRedoException cue) {
            Toolkit.getDefaultToolkit().beep();
        }
    }

    public void setSelectedText(String txt) {
        this.replaceSelection(txt);
    }

    public boolean canRedo() {
        return this.undoManager != null && this.undoManager.canRedo();
    }

    public boolean canUndo() {
        return this.undoManager != null && this.undoManager.canUndo();
    }
}

