/*
 * Decompiled with CFR 0.152.
 */
package com.eviware.soapui.support.dnd;

import com.eviware.soapui.SoapUI;
import com.eviware.soapui.model.ModelItem;
import com.eviware.soapui.support.dnd.ModelItemDropHandler;
import com.eviware.soapui.support.dnd.ModelItemTransferable;
import com.eviware.soapui.support.dnd.SoapUIDragAndDropable;
import com.eviware.soapui.support.dnd.handlers.InterfaceToProjectDropHandler;
import com.eviware.soapui.support.dnd.handlers.MockResponseToTestCaseDropHandler;
import com.eviware.soapui.support.dnd.handlers.MockResponseToTestStepDropHandler;
import com.eviware.soapui.support.dnd.handlers.MockResponseToTestStepsDropHandler;
import com.eviware.soapui.support.dnd.handlers.MockServiceToProjectDropHandler;
import com.eviware.soapui.support.dnd.handlers.OperationToMockServiceDropHandler;
import com.eviware.soapui.support.dnd.handlers.RequestToMockOperationDropHandler;
import com.eviware.soapui.support.dnd.handlers.RequestToTestCaseDropHandler;
import com.eviware.soapui.support.dnd.handlers.RequestToTestStepDropHandler;
import com.eviware.soapui.support.dnd.handlers.RequestToTestStepsDropHandler;
import com.eviware.soapui.support.dnd.handlers.TestCaseToProjectDropHandler;
import com.eviware.soapui.support.dnd.handlers.TestCaseToTestCaseDropHandler;
import com.eviware.soapui.support.dnd.handlers.TestCaseToTestSuiteDropHandler;
import com.eviware.soapui.support.dnd.handlers.TestStepToTestCaseDropHandler;
import com.eviware.soapui.support.dnd.handlers.TestStepToTestStepDropHandler;
import com.eviware.soapui.support.dnd.handlers.TestStepToTestStepsDropHandler;
import com.eviware.soapui.support.dnd.handlers.TestSuiteToProjectDropHandler;
import com.eviware.soapui.support.dnd.handlers.TestSuiteToTestSuiteDropHandler;
import java.awt.AlphaComposite;
import java.awt.Color;
import java.awt.Component;
import java.awt.GradientPaint;
import java.awt.Graphics2D;
import java.awt.Point;
import java.awt.Rectangle;
import java.awt.SystemColor;
import java.awt.datatransfer.DataFlavor;
import java.awt.datatransfer.Transferable;
import java.awt.dnd.DragGestureEvent;
import java.awt.dnd.DragGestureListener;
import java.awt.dnd.DragSource;
import java.awt.dnd.DragSourceDragEvent;
import java.awt.dnd.DragSourceDropEvent;
import java.awt.dnd.DragSourceEvent;
import java.awt.dnd.DragSourceListener;
import java.awt.dnd.DropTarget;
import java.awt.dnd.DropTargetDragEvent;
import java.awt.dnd.DropTargetDropEvent;
import java.awt.dnd.DropTargetEvent;
import java.awt.dnd.DropTargetListener;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.awt.event.MouseEvent;
import java.awt.geom.AffineTransform;
import java.awt.geom.Rectangle2D;
import java.awt.image.BufferedImage;
import java.util.ArrayList;
import java.util.List;
import javax.swing.Timer;
import javax.swing.ToolTipManager;

public class SoapUIDragAndDropHandler
implements DragGestureListener,
DragSourceListener {
    public static final int ON_RANGE = 3;
    private final SoapUIDragAndDropable<ModelItem> dragAndDropable;
    private BufferedImage _imgGhost;
    private Point _ptOffset = new Point();
    private static List<ModelItemDropHandler<ModelItem>> handlers = new ArrayList<ModelItemDropHandler<ModelItem>>();
    private Rectangle2D _raGhost = new Rectangle2D.Float();
    private final int dropType;
    private Point _ptLast = new Point();

    public SoapUIDragAndDropHandler(SoapUIDragAndDropable target, int dropType) {
        this.dragAndDropable = target;
        this.dropType = dropType;
        DropTarget dropTarget = new DropTarget(target.getComponent(), new SoapUIDropTargetListener());
        dropTarget.setDefaultActions(3);
    }

    public static void addDropHandler(ModelItemDropHandler dropHandler) {
        handlers.add(dropHandler);
    }

    public void dragGestureRecognized(DragGestureEvent e) {
        Point ptDragOrigin = e.getDragOrigin();
        ModelItem modelItem = this.dragAndDropable.getModelItemForLocation(ptDragOrigin.x, ptDragOrigin.y);
        if (modelItem == null) {
            return;
        }
        Rectangle raPath = this.dragAndDropable.getModelItemBounds(modelItem);
        if (raPath == null) {
            return;
        }
        this._ptOffset = new Point(ptDragOrigin.x - raPath.x, ptDragOrigin.y - raPath.y);
        Component renderer = this.dragAndDropable.getRenderer(modelItem);
        if (renderer != null) {
            renderer.setSize((int)raPath.getWidth(), (int)raPath.getHeight());
            this._imgGhost = new BufferedImage((int)raPath.getWidth(), (int)raPath.getHeight(), 3);
            Graphics2D g2 = this._imgGhost.createGraphics();
            g2.setComposite(AlphaComposite.getInstance(2, 0.5f));
            renderer.paint(g2);
            g2.setComposite(AlphaComposite.getInstance(4, 0.5f));
            int width = this.dragAndDropable.getComponent().getWidth();
            g2.setPaint(new GradientPaint(0.0f, 0.0f, SystemColor.controlShadow, width, 0.0f, new Color(255, 255, 255, 0)));
            g2.fillRect(0, 0, width, this._imgGhost.getHeight());
            g2.dispose();
        } else {
            this._imgGhost = null;
        }
        this.dragAndDropable.selectModelItem(modelItem);
        ModelItemTransferable transferable = new ModelItemTransferable(modelItem);
        e.startDrag(null, this._imgGhost, new Point(5, 5), transferable, this);
    }

    public void dragDropEnd(DragSourceDropEvent dsde) {
        if (this._raGhost != null) {
            this.dragAndDropable.getComponent().repaint(this._raGhost.getBounds());
        }
        this._ptOffset = null;
        SoapUI.getNavigator().getMainTree().setToolTipText(null);
    }

    public void dragEnter(DragSourceDragEvent dsde) {
    }

    public void dragExit(DragSourceEvent dse) {
    }

    public void dragOver(DragSourceDragEvent dsde) {
    }

    public void dropActionChanged(DragSourceDragEvent dsde) {
    }

    static {
        SoapUIDragAndDropHandler.addDropHandler(new TestStepToTestCaseDropHandler());
        SoapUIDragAndDropHandler.addDropHandler(new TestStepToTestStepsDropHandler());
        SoapUIDragAndDropHandler.addDropHandler(new TestStepToTestStepDropHandler());
        SoapUIDragAndDropHandler.addDropHandler(new TestSuiteToProjectDropHandler());
        SoapUIDragAndDropHandler.addDropHandler(new InterfaceToProjectDropHandler());
        SoapUIDragAndDropHandler.addDropHandler(new TestCaseToProjectDropHandler());
        SoapUIDragAndDropHandler.addDropHandler(new TestCaseToTestSuiteDropHandler());
        SoapUIDragAndDropHandler.addDropHandler(new TestCaseToTestCaseDropHandler());
        SoapUIDragAndDropHandler.addDropHandler(new RequestToTestCaseDropHandler());
        SoapUIDragAndDropHandler.addDropHandler(new RequestToTestStepsDropHandler());
        SoapUIDragAndDropHandler.addDropHandler(new RequestToTestStepDropHandler());
        SoapUIDragAndDropHandler.addDropHandler(new RequestToMockOperationDropHandler());
        SoapUIDragAndDropHandler.addDropHandler(new MockServiceToProjectDropHandler());
        SoapUIDragAndDropHandler.addDropHandler(new OperationToMockServiceDropHandler());
        SoapUIDragAndDropHandler.addDropHandler(new MockResponseToTestCaseDropHandler());
        SoapUIDragAndDropHandler.addDropHandler(new MockResponseToTestStepDropHandler());
        SoapUIDragAndDropHandler.addDropHandler(new MockResponseToTestStepsDropHandler());
        SoapUIDragAndDropHandler.addDropHandler(new TestSuiteToTestSuiteDropHandler());
    }

    class SoapUIDropTargetListener
    implements DropTargetListener {
        private ModelItem _pathLast = null;
        private Rectangle2D _raCueLine = new Rectangle2D.Float();
        private Color _colorCueLine = new Color(SystemColor.controlShadow.getRed(), SystemColor.controlShadow.getGreen(), SystemColor.controlShadow.getBlue(), 128);
        private Timer _timerHover;
        private String dropInfo;

        public SoapUIDropTargetListener() {
            this._timerHover = new Timer(1000, new ActionListener(){

                public void actionPerformed(ActionEvent e) {
                    if (SoapUIDragAndDropHandler.this._ptOffset != null) {
                        SoapUIDragAndDropHandler.this.dragAndDropable.toggleExpansion(SoapUIDropTargetListener.this._pathLast);
                    }
                }
            });
            this._timerHover.setRepeats(false);
        }

        public void dragEnter(DropTargetDragEvent e) {
            int dt = this.getDropTypeAtPoint(e.getLocation());
            if (dt == 0 || !this.isDragAcceptable(e, dt)) {
                e.rejectDrag();
            } else {
                e.acceptDrag(e.getDropAction());
            }
        }

        private int getDropTypeAtPoint(Point pt) {
            ModelItem modelItem = (ModelItem)SoapUIDragAndDropHandler.this.dragAndDropable.getModelItemForLocation(pt.x, pt.y);
            if (modelItem == null) {
                return 0;
            }
            Rectangle raPath = SoapUIDragAndDropHandler.this.dragAndDropable.getModelItemBounds(modelItem);
            if ((double)pt.y > (double)raPath.y + raPath.getHeight() / 2.0 + 3.0) {
                return 2;
            }
            if ((double)pt.y < (double)raPath.y + raPath.getHeight() / 2.0 - 3.0) {
                return 1;
            }
            return 4;
        }

        public void dragExit(DropTargetEvent e) {
            if (!DragSource.isDragImageSupported()) {
                SoapUIDragAndDropHandler.this.dragAndDropable.getComponent().repaint(SoapUIDragAndDropHandler.this._raGhost.getBounds());
            }
        }

        public void dragOver(DropTargetDragEvent e) {
            Point pt = e.getLocation();
            if (pt.equals(SoapUIDragAndDropHandler.this._ptLast)) {
                return;
            }
            SoapUIDragAndDropHandler.this._ptLast = pt;
            Graphics2D g2 = (Graphics2D)SoapUIDragAndDropHandler.this.dragAndDropable.getComponent().getGraphics();
            if (!DragSource.isDragImageSupported() && SoapUIDragAndDropHandler.this._imgGhost != null && SoapUIDragAndDropHandler.this._ptOffset != null) {
                SoapUIDragAndDropHandler.this.dragAndDropable.getComponent().paintImmediately(SoapUIDragAndDropHandler.this._raGhost.getBounds());
                SoapUIDragAndDropHandler.this._raGhost.setRect(pt.x - ((SoapUIDragAndDropHandler)SoapUIDragAndDropHandler.this)._ptOffset.x, pt.y - ((SoapUIDragAndDropHandler)SoapUIDragAndDropHandler.this)._ptOffset.y, SoapUIDragAndDropHandler.this._imgGhost.getWidth(), SoapUIDragAndDropHandler.this._imgGhost.getHeight());
                g2.drawImage(SoapUIDragAndDropHandler.this._imgGhost, AffineTransform.getTranslateInstance(SoapUIDragAndDropHandler.this._raGhost.getX(), SoapUIDragAndDropHandler.this._raGhost.getY()), null);
            } else {
                SoapUIDragAndDropHandler.this.dragAndDropable.getComponent().paintImmediately(this._raCueLine.getBounds());
            }
            ModelItem modelItem = (ModelItem)SoapUIDragAndDropHandler.this.dragAndDropable.getModelItemForLocation(pt.x, pt.y);
            if (modelItem == null) {
                e.rejectDrag();
                return;
            }
            if (modelItem != this._pathLast) {
                this._pathLast = modelItem;
                this._timerHover.restart();
            }
            Rectangle raPath = SoapUIDragAndDropHandler.this.dragAndDropable.getModelItemBounds(modelItem);
            int dt = SoapUIDragAndDropHandler.this.dropType;
            if (SoapUIDragAndDropHandler.this.dropType == 2) {
                this._raCueLine.setRect(0.0, raPath.y + (int)raPath.getHeight() - 2, SoapUIDragAndDropHandler.this.dragAndDropable.getComponent().getWidth(), 2.0);
            } else if (SoapUIDragAndDropHandler.this.dropType == 1) {
                this._raCueLine.setRect(0.0, raPath.y, SoapUIDragAndDropHandler.this.dragAndDropable.getComponent().getWidth(), 2.0);
            } else if (SoapUIDragAndDropHandler.this.dropType == 4) {
                this._raCueLine.setRect(0.0, raPath.y, SoapUIDragAndDropHandler.this.dragAndDropable.getComponent().getWidth(), raPath.getHeight());
            } else if ((double)pt.y > (double)raPath.y + raPath.getHeight() / 2.0 + 3.0) {
                this._raCueLine.setRect(0.0, raPath.y + (int)raPath.getHeight() - 2, SoapUIDragAndDropHandler.this.dragAndDropable.getComponent().getWidth(), 2.0);
                dt = 2;
            } else if ((double)pt.y < (double)raPath.y + raPath.getHeight() / 2.0 - 3.0) {
                this._raCueLine.setRect(0.0, raPath.y, SoapUIDragAndDropHandler.this.dragAndDropable.getComponent().getWidth(), 2.0);
                dt = 1;
            } else {
                this._raCueLine.setRect(0.0, raPath.y, SoapUIDragAndDropHandler.this.dragAndDropable.getComponent().getWidth(), raPath.getHeight());
                dt = 4;
            }
            boolean dragAcceptable = this.isDragAcceptable(e, dt);
            g2.setColor(this._colorCueLine);
            g2.fill(this._raCueLine);
            if (dragAcceptable) {
                SoapUIDragAndDropHandler.this.dragAndDropable.setDragInfo(this.dropInfo);
            } else {
                SoapUIDragAndDropHandler.this.dragAndDropable.setDragInfo("");
            }
            ToolTipManager.sharedInstance().mouseMoved(new MouseEvent(SoapUIDragAndDropHandler.this.dragAndDropable.getComponent(), 0, 0L, 0, pt.x, pt.y + 10, 0, false));
            SoapUIDragAndDropHandler.this._raGhost = SoapUIDragAndDropHandler.this._raGhost.createUnion(this._raCueLine);
            if (!dragAcceptable) {
                e.rejectDrag();
            } else {
                e.acceptDrag(e.getDropAction());
            }
        }

        public void dropActionChanged(DropTargetDragEvent e) {
            int dt = this.getDropTypeAtPoint(e.getLocation());
            if (dt == 0 || !this.isDragAcceptable(e, dt)) {
                e.rejectDrag();
            } else {
                e.acceptDrag(e.getDropAction());
            }
        }

        public void drop(DropTargetDropEvent e) {
            int dt = this.getDropTypeAtPoint(e.getLocation());
            this._timerHover.stop();
            if (dt == 0 || !this.isDropAcceptable(e, dt)) {
                e.rejectDrop();
                return;
            }
            e.acceptDrop(e.getDropAction());
            Transferable transferable = e.getTransferable();
            DataFlavor[] flavors = transferable.getTransferDataFlavors();
            block2: for (int i = 0; i < flavors.length; ++i) {
                DataFlavor flavor = flavors[i];
                if (!flavor.isMimeTypeEqual("application/x-java-jvm-local-objectref")) continue;
                try {
                    Point pt = e.getLocation();
                    ModelItem pathTarget = (ModelItem)SoapUIDragAndDropHandler.this.dragAndDropable.getModelItemForLocation(pt.x, pt.y);
                    ModelItem pathSource = (ModelItem)transferable.getTransferData(flavor);
                    for (ModelItemDropHandler handler : handlers) {
                        if (!handler.canDrop(pathSource, pathTarget, e.getDropAction(), dt)) continue;
                        handler.drop(pathSource, pathTarget, e.getDropAction(), dt);
                        break block2;
                    }
                    break;
                }
                catch (Exception ioe) {
                    System.out.println(ioe);
                    e.dropComplete(false);
                    return;
                }
            }
            e.dropComplete(true);
        }

        public boolean isDragAcceptable(DropTargetDragEvent e, int dt) {
            if ((e.getDropAction() & 3) == 0) {
                return false;
            }
            if (!e.isDataFlavorSupported(ModelItemTransferable.MODELITEM_DATAFLAVOR)) {
                return false;
            }
            Transferable transferable = e.getTransferable();
            DataFlavor[] flavors = transferable.getTransferDataFlavors();
            for (int i = 0; i < flavors.length; ++i) {
                DataFlavor flavor = flavors[i];
                if (!flavor.isMimeTypeEqual("application/x-java-jvm-local-objectref")) continue;
                try {
                    Point pt = e.getLocation();
                    ModelItem pathTarget = (ModelItem)SoapUIDragAndDropHandler.this.dragAndDropable.getModelItemForLocation(pt.x, pt.y);
                    ModelItem pathSource = (ModelItem)transferable.getTransferData(flavor);
                    for (ModelItemDropHandler handler : handlers) {
                        if (!handler.canDrop(pathSource, pathTarget, e.getDropAction(), dt)) continue;
                        this.dropInfo = handler.getDropInfo(pathSource, pathTarget, e.getDropAction(), dt);
                        return true;
                    }
                    this.dropInfo = null;
                    continue;
                }
                catch (Exception ex) {
                    SoapUI.logError(ex);
                }
            }
            return false;
        }

        public boolean isDropAcceptable(DropTargetDropEvent e, int dt) {
            if ((e.getDropAction() & 3) == 0) {
                return false;
            }
            if (!e.isDataFlavorSupported(ModelItemTransferable.MODELITEM_DATAFLAVOR)) {
                return false;
            }
            Transferable transferable = e.getTransferable();
            DataFlavor[] flavors = transferable.getTransferDataFlavors();
            for (int i = 0; i < flavors.length; ++i) {
                DataFlavor flavor = flavors[i];
                if (!flavor.isMimeTypeEqual("application/x-java-jvm-local-objectref")) continue;
                try {
                    Point pt = e.getLocation();
                    ModelItem pathSource = (ModelItem)transferable.getTransferData(flavor);
                    ModelItem pathTarget = (ModelItem)SoapUIDragAndDropHandler.this.dragAndDropable.getModelItemForLocation(pt.x, pt.y);
                    for (ModelItemDropHandler handler : handlers) {
                        if (!handler.canDrop(pathSource, pathTarget, e.getDropAction(), dt)) continue;
                        return true;
                    }
                    continue;
                }
                catch (Exception ex) {
                    SoapUI.logError(ex);
                }
            }
            return false;
        }
    }
}

