/*
 * Decompiled with CFR 0.152.
 */
package com.eviware.soapui.support.editor.inspectors.jms.property;

import com.eviware.soapui.impl.support.AbstractHttpRequest;
import com.eviware.soapui.impl.wsdl.submit.transports.jms.JMSHeader;
import com.eviware.soapui.impl.wsdl.submit.transports.jms.JMSResponse;
import com.eviware.soapui.impl.wsdl.submit.transports.jms.util.JMSUtils;
import com.eviware.soapui.impl.wsdl.support.MessageExchangeModelItem;
import com.eviware.soapui.model.ModelItem;
import com.eviware.soapui.model.iface.MessageExchange;
import com.eviware.soapui.model.iface.Submit;
import com.eviware.soapui.model.iface.SubmitContext;
import com.eviware.soapui.model.iface.SubmitListener;
import com.eviware.soapui.support.editor.Editor;
import com.eviware.soapui.support.editor.EditorInspector;
import com.eviware.soapui.support.editor.inspectors.jms.property.JMSHeaderAndPropertyInspector;
import com.eviware.soapui.support.editor.inspectors.jms.property.JMSHeaderAndPropertyInspectorModel;
import com.eviware.soapui.support.editor.registry.RequestInspectorFactory;
import com.eviware.soapui.support.editor.registry.ResponseInspectorFactory;
import com.eviware.soapui.support.types.StringToStringMap;
import java.beans.PropertyChangeEvent;
import javax.jms.Message;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class JMSHeaderAndPropertyInspectorFactory
implements RequestInspectorFactory,
ResponseInspectorFactory {
    public static final String INSPECTOR_ID = "JMS Headers and Properties";

    @Override
    public String getInspectorId() {
        return INSPECTOR_ID;
    }

    @Override
    public EditorInspector<?> createRequestInspector(Editor<?> editor, ModelItem modelItem) {
        if (modelItem instanceof MessageExchangeModelItem) {
            JMSHeaderAndPropertyInspector inspector = new JMSHeaderAndPropertyInspector(new MessageExchangeRequestJMSHeaderAndPropertiesModel((MessageExchangeModelItem)modelItem));
            inspector.setEnabled(JMSUtils.checkIfJMS(modelItem));
            return inspector;
        }
        return null;
    }

    @Override
    public EditorInspector<?> createResponseInspector(Editor<?> editor, ModelItem modelItem) {
        if (modelItem instanceof AbstractHttpRequest) {
            JMSHeaderAndPropertyInspector inspector = new JMSHeaderAndPropertyInspector(new ResponseJMSHeaderAndPropertiesModel((AbstractHttpRequest)modelItem));
            inspector.setEnabled(JMSUtils.checkIfJMS(modelItem));
            return inspector;
        }
        if (modelItem instanceof MessageExchangeModelItem) {
            JMSHeaderAndPropertyInspector inspector = new JMSHeaderAndPropertyInspector(new MessageExchangeResponseJMSHeaderAndPropertiesModel((MessageExchangeModelItem)modelItem));
            inspector.setEnabled(JMSUtils.checkIfJMS(modelItem));
            return inspector;
        }
        return null;
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    private class MessageExchangeRequestJMSHeaderAndPropertiesModel
    extends JMSHeaderAndPropertyInspectorModel.AbstractJMSHeaderAndPropertyModel<MessageExchangeModelItem> {
        MessageExchangeModelItem messageExchangeModelItem;
        JMSHeaderAndPropertyInspector inspector;

        public MessageExchangeRequestJMSHeaderAndPropertiesModel(MessageExchangeModelItem messageExchangeModelItem) {
            super(true, messageExchangeModelItem, "messageExchange");
            this.messageExchangeModelItem = messageExchangeModelItem;
        }

        @Override
        public StringToStringMap getJMSHeadersAndProperties() {
            MessageExchange messageExchange = ((MessageExchangeModelItem)this.getModelItem()).getMessageExchange();
            if (messageExchange != null && messageExchange.getRequestHeaders() != null) {
                return messageExchange.getRequestHeaders().toStringToStringMap();
            }
            return new StringToStringMap();
        }

        @Override
        public void setInspector(JMSHeaderAndPropertyInspector inspector) {
            this.inspector = inspector;
        }
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    private class MessageExchangeResponseJMSHeaderAndPropertiesModel
    extends JMSHeaderAndPropertyInspectorModel.AbstractJMSHeaderAndPropertyModel<MessageExchangeModelItem> {
        MessageExchangeModelItem messageExchangeModelItem;
        JMSHeaderAndPropertyInspector inspector;

        public MessageExchangeResponseJMSHeaderAndPropertiesModel(MessageExchangeModelItem messageExchangeModelItem) {
            super(true, messageExchangeModelItem, "messageExchange");
            this.messageExchangeModelItem = messageExchangeModelItem;
        }

        @Override
        public StringToStringMap getJMSHeadersAndProperties() {
            MessageExchange messageExchange = ((MessageExchangeModelItem)this.getModelItem()).getMessageExchange();
            if (messageExchange != null) {
                return messageExchange.getResponseHeaders().toStringToStringMap();
            }
            return new StringToStringMap();
        }

        @Override
        public void setInspector(JMSHeaderAndPropertyInspector inspector) {
            this.inspector = inspector;
        }
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    private class ResponseJMSHeaderAndPropertiesModel
    extends JMSHeaderAndPropertyInspectorModel.AbstractJMSHeaderAndPropertyModel<AbstractHttpRequest<?>>
    implements SubmitListener {
        AbstractHttpRequest<?> request;
        JMSHeaderAndPropertyInspector inspector;
        StringToStringMap headersAndProperties;

        public ResponseJMSHeaderAndPropertiesModel(AbstractHttpRequest<?> wsdlRequest) {
            super(true, wsdlRequest, "jmsHeaderAndProperties");
            this.request = wsdlRequest;
            this.request.addSubmitListener(this);
            this.request.addPropertyChangeListener(this);
        }

        @Override
        public void propertyChange(PropertyChangeEvent evt) {
            if (this.request.getEndpoint() != null && evt.getPropertyName().equals("endpoint")) {
                this.inspector.setEnabled(this.request.getEndpoint().startsWith("jms://"));
            }
            super.propertyChange(evt);
        }

        @Override
        public void release() {
            super.release();
            this.request.removeSubmitListener(this);
            this.request.removePropertyChangeListener(this);
        }

        @Override
        public StringToStringMap getJMSHeadersAndProperties() {
            return this.headersAndProperties;
        }

        @Override
        public void afterSubmit(Submit submit, SubmitContext context) {
            Message message;
            this.headersAndProperties = new StringToStringMap();
            JMSResponse jmsResponse = (JMSResponse)context.getProperty("JMS_RESPONSE");
            if (jmsResponse instanceof JMSResponse && (message = jmsResponse.getMessageReceive()) != null) {
                this.headersAndProperties.putAll(JMSHeader.getMessageHeadersAndProperties(message).toStringToStringMap());
            }
            this.inspector.getHeadersTableModel().setData(this.headersAndProperties);
        }

        @Override
        public boolean beforeSubmit(Submit submit, SubmitContext context) {
            return true;
        }

        @Override
        public void setInspector(JMSHeaderAndPropertyInspector inspector) {
            this.inspector = inspector;
        }
    }
}

