/*
 * Decompiled with CFR 0.152.
 */
package com.eviware.soapui.support.editor.views;

import com.eviware.soapui.support.editor.EditorLocation;
import com.eviware.soapui.support.editor.EditorLocationListener;
import com.eviware.soapui.support.editor.xml.XmlDocument;
import com.eviware.soapui.support.editor.xml.XmlEditor;
import com.eviware.soapui.support.editor.xml.XmlEditorView;
import java.beans.PropertyChangeEvent;
import java.beans.PropertyChangeListener;
import java.beans.PropertyChangeSupport;
import java.util.HashSet;
import java.util.Set;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public abstract class AbstractXmlEditorView<T extends XmlDocument>
implements XmlEditorView<T>,
PropertyChangeListener {
    private String title;
    private boolean isActive;
    private PropertyChangeSupport propertyChangeSupport = new PropertyChangeSupport(this);
    private T xmlDocument;
    private boolean xmlChanged;
    private Set<EditorLocationListener<T>> listeners = new HashSet<EditorLocationListener<T>>();
    private XmlEditor<T> editor;
    private final String viewId;

    public AbstractXmlEditorView(String title, XmlEditor<T> xmlEditor, String viewId) {
        this.title = title;
        this.editor = xmlEditor;
        this.viewId = viewId;
        this.xmlChanged = false;
    }

    protected PropertyChangeSupport getPropertyChangeSupport() {
        return this.propertyChangeSupport;
    }

    @Override
    public String getViewId() {
        return this.viewId;
    }

    @Override
    public boolean activate(EditorLocation<T> location) {
        this.isActive = true;
        this.update();
        return true;
    }

    public void update() {
        if (this.xmlChanged) {
            this.setXml(this.xmlDocument == null ? null : this.xmlDocument.getXml());
            this.xmlChanged = false;
        }
    }

    public boolean isXmlChanged() {
        return this.xmlChanged;
    }

    @Override
    public boolean deactivate() {
        this.isActive = false;
        this.xmlChanged = false;
        return true;
    }

    public boolean isActive() {
        return this.isActive;
    }

    @Override
    public String getTitle() {
        return this.title;
    }

    public void setTitle(String title) {
        String oldTitle = this.title;
        this.title = title;
        this.propertyChangeSupport.firePropertyChange(TITLE_PROPERTY, oldTitle, title);
    }

    @Override
    public void addPropertyChangeListener(String propertyName, PropertyChangeListener listener) {
        this.propertyChangeSupport.addPropertyChangeListener(propertyName, listener);
    }

    @Override
    public void addPropertyChangeListener(PropertyChangeListener listener) {
        this.propertyChangeSupport.addPropertyChangeListener(listener);
    }

    @Override
    public void removePropertyChangeListener(PropertyChangeListener listener) {
        this.propertyChangeSupport.removePropertyChangeListener(listener);
    }

    @Override
    public void removePropertyChangeListener(String propertyName, PropertyChangeListener listener) {
        this.propertyChangeSupport.removePropertyChangeListener(propertyName, listener);
    }

    @Override
    public T getDocument() {
        return this.xmlDocument;
    }

    @Override
    public void setDocument(T xmlDocument) {
        if (this.xmlDocument != null) {
            this.xmlDocument.removePropertyChangeListener(XmlDocument.XML_PROPERTY, this);
        }
        this.xmlDocument = xmlDocument;
        this.xmlChanged = false;
        if (xmlDocument != null) {
            this.xmlDocument.addPropertyChangeListener(XmlDocument.XML_PROPERTY, this);
            if (this.isActive()) {
                this.setXml(xmlDocument.getXml());
            } else {
                this.xmlChanged = true;
            }
        } else if (this.isActive()) {
            this.setXml(null);
        } else {
            this.xmlChanged = true;
        }
    }

    @Override
    public void propertyChange(PropertyChangeEvent evt) {
        if (evt.getSource() == this.xmlDocument && evt.getPropertyName().equals(XmlDocument.XML_PROPERTY)) {
            if (this.isActive()) {
                this.setXml((String)evt.getNewValue());
            } else {
                this.xmlChanged = true;
            }
        }
    }

    public abstract void setXml(String var1);

    @Override
    public void release() {
        if (this.xmlDocument != null) {
            this.xmlDocument.removePropertyChangeListener(XmlDocument.XML_PROPERTY, this);
            this.xmlDocument = null;
        }
    }

    @Override
    public void addLocationListener(EditorLocationListener<T> listener) {
        this.listeners.add(listener);
    }

    @Override
    public void removeLocationListener(EditorLocationListener<T> listener) {
        this.listeners.remove(listener);
    }

    public void fireLocationChanged(EditorLocation<T> location) {
        for (EditorLocationListener<T> listener : this.listeners) {
            listener.locationChanged(location);
        }
    }

    @Override
    public EditorLocation<T> getEditorLocation() {
        return null;
    }

    public String getXml() {
        return this.xmlDocument == null ? null : this.xmlDocument.getXml();
    }

    @Override
    public void setLocation(EditorLocation<T> location) {
    }

    @Override
    public void locationChanged(EditorLocation<T> location) {
    }

    public void syncUpdates() {
        if (!this.isActive() && this.xmlChanged) {
            this.setXml(this.xmlDocument == null ? null : this.xmlDocument.getXml());
            this.xmlChanged = false;
        }
    }

    @Override
    public XmlEditor<T> getEditor() {
        return this.editor;
    }

    @Override
    public void requestFocus() {
    }
}

