/*
 * Decompiled with CFR 0.152.
 */
package com.eviware.soapui.support.factory;

import com.eviware.soapui.DefaultSoapUICore;
import com.eviware.soapui.SoapUI;
import com.eviware.soapui.config.SoapUIFactoriesConfig;
import com.eviware.soapui.config.SoapUIFactoryConfig;
import com.eviware.soapui.config.SoapuiFactoriesDocumentConfig;
import com.eviware.soapui.support.factory.InitializableFactory;
import java.io.IOException;
import java.io.InputStream;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import org.apache.log4j.Logger;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class SoapUIFactoryRegistry {
    private Map<Class<?>, List<Object>> factories = new HashMap();
    private Map<Class<?>, SoapUIFactoryConfig> factoryConfigs = new HashMap();
    private static final Logger log = Logger.getLogger(SoapUIFactoryRegistry.class);

    public SoapUIFactoryRegistry(InputStream config) {
        if (config != null) {
            this.addConfig(config, this.getClass().getClassLoader());
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Loose catch block
     */
    public void addConfig(InputStream config, ClassLoader classLoader) {
        block13: {
            SoapuiFactoriesDocumentConfig configDocument = SoapuiFactoriesDocumentConfig.Factory.parse((InputStream)config);
            SoapUIFactoriesConfig soapuiListeners = configDocument.getSoapuiFactories();
            for (SoapUIFactoryConfig factoryConfig : soapuiListeners.getFactoryList()) {
                try {
                    String factoryTypeName = factoryConfig.getFactoryType();
                    String factoryClassName = factoryConfig.getFactoryClass();
                    Class<?> factoryType = Class.forName(factoryTypeName, true, classLoader);
                    Class<?> factoryClass = Class.forName(factoryClassName, true, classLoader);
                    if (!factoryType.isAssignableFrom(factoryClass)) {
                        throw new RuntimeException("Factory class: " + factoryClassName + " must be of type: " + factoryTypeName);
                    }
                    Object obj = factoryClass.newInstance();
                    if (obj instanceof InitializableFactory) {
                        ((InitializableFactory)obj).init(factoryConfig);
                    }
                    this.getLog().info((Object)("Adding factory [" + factoryClass + "]"));
                    this.addFactory(factoryType, obj);
                }
                catch (Exception e) {
                    System.err.println("Error initializing Listener: " + e);
                }
            }
            Object var13_14 = null;
            try {
                config.close();
            }
            catch (IOException e2) {
                SoapUI.logError(e2);
            }
            break block13;
            {
                catch (Exception e) {
                    SoapUI.logError(e);
                    Object var13_15 = null;
                    try {
                        config.close();
                    }
                    catch (IOException e2) {
                        SoapUI.logError(e2);
                    }
                }
            }
            catch (Throwable throwable) {
                Object var13_16 = null;
                try {
                    config.close();
                }
                catch (IOException e2) {
                    SoapUI.logError(e2);
                }
                throw throwable;
            }
        }
    }

    private Logger getLog() {
        return DefaultSoapUICore.log == null ? log : DefaultSoapUICore.log;
    }

    public void addFactory(Class<?> factoryType, Object factory) {
        if (!this.factories.containsKey(factoryType)) {
            this.factories.put(factoryType, new ArrayList());
        }
        this.factories.get(factoryType).add(factory);
    }

    public void removeFactory(Class<?> factoryType, Object factory) {
        if (this.factories.containsKey(factoryType)) {
            this.factories.get(factoryType).remove(factory);
        }
    }

    public <T> List<T> getFactories(Class<T> factoryType) {
        ArrayList result = new ArrayList();
        if (this.factories.containsKey(factoryType)) {
            result.addAll(this.factories.get(factoryType));
        }
        return result;
    }
}

