/*
 * Decompiled with CFR 0.152.
 */
package com.eviware.soapui.support.listener;

import com.eviware.soapui.DefaultSoapUICore;
import com.eviware.soapui.SoapUI;
import com.eviware.soapui.config.SoapUIListenerConfig;
import com.eviware.soapui.config.SoapUIListenersConfig;
import com.eviware.soapui.config.SoapuiListenersDocumentConfig;
import com.eviware.soapui.support.listener.InitializableListener;
import java.io.IOException;
import java.io.InputStream;
import java.util.ArrayList;
import java.util.Collection;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import org.apache.log4j.Logger;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class SoapUIListenerRegistry {
    private Map<Class<?>, List<Class<?>>> listeners = new HashMap();
    private Map<Class<?>, List<Object>> singletonListeners = new HashMap();
    private Map<Class<?>, SoapUIListenerConfig> listenerConfigs = new HashMap();
    private static final Logger log = Logger.getLogger(SoapUIListenerRegistry.class);

    public void addListener(Class<?> listenerInterface, Class<?> listenerClass, SoapUIListenerConfig config) {
        List<Class<?>> classes = null;
        if (this.listeners.containsKey(listenerInterface)) {
            classes = this.listeners.get(listenerInterface);
        }
        if (classes == null) {
            classes = new ArrayList();
        }
        classes.add(listenerClass);
        this.listeners.put(listenerInterface, classes);
        if (config != null) {
            this.listenerConfigs.put(listenerClass, config);
        }
    }

    public void removeListener(Class<?> listenerInterface, Class<?> listenerClass) {
        List<Class<?>> classes = null;
        if (this.listeners.containsKey(listenerInterface)) {
            classes = this.listeners.get(listenerInterface);
        }
        if (classes != null) {
            classes.remove(listenerClass);
        }
        if (classes == null || classes.size() == 0) {
            this.listeners.remove(listenerInterface);
        }
        this.listenerConfigs.remove(listenerClass);
    }

    public SoapUIListenerRegistry(InputStream config) {
        if (config != null) {
            this.addConfig(config, this.getClass().getClassLoader());
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Loose catch block
     */
    public void addConfig(InputStream config, ClassLoader classLoader) {
        block15: {
            SoapuiListenersDocumentConfig configDocument = SoapuiListenersDocumentConfig.Factory.parse((InputStream)config);
            SoapUIListenersConfig soapuiListeners = configDocument.getSoapuiListeners();
            for (SoapUIListenerConfig listenerConfig : soapuiListeners.getListenerList()) {
                try {
                    String listenerInterfaceName = listenerConfig.getListenerInterface();
                    String listenerClassName = listenerConfig.getListenerClass();
                    Class<?> listenerInterface = Class.forName(listenerInterfaceName, true, classLoader);
                    Class<?> listenerClass = Class.forName(listenerClassName, true, classLoader);
                    if (!listenerInterface.isInterface()) {
                        throw new RuntimeException("Listener interface: " + listenerInterfaceName + " must be an interface");
                    }
                    if (!listenerInterface.isAssignableFrom(listenerClass)) {
                        throw new RuntimeException("Listener class: " + listenerClassName + " must implement interface: " + listenerInterfaceName);
                    }
                    Object obj = listenerClass.newInstance();
                    if (listenerConfig.getSingleton()) {
                        if (obj instanceof InitializableListener) {
                            ((InitializableListener)obj).init(listenerConfig);
                        }
                        this.getLog().info((Object)("Adding singleton listener [" + listenerClass + "]"));
                        this.addSingletonListener(listenerInterface, obj);
                        continue;
                    }
                    this.getLog().info((Object)("Adding listener [" + listenerClass + "]"));
                    this.addListener(listenerInterface, listenerClass, listenerConfig);
                }
                catch (Exception e) {
                    System.err.println("Error initializing Listener: " + e);
                }
            }
            Object var13_14 = null;
            try {
                config.close();
            }
            catch (IOException e2) {
                SoapUI.logError(e2);
            }
            break block15;
            {
                catch (Exception e) {
                    SoapUI.logError(e);
                    Object var13_15 = null;
                    try {
                        config.close();
                    }
                    catch (IOException e2) {
                        SoapUI.logError(e2);
                    }
                }
            }
            catch (Throwable throwable) {
                Object var13_16 = null;
                try {
                    config.close();
                }
                catch (IOException e2) {
                    SoapUI.logError(e2);
                }
                throw throwable;
            }
        }
    }

    private Logger getLog() {
        return DefaultSoapUICore.log == null ? log : DefaultSoapUICore.log;
    }

    public void addSingletonListener(Class<?> listenerInterface, Object listener) {
        if (!this.singletonListeners.containsKey(listenerInterface)) {
            this.singletonListeners.put(listenerInterface, new ArrayList());
        }
        this.singletonListeners.get(listenerInterface).add(listener);
    }

    public void removeSingletonListener(Class<?> listenerInterface, Object listener) {
        if (this.singletonListeners.containsKey(listenerInterface)) {
            this.singletonListeners.get(listenerInterface).remove(listener);
        }
    }

    public <T> List<T> getListeners(Class<T> listenerType) {
        ArrayList result = new ArrayList();
        if (this.listeners.containsKey(listenerType)) {
            List<Class<?>> list = this.listeners.get(listenerType);
            for (Class<?> listenerClass : list) {
                try {
                    Object listener = listenerClass.newInstance();
                    if (this.listenerConfigs.containsKey(listenerClass) && listener instanceof InitializableListener) {
                        ((InitializableListener)listener).init(this.listenerConfigs.get(listenerClass));
                    }
                    result.add(listener);
                }
                catch (Exception e) {
                    SoapUI.logError(e);
                }
            }
        }
        if (this.singletonListeners.containsKey(listenerType)) {
            result.addAll((Collection)this.singletonListeners.get(listenerType));
        }
        return result;
    }

    public <T> List<T> joinListeners(Class<T> listenerType, Collection<T> existing) {
        ArrayList<Object> result = new ArrayList<Object>();
        if (this.listeners.containsKey(listenerType)) {
            List<Class<?>> list = this.listeners.get(listenerType);
            for (Class<?> listenerClass : list) {
                try {
                    Object listener = listenerClass.newInstance();
                    if (this.listenerConfigs.containsKey(listenerClass) && listener instanceof InitializableListener) {
                        ((InitializableListener)listener).init(this.listenerConfigs.get(listenerClass));
                    }
                    result.add(listener);
                }
                catch (Exception e) {
                    SoapUI.logError(e);
                }
            }
        }
        if (this.singletonListeners.containsKey(listenerType)) {
            result.addAll((Collection)this.singletonListeners.get(listenerType));
        }
        result.addAll(existing);
        return result;
    }
}

