/*
 * Decompiled with CFR 0.152.
 */
package com.eviware.soapui.support.log;

import com.eviware.soapui.support.components.Inspector;
import com.eviware.soapui.support.components.JComponentInspector;
import com.eviware.soapui.support.components.JInspectorPanel;
import com.eviware.soapui.support.components.JInspectorPanelFactory;
import com.eviware.soapui.support.log.JLogList;
import com.eviware.soapui.support.log.Log4JMonitor;
import java.util.List;
import javax.swing.JComponent;
import org.apache.log4j.spi.LoggingEvent;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class InspectorLog4JMonitor
implements JInspectorPanel,
Log4JMonitor {
    private JLogList defaultLogArea;
    private JInspectorPanel inspectorPanel;

    public InspectorLog4JMonitor(JComponent content) {
        this.inspectorPanel = JInspectorPanelFactory.build(content);
        this.setResizeWeight(0.9f);
    }

    @Override
    public JLogList addLogArea(String title, String loggerName, boolean isDefault) {
        JLogList logArea = new JLogList(title);
        logArea.addLogger(loggerName, !isDefault);
        JComponentInspector<JLogList> inspector = new JComponentInspector<JLogList>(logArea, title, null, true);
        this.addInspector(inspector);
        if (isDefault) {
            this.defaultLogArea = logArea;
            this.activate(inspector);
            this.setDividerLocation(500);
        }
        return logArea;
    }

    @Override
    public void logEvent(Object msg) {
        if (msg instanceof LoggingEvent) {
            LoggingEvent event = (LoggingEvent)msg;
            String loggerName = event.getLoggerName();
            for (Inspector inspector : this.inspectorPanel.getInspectors()) {
                JLogList logArea;
                JComponent tabComponent = inspector.getComponent();
                if (!(tabComponent instanceof JLogList) || !(logArea = (JLogList)tabComponent).monitors(loggerName)) continue;
                logArea.addLine(msg);
            }
        } else if (this.defaultLogArea != null) {
            this.defaultLogArea.addLine(msg);
        }
    }

    @Override
    public JLogList getLogArea(String title) {
        Inspector inspector = this.inspectorPanel.getInspectorByTitle(title);
        return (JLogList)(title == null ? null : inspector.getComponent());
    }

    @Override
    public boolean hasLogArea(String loggerName) {
        for (Inspector inspector : this.getInspectors()) {
            JLogList logArea;
            JComponent tabComponent = inspector.getComponent();
            if (!(tabComponent instanceof JLogList) || !(logArea = (JLogList)tabComponent).monitors(loggerName)) continue;
            return true;
        }
        return false;
    }

    @Override
    public JComponent getComponent() {
        return this.inspectorPanel.getComponent();
    }

    @Override
    public Inspector getCurrentInspector() {
        return this.inspectorPanel.getCurrentInspector();
    }

    @Override
    public Inspector getInspectorByTitle(String title) {
        return this.inspectorPanel.getInspectorByTitle(title);
    }

    @Override
    public List<Inspector> getInspectors() {
        return this.inspectorPanel.getInspectors();
    }

    @Override
    public void setCurrentInspector(String s) {
        this.inspectorPanel.setCurrentInspector(s);
    }

    @Override
    public void setDefaultDividerLocation(float v) {
        this.inspectorPanel.setDefaultDividerLocation(v);
    }

    @Override
    public void setDividerLocation(int i) {
        this.inspectorPanel.setDividerLocation(i);
    }

    @Override
    public void setResizeWeight(double v) {
        this.inspectorPanel.setResizeWeight(v);
    }

    @Override
    public void setCurrentLog(JLogList lastLog) {
        for (Inspector inspector : this.getInspectors()) {
            JComponent tabComponent = inspector.getComponent();
            if (tabComponent != lastLog) continue;
            this.activate(inspector);
            return;
        }
        this.inspectorPanel.deactivate();
    }

    @Override
    public void activate(Inspector inspector) {
        this.inspectorPanel.activate(inspector);
    }

    @Override
    public <T extends Inspector> T addInspector(T inspector) {
        return this.inspectorPanel.addInspector(inspector);
    }

    @Override
    public void deactivate() {
        this.inspectorPanel.deactivate();
    }

    @Override
    public void removeInspector(Inspector inspector) {
        this.inspectorPanel.removeInspector(inspector);
    }

    @Override
    public JLogList getCurrentLog() {
        return (JLogList)(this.inspectorPanel.getCurrentInspector() == null ? null : this.inspectorPanel.getCurrentInspector().getComponent());
    }

    @Override
    public boolean removeLogArea(String loggerName) {
        for (Inspector inspector : this.getInspectors()) {
            JLogList logList = (JLogList)((JComponentInspector)inspector).getComponent();
            if (logList.getLogger(loggerName) == null) continue;
            logList.removeLogger(loggerName);
            this.inspectorPanel.removeInspector(inspector);
            return true;
        }
        return false;
    }

    @Override
    public int getDividerLocation() {
        return this.inspectorPanel.getDividerLocation();
    }

    @Override
    public void setContentComponent(JComponent component) {
        this.inspectorPanel.setContentComponent(component);
    }

    @Override
    public void release() {
        this.inspectorPanel.release();
    }

    @Override
    public void setResetDividerLocation() {
        this.inspectorPanel.setResetDividerLocation();
    }

    @Override
    public void setInspectorVisible(Inspector inspector, boolean b) {
        this.inspectorPanel.setInspectorVisible(inspector, b);
    }

    @Override
    public Inspector getInspector(String inspectorId) {
        return this.inspectorPanel.getInspector(inspectorId);
    }
}

