/*
 * Decompiled with CFR 0.152.
 */
package com.eviware.soapui.support.swing;

import com.eviware.soapui.support.UISupport;
import com.eviware.soapui.support.action.swing.ActionList;
import com.eviware.soapui.support.action.swing.ActionSupport;
import java.awt.event.ActionEvent;
import java.awt.event.MouseAdapter;
import java.awt.event.MouseEvent;
import javax.swing.JList;
import javax.swing.JPopupMenu;

public abstract class AbstractListMouseListener
extends MouseAdapter {
    private boolean enablePopup;
    private JPopupMenu menu;

    protected abstract ActionList getActionsForRow(JList var1, int var2);

    public AbstractListMouseListener() {
        this(true);
    }

    public AbstractListMouseListener(boolean enablePopup) {
        this.enablePopup = enablePopup;
    }

    public void mouseClicked(MouseEvent e) {
        ActionList actions;
        if (e.getClickCount() < 2) {
            return;
        }
        JList list = (JList)e.getSource();
        int selectedIndex = list.getSelectedIndex();
        ActionList actionList = actions = selectedIndex == -1 ? this.getDefaultActions() : this.getActionsForRow(list, selectedIndex);
        if (actions != null) {
            actions.performDefaultAction(new ActionEvent(this, 0, null));
        }
    }

    protected ActionList getDefaultActions() {
        return null;
    }

    public void mousePressed(MouseEvent e) {
        if (e.isPopupTrigger()) {
            this.showPopup(e);
        }
    }

    public void mouseReleased(MouseEvent e) {
        if (e.isPopupTrigger()) {
            this.showPopup(e);
        }
    }

    public void showPopup(MouseEvent e) {
        if (!this.enablePopup) {
            return;
        }
        ActionList actions = null;
        JList list = (JList)e.getSource();
        int row = list.locationToIndex(e.getPoint());
        if (row == -1 || !list.getCellBounds(row, row).contains(e.getPoint())) {
            if (list.getSelectedIndex() != -1) {
                list.clearSelection();
            }
            actions = this.getDefaultActions();
        } else {
            if (list.getSelectedIndex() != row) {
                list.setSelectedIndex(row);
            }
            actions = this.getActionsForRow(list, row);
        }
        if (actions == null || actions.getActionCount() == 0) {
            return;
        }
        JPopupMenu popup = this.menu == null ? ActionSupport.buildPopup(actions) : this.menu;
        UISupport.showPopup(popup, list, e.getPoint());
    }

    public void setPopupMenu(JPopupMenu menu) {
        this.menu = menu;
    }
}

