/*
 * Decompiled with CFR 0.152.
 */
package com.eviware.soapui.support.xml.actions;

import com.eviware.soapui.SoapUI;
import com.eviware.soapui.support.UISupport;
import com.eviware.soapui.support.xml.XmlUtils;
import java.awt.event.ActionEvent;
import java.io.File;
import java.io.FileWriter;
import java.io.IOException;
import javax.swing.AbstractAction;
import org.apache.log4j.Logger;
import org.apache.xmlbeans.XmlException;
import org.apache.xmlbeans.XmlObject;
import org.fife.ui.rsyntaxtextarea.RSyntaxTextArea;

public class SaveXmlTextAreaAction
extends AbstractAction {
    private final RSyntaxTextArea textArea;
    private String dialogTitle;
    private static final Logger log = Logger.getLogger(SaveXmlTextAreaAction.class);

    public SaveXmlTextAreaAction(RSyntaxTextArea editArea, String dialogTitle) {
        super("Save as..");
        this.textArea = editArea;
        this.dialogTitle = dialogTitle;
        if (UISupport.isMac()) {
            this.putValue("AcceleratorKey", UISupport.getKeyStroke("menu S"));
        } else {
            this.putValue("AcceleratorKey", UISupport.getKeyStroke("ctrl S"));
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Loose catch block
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    public void actionPerformed(ActionEvent e) {
        File file = UISupport.getFileDialogs().saveAs(this, this.dialogTitle, ".xml", "XML Files (*.xml)", null);
        if (file == null) {
            return;
        }
        FileWriter writer = null;
        try {
            XmlObject xml = XmlUtils.createXmlObject(this.textArea.getText());
            xml.save(file);
        }
        catch (XmlException e1) {
            writer = new FileWriter(file);
            writer.write(this.textArea.getText());
            writer.close();
        }
        log.info((Object)("XML written to [" + file.getAbsolutePath() + "]"));
        Object var6_7 = null;
        if (writer == null) return;
        try {
            writer.close();
            return;
        }
        catch (IOException e12) {
            SoapUI.logError(e12);
        }
        return;
        {
            catch (IOException e1) {
                UISupport.showErrorMessage("Error saving xml to file: " + e1.getMessage());
                Object var6_8 = null;
                if (writer == null) return;
                try {
                    writer.close();
                    return;
                }
                catch (IOException e12) {
                    SoapUI.logError(e12);
                }
                return;
            }
        }
        catch (Throwable throwable) {
            Object var6_9 = null;
            if (writer == null) throw throwable;
            try {
                writer.close();
                throw throwable;
            }
            catch (IOException e12) {
                SoapUI.logError(e12);
            }
            throw throwable;
        }
    }
}

